/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

import com.bitctrl.lib.eclipse.databinding.provider.EnumIconDecorator;
import com.bitctrl.lib.eclipse.resources.WidgetImageRegistry;

/**
 * Dekoriert einen anderen LabelProvider mit Zusatzinformationen. Sucht hierfuer
 * zu einem Enum-Element eine passende Image-Ressource.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public class EnumIconLabelDecorator extends EnumIconDecorator.IconLabelDecorator {
	/**
	 * ein Widget für die Verwaltung der Image-Ressourcen.
	 */
	private final Widget widget;

	/**
	 * Konstruktor.
	 *
	 * @param widget ein Widget, bei dessen {@link Widget#dispose() Zerstörung} das
	 *               Bild wieder freigegeben wird.
	 */
	public EnumIconLabelDecorator(final Widget widget) {
		this.widget = widget;
	}

	@Override
	protected Image decorateEnumImage(final Image image, final String enumBaseName, final String enumElementName) {
		final String imageFileName = "/icons/" + enumBaseName + "_" + enumElementName + ".png";
		final ImageDescriptor imageDescriptor = Activator.getDefault().getImageDescriptor(imageFileName);
		if (null == imageDescriptor) {
			return null;
		}
		return WidgetImageRegistry.getInstance(widget).getImage(imageDescriptor);
	}

	@Override
	protected String decorateEnumText(final String text, final String simpleName, final String elementPartName) {
		return text;
	}
}
