/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import org.eclipse.emf.ecore.util.EcoreUtil;

import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien;
import de.bsvrz.buv.plugin.pua.ganglinien.model.observables.PUAGanglinienOO;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellSaveAction;

/**
 * Speichert Einstellungen fuer die Diagrammanzeige im Datenverteiler.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public class GanglinienSaveAction extends EMFModellSaveAction<PUAGanglinien> {

	/**
	 * Die Einstellungen aus dem Editor.
	 */
	private final PUAGanglinienOO puaGanglinien;

	/**
	 * Konstruktor.
	 *
	 * @param puaGanglinien das zu speichernde Objekt
	 */
	public GanglinienSaveAction(final PUAGanglinienOO puaGanglinien) {
		super(PUAGanglinien.class);
		this.puaGanglinien = puaGanglinien;
	}

	@Override
	protected String getCurrentName() {
		return puaGanglinien.getNameValue();
	}

	@Override
	protected PUAGanglinien getObject(final String newName) {
		final PUAGanglinien cp = EcoreUtil.copy(puaGanglinien.getValue());
		cp.setName(newName);

		// purging references to transient containments
		for (final Row<LineProperties> row : cp.getMatrix().getData()) {
			for (final RowEntry<LineProperties> entry : row.getEntries()) {
				final LineProperties value = entry.getValue();
				if (value != null) {
					value.getDefaults().setAxis(null);
					value.setDefaults(null);
				}
			}
		}
		return cp;
	}

	@Override
	protected void saveHook(final String newName) {
		puaGanglinien.setName(newName);
	}
}
