/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import java.util.NavigableMap;
import java.util.Objects;

import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType;
import de.bsvrz.buv.plugin.pua.ganglinien.model.observables.AxisPropertiesOO;
import de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO;
import net.randomice.emf.observables.runtime.IObservableAbstractListObject;
import net.randomice.emf.observables.runtime.IObservableObject;

/**
 * An Observable object wrapper for {@link LineProperties} with special handling
 * using an intermediate {@link WritableValue} for all attributes.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public class LinePropertiesOOSpecial implements IObservableObject<LineProperties> {

	/**
	 * der {@link DataBindingContext} zum Binden der Zwischenwerte.
	 */
	private final DataBindingContext dbc;

	/**
	 * die originalen Werte.
	 */
	private final LinePropertiesOO linePropertiesOO;

	@Override
	public EClass eClass() {
		return ModelPackage.Literals.LINE_PROPERTIES;
	}

	/**
	 * Konstruktor.
	 *
	 * @param linePropertiesOO die originalen Daten
	 */
	public LinePropertiesOOSpecial(final LinePropertiesOO linePropertiesOO) {
		this.linePropertiesOO = linePropertiesOO;
		dbc = new DataBindingContext();
	}

	// generic feature getters

	@Override
	public IObservableValue getValueFeature(final EStructuralFeature feature) {
		if (ModelPackage.Literals.LINE_PROPERTIES__SERIES_TYPE.equals(feature)) {
			return getSeriesType();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_STYLE.equals(feature)) {
			return getLineStyle();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_THICKNESS.equals(feature)) {
			return getLineThickness();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_RGB.equals(feature)) {
			return getLineRGB();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__MARKER_TYPE.equals(feature)) {
			return getMarkerType();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__FILL_RGB.equals(feature)) {
			return getFillRGB();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__AXIS.equals(feature)) {
			return getAxis().o;
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__VALUES.equals(feature)) {
			return getValues();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS.equals(feature)) {
			return getDefaults().o;
		}
		throw new UnsupportedOperationException("Feature " + feature + " not supported!");
	}

	@Override
	public IObservableList getListFeature(final EStructuralFeature feature) {
		throw new UnsupportedOperationException("Feature " + feature + " not supported!");
	}

	@Override
	public IObservableObject<?> getValueObject(final EReference feature) {
		if (ModelPackage.Literals.LINE_PROPERTIES__AXIS.equals(feature)) {
			return getAxis();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS.equals(feature)) {
			return getDefaults();
		}
		throw new UnsupportedOperationException("Feature " + feature + " not supported!");
	}

	@Override
	public IObservableAbstractListObject<?> getListObject(final EReference feature) {
		throw new UnsupportedOperationException("Feature " + feature + " not supported!");
	}

	// features from type LineProperties

	/**
	 * seriesType.
	 */
	private IObservableValue seriesType;

	/**
	 * seriesType Getter.
	 *
	 * @return der SeriesType
	 */
	public IObservableValue getSeriesType() {
		if (null == seriesType) {
			seriesType = wrap(linePropertiesOO.getSeriesType());
		}
		return seriesType;
	}

	/**
	 * Wert des seriesType.
	 *
	 * @return der Wert
	 */
	public SeriesType getSeriesTypeValue() {
		return (SeriesType) getSeriesType().getValue();
	}

	/**
	 * seriesType Setter.
	 *
	 * @param value der neue Wert
	 * @return das {@link IObservableValue}
	 */
	public IObservableValue setSeriesType(final SeriesType value) {
		getSeriesType().setValue(value);
		return seriesType;
	}

	/**
	 * lineStyle.
	 */
	private IObservableValue lineStyle;

	/**
	 * lineStyle Getter.
	 *
	 * @return der lineStyle
	 */
	public IObservableValue getLineStyle() {
		if (null == lineStyle) {
			lineStyle = wrap(linePropertiesOO.getLineStyle());
		}
		return lineStyle;
	}

	/**
	 * Wert des lineStyle.
	 *
	 * @return der Wert
	 */
	public LineStyle getLineStyleValue() {
		return (LineStyle) getLineStyle().getValue();
	}

	/**
	 * lineStyle Setter.
	 *
	 * @param value der neue Wert
	 * @return das {@link IObservableValue}
	 */
	public IObservableValue setLineStyle(final LineStyle value) {
		getLineStyle().setValue(value);
		return lineStyle;
	}

	/**
	 * lineThickness.
	 */
	private IObservableValue lineThickness;

	/**
	 * lineThickness Getter.
	 *
	 * @return der lineThickness
	 */
	public IObservableValue getLineThickness() {
		if (null == lineThickness) {
			lineThickness = wrap(linePropertiesOO.getLineThickness());
		}
		return lineThickness;
	}

	/**
	 * Wert des lineThickness.
	 *
	 * @return der Wert
	 */
	public LineThickness getLineThicknessValue() {
		return (LineThickness) getLineThickness().getValue();
	}

	/**
	 * lineThickness Setter.
	 *
	 * @param value der neue Wert
	 * @return das {@link IObservableValue}
	 */
	public IObservableValue setLineThickness(final LineThickness value) {
		getLineThickness().setValue(value);
		return lineThickness;
	}

	/**
	 * lineRGB.
	 */
	private IObservableValue lineRGB;

	/**
	 * lineRGB Getter.
	 *
	 * @return der lineRGB
	 */
	public IObservableValue getLineRGB() {
		if (null == lineRGB) {
			lineRGB = wrap(linePropertiesOO.getLineRGB());
		}
		return lineRGB;
	}

	/**
	 * Wert des lineRGB.
	 *
	 * @return der Wert
	 */
	public RGB getLineRGBValue() {
		return (RGB) getLineRGB().getValue();
	}

	/**
	 * lineRGB Setter.
	 *
	 * @param value der neue Wert
	 * @return das {@link IObservableValue}
	 */
	public IObservableValue setLineRGB(final RGB value) {
		getLineRGB().setValue(value);
		return lineRGB;
	}

	/**
	 * markerType.
	 */
	private IObservableValue markerType;

	/**
	 * markerType Getter.
	 *
	 * @return der markerType
	 */
	public IObservableValue getMarkerType() {
		if (null == markerType) {
			markerType = wrap(linePropertiesOO.getMarkerType());
		}
		return markerType;
	}

	/**
	 * Wert des markerType.
	 *
	 * @return der Wert
	 */
	public MarkerType getMarkerTypeValue() {
		return (MarkerType) getMarkerType().getValue();
	}

	/**
	 * markerType Setter.
	 *
	 * @param value der neue Wert
	 * @return das {@link IObservableValue}
	 */
	public IObservableValue setMarkerType(final MarkerType value) {
		getMarkerType().setValue(value);
		return markerType;
	}

	/**
	 * fillRGB.
	 */
	private IObservableValue fillRGB;

	/**
	 * fillRGB Getter.
	 *
	 * @return der fillRGB
	 */
	public IObservableValue getFillRGB() {
		if (null == fillRGB) {
			fillRGB = wrap(linePropertiesOO.getFillRGB());
		}
		return fillRGB;
	}

	/**
	 * Wert des fillRGB.
	 *
	 * @return der Wert
	 */
	public RGB getFillRGBValue() {
		return (RGB) getFillRGB().getValue();
	}

	/**
	 * fillRGB Setter.
	 *
	 * @param value der neue Wert
	 * @return das {@link IObservableValue}
	 */
	public IObservableValue setFillRGB(final RGB value) {
		getFillRGB().setValue(value);
		return fillRGB;
	}

	/**
	 * Wrappt ein {@link IObservableValue} mit einem {@link LoudWritableValue}, um
	 * alle Change-Ereignisse zu verarbeiten.
	 *
	 * @param originalValue der originale wert
	 * @return das wrappierende Objekt
	 */
	private IObservableValue wrap(final IObservableValue originalValue) {
		final WritableValue writableValue = new LoudWritableValue(originalValue.getRealm());
		dbc.bindValue(writableValue, originalValue);
		return writableValue;
	}

	@Override
	public boolean equals(final Object obj) {
		return Objects.equals(linePropertiesOO, obj);
	}

	/**
	 * Observable-Getter.
	 *
	 * @return des Observable
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getAxis()
	 */
	public AxisPropertiesOO getAxis() {
		return linePropertiesOO.getAxis();
	}

	/**
	 * Wert-Getter.
	 *
	 * @return der Wert
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getAxisValue()
	 */
	public AxisProperties getAxisValue() {
		return linePropertiesOO.getAxisValue();
	}

	/**
	 * Observable-Getter.
	 *
	 * @return des Observable
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getDefaults()
	 */
	public LinePropertiesOO getDefaults() {
		return linePropertiesOO.getDefaults();
	}

	/**
	 * Wert-Getter.
	 *
	 * @return der Wert
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getDefaultsValue()
	 */
	public LineProperties getDefaultsValue() {
		return linePropertiesOO.getDefaultsValue();
	}

	/**
	 * Observable-Getter für this.
	 *
	 * @return des Observable für this
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getObservable()
	 */
	@Override
	public final IObservableValue getObservable() {
		return linePropertiesOO.getObservable();
	}

	/**
	 * Wert-Getter für this.
	 *
	 * @return der Wert für this
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getValue()
	 */
	@Override
	public LineProperties getValue() {
		return linePropertiesOO.getValue();
	}

	/**
	 * Observable-Getter.
	 *
	 * @return des Observable
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getValues()
	 */
	public IObservableValue getValues() {
		return linePropertiesOO.getValues();
	}

	/**
	 * Wert-Getter.
	 *
	 * @return der Wert
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#getValuesValue()
	 */
	public NavigableMap<Long, Double> getValuesValue() {
		return linePropertiesOO.getValuesValue();
	}

	@Override
	public int hashCode() {
		return linePropertiesOO.hashCode();
	}

	/**
	 * Setter.
	 *
	 * @param value der neue Wert
	 * @return das gewrappte Observable
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#setAxis(de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties)
	 */
	public AxisPropertiesOO setAxis(final AxisProperties value) {
		return linePropertiesOO.setAxis(value);
	}

	/**
	 * Setter.
	 *
	 * @param value der neue Wert
	 * @return das gewrappte Observable
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#setDefaults(de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties)
	 */
	public LinePropertiesOO setDefaults(final LineProperties value) {
		return linePropertiesOO.setDefaults(value);
	}

	/**
	 * Setter.
	 *
	 * @param newValue der neue Wert
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#setValue(de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties)
	 */
	@Override
	public void setValue(final LineProperties newValue) {
		linePropertiesOO.setValue(newValue);
	}

	/**
	 * Setter.
	 *
	 * @param value der neue Wert
	 * @return das gewrappte Observable
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.observables.LinePropertiesOO#setValues(java.util.NavigableMap)
	 */
	public IObservableValue setValues(final NavigableMap<Long, Double> value) {
		return linePropertiesOO.setValues(value);
	}

	@Override
	public String toString() {
		return linePropertiesOO.toString();
	}
}
