/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import java.util.List;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EStructuralFeature;

import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.observables.MergedPropertiesOO;

/**
 * Dieses Runnable wird ausgefuert, wenn auf einen Radiergummi in der Zeile fuer
 * die Dateneinstellungn geklickt wurde. Es setzt die betreffenden
 * Basis-Einstellungen in der Matrix auf den dafür zugeordneten Standard-Wert
 * zurück. Die Einstellungszeile wird automatisch durch die Änderung in den
 * Einstellungen neu berechnet.
 *
 * @see MergedPropertiesUpdater
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
class ResetToDefaults implements Runnable {

	/**
	 * die PuaGanglinien-FormPage.
	 */
	private final PuaGanglinienFormPage puaGanglinienFormPage;
	/**
	 * der aktuelle Wert.
	 */
	private final IObservableValue value;
	/**
	 * der Standard-Wert.
	 */
	private final IObservableValue defaultValue;
	/**
	 * Das Feature, das zu setzen ist.
	 */
	private final EStructuralFeature feature;

	/**
	 * Konstruktor.
	 *
	 * @param puaGanglinienFormPage die FormPage
	 * @param value                 der aktuelle Wert
	 * @param defaultValue          der Standard-Wert
	 * @param feature               das zu setzende Feature
	 */
	public ResetToDefaults(final PuaGanglinienFormPage puaGanglinienFormPage, final IObservableValue value,
			final IObservableValue defaultValue, final EStructuralFeature feature) {
		this.puaGanglinienFormPage = puaGanglinienFormPage;
		this.value = value;
		this.defaultValue = defaultValue;
		this.feature = feature;
	}

	@Override
	public void run() {
		final MergedPropertiesOO merged = puaGanglinienFormPage.getRoot().getPuaGanglinien().getMergedProperties();
		final List<LineProperties> selected = merged.getSelectedList();
		final boolean unknown = merged.getUnknownMultiFeaturesList().contains(feature);
		boolean hasSet = false;
		final Object dv = null == defaultValue ? null : defaultValue.getValue();
		for (final LineProperties sel : selected) {
			final Object oldValue = sel.eGet(feature);
			Object setValue = dv;
			if (!unknown) {
				setValue = sel.getDefaults().eGet(feature);
			}
			if (oldValue != setValue && (null == setValue || !setValue.equals(oldValue))) {
				sel.eSet(feature, setValue);
				hasSet = true;
			}
		}
		if (hasSet) {
			value.setValue(dv);
			merged.getUnknownMultiFeatures().remove(feature);
			puaGanglinienFormPage.getMatrixRefresher().handleValueChange(null);
		}
	}
}
