/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import java.util.List;
import java.util.Locale;

import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;

import com.ibm.icu.util.ULocale;

import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;

public class ZustandsNumberFormatSpecifierImpl extends JavaNumberFormatSpecifierImpl {

	private final IntegerAttributeType type;
	private final IntegerValueRange range;
	private final List<IntegerValueState> states;

	public ZustandsNumberFormatSpecifierImpl(final IntegerAttributeType type) {
		setPattern("");
		this.type = type;
		range = type.getRange();
		if (range == null) {
			states = type.getStates();
		} else {
			states = null;
		}
	}

	private String format(final Number number) {
		if (number == null) {
			return "";
		}

		final long code = number.longValue() - 1;
		for (final IntegerValueState state : states) {
			if (state.getValue() == code) {
				return state.getName();
			}
		}

		return "";
	}

	@Override
	public String format(final Number number, final ULocale lo) {
		if (states == null) {
			return super.format(number, lo);
		}
		return format(number);
	}

	@Override
	public String format(final double dValue, final Locale lo) {
		if (states == null) {
			return super.format(dValue, lo);
		}
		return format(dValue);
	}

	@Override
	public String format(final double dValue, final ULocale lo) {
		if (states == null) {
			return super.format(dValue, lo);
		}
		return format(dValue);
	}

	@Override
	public JavaNumberFormatSpecifier copyInstance() {
		return new ZustandsNumberFormatSpecifierImpl(type);
	}

}