/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien.data;

import com.bitctrl.lib.eclipse.databinding.realm.results.VoidResult;

import de.bsvrz.buv.plugin.pua.ganglinien.model.observables.RootOO;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData;

/**
 * Speichert die Metadaten fuer die Aggregation.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
final class AggDataSetup implements VoidResult {
	/**
	 * Die Aggregationsdaten aus dem Protokoll.
	 */
	private final ProtocolAggregationData aggData;
	/**
	 * Das Root-Objekt.
	 */
	private final RootOO root;

	/**
	 * Konstruktor.
	 *
	 * @param root    das Root-Objekt
	 * @param aggData Die Aggregationsdaten aus dem Protokoll.
	 */
	AggDataSetup(final RootOO root, final ProtocolAggregationData aggData) {
		this.root = root;
		this.aggData = aggData;
	}

	@Override
	public void run() {
		root.getProtokoll().setAggregationData(aggData);
	}
}
