/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.pua.ganglinien.data;

import java.io.Serializable;

import de.bsvrz.pua.prot.util.ProcessingInformation.ApplyAggregation;

/**
 * Repräsentation des Aggregationstyps im Einstellungsspeicher für eine
 * grafische Darstellung eines PuA-Protokolls.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public class AggregationsTyp implements Serializable, Comparable<AggregationsTyp> {

	/** ID für sie Serialisierung. */
	private static final long serialVersionUID = 1L;

	/** der Name des Typs. */
	private String name;

	/** der Aggregationstyp. */
	private ApplyAggregation kind = ApplyAggregation.LISTE;

	/**
	 * liefert den definierten Name.
	 *
	 * @return der Name
	 */
	public final String getName() {
		return name;
	}

	/**
	 * setzt den Name für den Typ.
	 *
	 * @param name der Name
	 */
	public final void setName(final String name) {
		this.name = name;
	}

	/**
	 * liefert die Aggregationsart.
	 *
	 * @return die Art
	 */
	public final ApplyAggregation getKind() {
		return kind;
	}

	/**
	 * setzt die Aggregationsart.
	 *
	 * @param kind die Art
	 */
	public final void setKind(final ApplyAggregation kind) {
		this.kind = kind;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((kind == null) ? 0 : kind.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if ((obj == null) || (getClass() != obj.getClass())) {
			return false;
		}
		final AggregationsTyp other = (AggregationsTyp) obj;
		if (kind != other.kind) {
			return false;
		}
		if (name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!name.equals(other.name)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {

		final StringBuilder result = new StringBuilder();
		switch (kind) {
		case GESAMT_OBJEKT:
		case GESAMT_SPALTE:
			result.append("GESAMT: ");
			break;
		case INTERVALL_OBJEKT:
		case INTERVALL_SPALTE:
			result.append("INTERVALL: ");
			break;
		case LISTE:
			break;
		default:
			break;
		}
		result.append(name);
		return result.toString();
	}

	@Override
	public int compareTo(final AggregationsTyp other) {

		int result = name.compareTo(other.name);
		if (result == 0) {
			result = kind.compareTo(other.kind);
		}

		return result;
	}
}
