/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien.data;

import com.bitctrl.lib.eclipse.databinding.realm.RealmRunnable;

import de.bsvrz.buv.plugin.pua.daten.AggregationDatenSatz;
import de.bsvrz.buv.plugin.pua.daten.NoChangeDatenSatz;
import de.bsvrz.buv.plugin.pua.daten.ProtokollDatenLeser;
import de.bsvrz.buv.plugin.pua.daten.ProtokollDatenListener;
import de.bsvrz.buv.plugin.pua.daten.RohDatenSatz;
import de.bsvrz.buv.plugin.pua.daten.SimpleDatenSatz;
import de.bsvrz.buv.plugin.pua.ganglinien.PuaGanglinienFormPage;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData;

/**
 * Listener fuer die Protokoll-Initialisierung. Delegiert an die Klassen in
 * diesem Package.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public final class DatenListener implements ProtokollDatenListener {
	/**
	 * die FormPage.
	 */
	private final PuaGanglinienFormPage puaGanglinienFormPage;

	/**
	 * Konstruktor.
	 *
	 * @param puaGanglinienFormPage die FormPage
	 */
	public DatenListener(final PuaGanglinienFormPage puaGanglinienFormPage) {
		this.puaGanglinienFormPage = puaGanglinienFormPage;
		resultDataProcessor = new ProcessResultData(puaGanglinienFormPage);
	}

	@Override
	public void adminDataEmpfangen(final ProtocolAdministrationData adminData) {
		RealmRunnable.syncExec(puaGanglinienFormPage.getRoot().o.getRealm(),
				new AdminDataSetup(puaGanglinienFormPage, adminData));
	}

	@Override
	public void aggregationDataEmpfangen(final ProtocolAggregationData aggData) {
		RealmRunnable.asyncExec(puaGanglinienFormPage.getRoot().o.getRealm(),
				new AggDataSetup(puaGanglinienFormPage.getRoot(), aggData));
	}

	/**
	 * Verarbeitung der eigentlichen Daten.
	 */
	private final ProcessResultData resultDataProcessor;

	@Override
	public void resultDataEmpfangen(final SimpleDatenSatz resultData) {
		resultDataProcessor.setResultData(resultData);
		RealmRunnable.syncExec(puaGanglinienFormPage.getRoot().o.getRealm(), resultDataProcessor);
	}

	@Override
	public void noChangesEmpfangen(final NoChangeDatenSatz datenSatz) {
		resultDataProcessor.setResultData(datenSatz);
		RealmRunnable.syncExec(puaGanglinienFormPage.getRoot().o.getRealm(), resultDataProcessor);
	}

	@Override
	public void protokollEndeMitFehler(final String errorMsg) {
		protokollEnde();
	}

	@Override
	public void protokollEnde() {
		RealmRunnable.asyncExec(puaGanglinienFormPage.getRoot().o.getRealm(), new AggDataFillup(puaGanglinienFormPage));
	}

	/**
	 * Empfängt alle bereits empfangenen Daten und zusätzlich alle zukünftigen
	 * Daten.
	 *
	 * @param datenLeser der ProtokollDatenLeser
	 */
	public void replayAndListen(final ProtokollDatenLeser datenLeser) {
		datenLeser.getLock().lock();
		try {
			datenLeser.addProtokollDatenListener(this);
			if (null != datenLeser.getAdminData()) {
				adminDataEmpfangen(datenLeser.getAdminData());
			}
			if (null != datenLeser.getAggData()) {
				aggregationDataEmpfangen(datenLeser.getAggData());
			}

			for (final RohDatenSatz rohDaten : datenLeser.getProtokollDaten()) {
				if (rohDaten instanceof SimpleDatenSatz) {
					resultDataEmpfangen((SimpleDatenSatz) rohDaten);
				} else if (rohDaten instanceof AggregationDatenSatz) {
					aggregationResultDataEmpfangen((AggregationDatenSatz) rohDaten);
				} else if (rohDaten instanceof NoChangeDatenSatz) {
					noChangesEmpfangen((NoChangeDatenSatz) rohDaten);
				}
			}
		} finally {
			if (!datenLeser.isAktiv()) {
				protokollEnde();
			}
			datenLeser.getLock().unlock();
		}
	}

	@Override
	public void aggregationResultDataEmpfangen(final AggregationDatenSatz daten) {
		resultDataProcessor.setResultData(daten);
		RealmRunnable.syncExec(puaGanglinienFormPage.getRoot().o.getRealm(), resultDataProcessor);
	}
}
