/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.pua.ganglinien.internal;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.berechtigung.Berechtigungen;
import de.bsvrz.buv.rw.basislib.einstellungen.Einstellungen;

/**
 * Interne Komponente zur Bereitstellung der für das Plug-in erforderlichen
 * Services.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class RahmenwerkService {

	private static RahmenwerkService service;

	private Rahmenwerk rahmenWerk;
	private Berechtigungen berechtigungen;
	private Einstellungen einstellungen;

	/**
	 * liefert die globale Instanz der Komponente.
	 *
	 * @return die Komponente
	 */
	public static RahmenwerkService getService() {
		return RahmenwerkService.service;
	}

	/** aktiviert die Komponente. */
	protected void activate() {
		RahmenwerkService.service = this;
	}

	/** deaktiviert die Komponente. */
	protected void deactivate() {
		RahmenwerkService.service = null;
	}

	/**
	 * bindet einen Rahmenwerk-Service an die Komponente.
	 *
	 * @param newRahmenWerk der Service
	 */
	protected void bindRahmenwerk(final Rahmenwerk newRahmenWerk) {
		this.rahmenWerk = newRahmenWerk;
	}

	/**
	 * entfernt einen Rahmenwerk-Service von der Komponente.
	 *
	 * @param newRahmenWerk der Service
	 */
	protected void unbindRahmenwerk(final Rahmenwerk newRahmenWerk) {
		this.rahmenWerk = null;
	}

	/**
	 * liefert den {@link Rahmenwerk}-Service.
	 *
	 * @return den Service
	 */
	public Rahmenwerk getRahmenWerk() {
		return rahmenWerk;
	}

	/**
	 * bindet einen {@link Berechtigungen}-Service an die Komponente.
	 *
	 * @param newBerechtigungen der Service
	 */
	protected void bindBerechtigungen(final Berechtigungen newBerechtigungen) {
		this.berechtigungen = newBerechtigungen;
	}

	/**
	 * entfernt einen {@link Berechtigungen}-Service von der Komponente.
	 *
	 * @param newBerechtigungen der Service
	 */
	protected void unbindBerechtigungen(final Berechtigungen newBerechtigungen) {
		this.berechtigungen = null;
	}

	/**
	 * liefert den {@link Berechtigungen}-Service.
	 *
	 * @return den Service
	 */
	public Berechtigungen getBerechtigungen() {
		return berechtigungen;
	}

	/**
	 * bindet einen {@link Einstellungen}-Service an die Komponente.
	 *
	 * @param newEinstellungen der Service
	 */
	protected void bindEinstellungen(final Einstellungen newEinstellungen) {
		this.einstellungen = newEinstellungen;
	}

	/**
	 * entfernt einen {@link Einstellungen}-Service von der Komponente.
	 *
	 * @param newEinstellungen der Service
	 */
	protected void unbindEinstellungen(final Einstellungen newEinstellungen) {
		this.einstellungen = null;
	}

	/**
	 * liefert den {@link Einstellungen}-Service.
	 *
	 * @return den Service
	 */
	public Einstellungen getEinstellungen() {
		return einstellungen;
	}

}
