/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model;

import java.util.NavigableMap;

import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.RGB;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Line Properties</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getSeriesType <em>Series Type</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineStyle <em>Line Style</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineThickness <em>Line Thickness</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineRGB <em>Line RGB</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getMarkerType <em>Marker Type</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getFillRGB <em>Fill RGB</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getAxis <em>Axis</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getValues <em>Values</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getDefaults <em>Defaults</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties()
 * @model
 * @generated
 */
public interface LineProperties extends EObject {
	/**
	 * Returns the value of the '<em><b>Series Type</b></em>' attribute. The
	 * literals are from the enumeration
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Series Type</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Series Type</em>' attribute.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * @see #setSeriesType(SeriesType)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_SeriesType()
	 * @model
	 * @generated
	 */
	SeriesType getSeriesType();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getSeriesType <em>Series Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Series Type</em>' attribute.
	 * @see #getSeriesType()
	 * @generated
	 */
	void setSeriesType(SeriesType value);

	/**
	 * Returns the value of the '<em><b>Line Style</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Line Style</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Line Style</em>' attribute.
	 * @see #setLineStyle(LineStyle)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_LineStyle()
	 * @model dataType="org.eclipse.birt.chart.model.attribute.LineStyleObject"
	 * @generated
	 */
	LineStyle getLineStyle();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineStyle <em>Line Style</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Line Style</em>' attribute.
	 * @see #getLineStyle()
	 * @generated
	 */
	void setLineStyle(LineStyle value);

	/**
	 * Returns the value of the '<em><b>Line Thickness</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Line Thickness</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Line Thickness</em>' attribute.
	 * @see #setLineThickness(LineThickness)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_LineThickness()
	 * @model 
	 *        dataType="de.bsvrz.buv.plugin.pua.ganglinien.model.LineThinknessObject"
	 * @generated
	 */
	LineThickness getLineThickness();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineThickness <em>Line Thickness</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Line Thickness</em>' attribute.
	 * @see #getLineThickness()
	 * @generated
	 */
	void setLineThickness(LineThickness value);

	/**
	 * Returns the value of the '<em><b>Line RGB</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Line RGB</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Line RGB</em>' attribute.
	 * @see #setLineRGB(RGB)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_LineRGB()
	 * @model dataType="de.bsvrz.buv.plugin.pua.ganglinien.model.RGB"
	 * @generated
	 */
	RGB getLineRGB();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineRGB
	 * <em>Line RGB</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value
	 *            the new value of the '<em>Line RGB</em>' attribute.
	 * @see #getLineRGB()
	 * @generated
	 */
	void setLineRGB(RGB value);

	/**
	 * Returns the value of the '<em><b>Marker Type</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Marker Type</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Marker Type</em>' attribute.
	 * @see #setMarkerType(MarkerType)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_MarkerType()
	 * @model dataType="org.eclipse.birt.chart.model.attribute.MarkerTypeObject"
	 * @generated
	 */
	MarkerType getMarkerType();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getMarkerType <em>Marker Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Marker Type</em>' attribute.
	 * @see #getMarkerType()
	 * @generated
	 */
	void setMarkerType(MarkerType value);

	/**
	 * Returns the value of the '<em><b>Fill RGB</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Fill RGB</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Fill RGB</em>' attribute.
	 * @see #setFillRGB(RGB)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_FillRGB()
	 * @model dataType="de.bsvrz.buv.plugin.pua.ganglinien.model.RGB"
	 * @generated
	 */
	RGB getFillRGB();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getFillRGB
	 * <em>Fill RGB</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value
	 *            the new value of the '<em>Fill RGB</em>' attribute.
	 * @see #getFillRGB()
	 * @generated
	 */
	void setFillRGB(RGB value);

	/**
	 * Returns the value of the '<em><b>Axis</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getReferencedLines <em>Referenced Lines</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Axis</em>' reference isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Axis</em>' reference.
	 * @see #setAxis(AxisProperties)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_Axis()
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getReferencedLines
	 * @model opposite="referencedLines" required="true"
	 * @generated
	 */
	AxisProperties getAxis();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getAxis <em>Axis</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Axis</em>' reference.
	 * @see #getAxis()
	 * @generated
	 */
	void setAxis(AxisProperties value);

	/**
	 * Returns the value of the '<em><b>Values</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Values</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Values</em>' attribute.
	 * @see #setValues(NavigableMap)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_Values()
	 * @model dataType="de.bsvrz.buv.plugin.pua.ganglinien.model.NavigableMap<org.eclipse.emf.ecore.ELongObject, org.eclipse.emf.ecore.EDoubleObject>"
	 *        transient="true"
	 * @generated
	 */
	NavigableMap<Long, Double> getValues();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getValues
	 * <em>Values</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value
	 *            the new value of the '<em>Values</em>' attribute.
	 * @see #getValues()
	 * @generated
	 */
	void setValues(NavigableMap<Long, Double> value);

	/**
	 * Returns the value of the '<em><b>Defaults</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Defaults</em>' containment reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Defaults</em>' containment reference.
	 * @see #setDefaults(LineProperties)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getLineProperties_Defaults()
	 * @model containment="true" transient="true"
	 * @generated
	 */
	LineProperties getDefaults();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getDefaults <em>Defaults</em>}' containment reference.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Defaults</em>' containment reference.
	 * @see #getDefaults()
	 * @generated
	 */
	void setDefaults(LineProperties value);

} // LineProperties
