/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelFactory
 * @model kind="package"
 * @generated
 */
public interface ModelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "model";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.bitctrl.de/bsvrz/buv/pua/model";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "de.bsvrz.buv.plugin.pua.ganglinien.model";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	ModelPackage eINSTANCE = de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.RootImpl <em>Root</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.RootImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getRoot()
	 * @generated
	 */
	int ROOT = 0;

	/**
	 * The feature id for the '<em><b>Protokoll</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__PROTOKOLL = 0;

	/**
	 * The feature id for the '<em><b>Pua Ganglinien</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT__PUA_GANGLINIEN = 1;

	/**
	 * The number of structural features of the '<em>Root</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROOT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl <em>Protokoll</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtokoll()
	 * @generated
	 */
	int PROTOKOLL = 1;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOKOLL__ROOT = 0;

	/**
	 * The feature id for the '<em><b>Processing Parameter</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOKOLL__PROCESSING_PARAMETER = 1;

	/**
	 * The feature id for the '<em><b>Administration Data</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOKOLL__ADMINISTRATION_DATA = 2;

	/**
	 * The feature id for the '<em><b>Aggregation Data</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOKOLL__AGGREGATION_DATA = 3;

	/**
	 * The number of structural features of the '<em>Protokoll</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROTOKOLL_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl <em>PUA Ganglinien</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getPUAGanglinien()
	 * @generated
	 */
	int PUA_GANGLINIEN = 2;

	/**
	 * The feature id for the '<em><b>Root</b></em>' container reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__ROOT = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__NAME = 1;

	/**
	 * The feature id for the '<em><b>Matrix</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__MATRIX = 2;

	/**
	 * The feature id for the '<em><b>Matrix Grid</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__MATRIX_GRID = 3;

	/**
	 * The feature id for the '<em><b>Precision Map</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__PRECISION_MAP = 4;

	/**
	 * The feature id for the '<em><b>Merged Properties</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__MERGED_PROPERTIES = 5;

	/**
	 * The feature id for the '<em><b>Axes</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__AXES = 6;

	/**
	 * The feature id for the '<em><b>Current Axis</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__CURRENT_AXIS = 7;

	/**
	 * The feature id for the '<em><b>Zoom XFrom</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__ZOOM_XFROM = 8;

	/**
	 * The feature id for the '<em><b>Zoom XTo</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__ZOOM_XTO = 9;

	/**
	 * The feature id for the '<em><b>XAxis Step</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__XAXIS_STEP = 10;

	/**
	 * The feature id for the '<em><b>Auto Update Diagram</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM = 11;

	/**
	 * The feature id for the '<em><b>Show Data Table</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__SHOW_DATA_TABLE = 12;

	/**
	 * The feature id for the '<em><b>Background Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__BACKGROUND_COLOR = 13;

	/**
	 * The feature id for the '<em><b>Helper Line Color</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__HELPER_LINE_COLOR = 14;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__TITLE = 15;

	/**
	 * The feature id for the '<em><b>Show Helper Lines</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN__SHOW_HELPER_LINES = 16;

	/**
	 * The number of structural features of the '<em>PUA Ganglinien</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUA_GANGLINIEN_FEATURE_COUNT = 17;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl <em>Line Properties</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getLineProperties()
	 * @generated
	 */
	int LINE_PROPERTIES = 3;

	/**
	 * The feature id for the '<em><b>Series Type</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__SERIES_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Line Style</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__LINE_STYLE = 1;

	/**
	 * The feature id for the '<em><b>Line Thickness</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__LINE_THICKNESS = 2;

	/**
	 * The feature id for the '<em><b>Line RGB</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__LINE_RGB = 3;

	/**
	 * The feature id for the '<em><b>Marker Type</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__MARKER_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Fill RGB</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__FILL_RGB = 5;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__AXIS = 6;

	/**
	 * The feature id for the '<em><b>Values</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__VALUES = 7;

	/**
	 * The feature id for the '<em><b>Defaults</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES__DEFAULTS = 8;

	/**
	 * The number of structural features of the '<em>Line Properties</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_PROPERTIES_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl <em>Axis Properties</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAxisProperties()
	 * @generated
	 */
	int AXIS_PROPERTIES = 4;

	/**
	 * The feature id for the '<em><b>Axis Side</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__AXIS_SIDE = 0;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__TITLE = 1;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__MIN = 2;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__MAX = 3;

	/**
	 * The feature id for the '<em><b>Visible Grid</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__VISIBLE_GRID = 4;

	/**
	 * The feature id for the '<em><b>Step</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__STEP = 5;

	/**
	 * The feature id for the '<em><b>Referenced Lines</b></em>' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__REFERENCED_LINES = 6;

	/**
	 * The feature id for the '<em><b>Defaults</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES__DEFAULTS = 7;

	/**
	 * The number of structural features of the '<em>Axis Properties</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AXIS_PROPERTIES_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.MergedPropertiesImpl <em>Merged Properties</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.MergedPropertiesImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getMergedProperties()
	 * @generated
	 */
	int MERGED_PROPERTIES = 5;

	/**
	 * The feature id for the '<em><b>Pua Ganglinien</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MERGED_PROPERTIES__PUA_GANGLINIEN = 0;

	/**
	 * The feature id for the '<em><b>Selected</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MERGED_PROPERTIES__SELECTED = 1;

	/**
	 * The feature id for the '<em><b>Merged</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MERGED_PROPERTIES__MERGED = 2;

	/**
	 * The feature id for the '<em><b>Unknown Multi Features</b></em>' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MERGED_PROPERTIES__UNKNOWN_MULTI_FEATURES = 3;

	/**
	 * The feature id for the '<em><b>Updating</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MERGED_PROPERTIES__UPDATING = 4;

	/**
	 * The number of structural features of the '<em>Merged Properties</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MERGED_PROPERTIES_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '<em>Aggregations Typ</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.ganglinien.data.AggregationsTyp
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAggregationsTyp()
	 * @generated
	 */
	int AGGREGATIONS_TYP = 24;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * <em>Series Type</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getSeriesType()
	 * @generated
	 */
	int SERIES_TYPE = 6;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
	 * <em>Line Thickness</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getLineThickness()
	 * @generated
	 */
	int LINE_THICKNESS = 7;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide <em>Axis Side</em>}' enum.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAxisSide()
	 * @generated
	 */
	int AXIS_SIDE = 8;

	/**
	 * The meta object id for the '<em>Processing Parameter</em>' data type.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.pua.prot.util.ProcessingParameter
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProcessingParameter()
	 * @generated
	 */
	int PROCESSING_PARAMETER = 9;

	/**
	 * The meta object id for the '<em>Protocol Administration Data</em>' data type.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolAdministrationData()
	 * @generated
	 */
	int PROTOCOL_ADMINISTRATION_DATA = 10;

	/**
	 * The meta object id for the '<em>Protocol Aggregation Data</em>' data type.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolAggregationData()
	 * @generated
	 */
	int PROTOCOL_AGGREGATION_DATA = 11;

	/**
	 * The meta object id for the '<em>Protocol No Changes</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolNoChanges
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolNoChanges()
	 * @generated
	 */
	int PROTOCOL_NO_CHANGES = 12;

	/**
	 * The meta object id for the '<em>Protocol Result Data</em>' data type.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolResultData
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolResultData()
	 * @generated
	 */
	int PROTOCOL_RESULT_DATA = 13;

	/**
	 * The meta object id for the '<em>Two Dimensional Map</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see com.bitctrl.util.TwoDimensionalMap
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getTwoDimensionalMap()
	 * @generated
	 */
	int TWO_DIMENSIONAL_MAP = 14;

	/**
	 * The meta object id for the '<em>Matrix Grid</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getMatrixGrid()
	 * @generated
	 */
	int MATRIX_GRID = 15;

	/**
	 * The meta object id for the '<em>Column</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.pua.prot.client.dataobject.Column
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getColumn()
	 * @generated
	 */
	int COLUMN = 16;

	/**
	 * The meta object id for the '<em>Series Type Object</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getSeriesTypeObject()
	 * @generated
	 */
	int SERIES_TYPE_OBJECT = 17;

	/**
	 * The meta object id for the '<em>Line Thinkness Object</em>' data type.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getLineThinknessObject()
	 * @generated
	 */
	int LINE_THINKNESS_OBJECT = 18;

	/**
	 * The meta object id for the '<em>RGB</em>' data type.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see org.eclipse.swt.graphics.RGB
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getRGB()
	 * @generated
	 */
	int RGB = 19;

	/**
	 * The meta object id for the '<em>Axis Side Object</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAxisSideObject()
	 * @generated
	 */
	int AXIS_SIDE_OBJECT = 20;

	/**
	 * The meta object id for the '<em>Result Value</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.pua.prot.util.ResultValue
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getResultValue()
	 * @generated
	 */
	int RESULT_VALUE = 21;

	/**
	 * The meta object id for the '<em>Navigable Set</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see java.util.NavigableSet
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getNavigableSet()
	 * @generated
	 */
	int NAVIGABLE_SET = 22;

	/**
	 * The meta object id for the '<em>Navigable Map</em>' data type. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see java.util.NavigableMap
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getNavigableMap()
	 * @generated
	 */
	int NAVIGABLE_MAP = 23;

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.Root <em>Root</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Root
	 * @generated
	 */
	EClass getRoot();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.Root#getProtokoll <em>Protokoll</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Protokoll</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Root#getProtokoll()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_Protokoll();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.Root#getPuaGanglinien <em>Pua Ganglinien</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Pua Ganglinien</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Root#getPuaGanglinien()
	 * @see #getRoot()
	 * @generated
	 */
	EReference getRoot_PuaGanglinien();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll <em>Protokoll</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Protokoll</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll
	 * @generated
	 */
	EClass getProtokoll();

	/**
	 * Returns the meta object for the container reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getRoot()
	 * @see #getProtokoll()
	 * @generated
	 */
	EReference getProtokoll_Root();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getProcessingParameter <em>Processing Parameter</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Processing Parameter</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getProcessingParameter()
	 * @see #getProtokoll()
	 * @generated
	 */
	EAttribute getProtokoll_ProcessingParameter();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getAdministrationData
	 * <em>Administration Data</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Administration Data</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getAdministrationData()
	 * @see #getProtokoll()
	 * @generated
	 */
	EAttribute getProtokoll_AdministrationData();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getAggregationData
	 * <em>Aggregation Data</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Aggregation Data</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll#getAggregationData()
	 * @see #getProtokoll()
	 * @generated
	 */
	EAttribute getProtokoll_AggregationData();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien <em>PUA Ganglinien</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>PUA Ganglinien</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien
	 * @generated
	 */
	EClass getPUAGanglinien();

	/**
	 * Returns the meta object for the container reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getRoot <em>Root</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Root</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getRoot()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EReference getPUAGanglinien_Root();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getName()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_Name();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrix <em>Matrix</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Matrix</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrix()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EReference getPUAGanglinien_Matrix();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrixGrid <em>Matrix Grid</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Matrix Grid</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrixGrid()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_MatrixGrid();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getPrecisionMap <em>Precision Map</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Precision Map</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getPrecisionMap()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_PrecisionMap();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMergedProperties
	 * <em>Merged Properties</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the containment reference '
	 *         <em>Merged Properties</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMergedProperties()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EReference getPUAGanglinien_MergedProperties();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getAxes <em>Axes</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Axes</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getAxes()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EReference getPUAGanglinien_Axes();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getCurrentAxis <em>Current Axis</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Current Axis</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getCurrentAxis()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EReference getPUAGanglinien_CurrentAxis();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXFrom <em>Zoom XFrom</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom XFrom</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXFrom()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_ZoomXFrom();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXTo <em>Zoom XTo</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom XTo</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXTo()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_ZoomXTo();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getXAxisStep <em>XAxis Step</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>XAxis Step</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getXAxisStep()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_XAxisStep();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isAutoUpdateDiagram
	 * <em>Auto Update Diagram</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Auto Update Diagram</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isAutoUpdateDiagram()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_AutoUpdateDiagram();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowDataTable <em>Show Data Table</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show Data Table</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowDataTable()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_ShowDataTable();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getBackgroundColor
	 * <em>Background Color</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Background Color</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getBackgroundColor()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_BackgroundColor();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getHelperLineColor
	 * <em>Helper Line Color</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Helper Line Color</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getHelperLineColor()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_HelperLineColor();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getTitle()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_Title();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowHelperLines
	 * <em>Show Helper Lines</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Show Helper Lines</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowHelperLines()
	 * @see #getPUAGanglinien()
	 * @generated
	 */
	EAttribute getPUAGanglinien_ShowHelperLines();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties <em>Line Properties</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Line Properties</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties
	 * @generated
	 */
	EClass getLineProperties();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getSeriesType <em>Series Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Series Type</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getSeriesType()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_SeriesType();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineStyle <em>Line Style</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line Style</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineStyle()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_LineStyle();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineThickness <em>Line Thickness</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line Thickness</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineThickness()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_LineThickness();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineRGB <em>Line RGB</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Line RGB</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getLineRGB()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_LineRGB();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getMarkerType <em>Marker Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Marker Type</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getMarkerType()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_MarkerType();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getFillRGB <em>Fill RGB</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fill RGB</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getFillRGB()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_FillRGB();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getAxis <em>Axis</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Axis</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getAxis()
	 * @see #getLineProperties()
	 * @generated
	 */
	EReference getLineProperties_Axis();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Values</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getValues()
	 * @see #getLineProperties()
	 * @generated
	 */
	EAttribute getLineProperties_Values();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getDefaults <em>Defaults</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Defaults</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties#getDefaults()
	 * @see #getLineProperties()
	 * @generated
	 */
	EReference getLineProperties_Defaults();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties <em>Axis Properties</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Axis Properties</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties
	 * @generated
	 */
	EClass getAxisProperties();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getTitle()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EAttribute getAxisProperties_Title();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getAxisSide <em>Axis Side</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Axis Side</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getAxisSide()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EAttribute getAxisProperties_AxisSide();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getMin <em>Min</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getMin()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EAttribute getAxisProperties_Min();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getMax <em>Max</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getMax()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EAttribute getAxisProperties_Max();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getVisibleGrid <em>Visible Grid</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visible Grid</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getVisibleGrid()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EAttribute getAxisProperties_VisibleGrid();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getStep <em>Step</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Step</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getStep()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EAttribute getAxisProperties_Step();

	/**
	 * Returns the meta object for the reference list '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getReferencedLines
	 * <em>Referenced Lines</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the reference list '<em>Referenced Lines</em>
	 *         '.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getReferencedLines()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EReference getAxisProperties_ReferencedLines();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getDefaults <em>Defaults</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Defaults</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties#getDefaults()
	 * @see #getAxisProperties()
	 * @generated
	 */
	EReference getAxisProperties_Defaults();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties
	 * <em>Merged Properties</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Merged Properties</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties
	 * @generated
	 */
	EClass getMergedProperties();

	/**
	 * Returns the meta object for the container reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getPuaGanglinien <em>Pua Ganglinien</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Pua Ganglinien</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getPuaGanglinien()
	 * @see #getMergedProperties()
	 * @generated
	 */
	EReference getMergedProperties_PuaGanglinien();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getSelected <em>Selected</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Selected</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getSelected()
	 * @see #getMergedProperties()
	 * @generated
	 */
	EReference getMergedProperties_Selected();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getMerged <em>Merged</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Merged</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getMerged()
	 * @see #getMergedProperties()
	 * @generated
	 */
	EReference getMergedProperties_Merged();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getUnknownMultiFeatures <em>Unknown Multi Features</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the reference list '<em>Unknown Multi Features</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getUnknownMultiFeatures()
	 * @see #getMergedProperties()
	 * @generated
	 */
	EReference getMergedProperties_UnknownMultiFeatures();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#isUpdating <em>Updating</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Updating</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#isUpdating()
	 * @see #getMergedProperties()
	 * @generated
	 */
	EAttribute getMergedProperties_Updating();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.buv.plugin.ganglinien.data.AggregationsTyp <em>Aggregations Typ</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Aggregations Typ</em>'.
	 * @see de.bsvrz.buv.plugin.ganglinien.data.AggregationsTyp
	 * @model instanceClass="de.bsvrz.buv.plugin.ganglinien.data.AggregationsTyp"
	 * @generated
	 */
	EDataType getAggregationsTyp();

	/**
	 * Returns the meta object for enum '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType <em>Series Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Series Type</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * @generated
	 */
	EEnum getSeriesType();

	/**
	 * Returns the meta object for enum '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness <em>Line Thickness</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Line Thickness</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
	 * @generated
	 */
	EEnum getLineThickness();

	/**
	 * Returns the meta object for enum '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide <em>Axis Side</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Axis Side</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
	 * @generated
	 */
	EEnum getAxisSide();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.pua.prot.util.ProcessingParameter <em>Processing Parameter</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for data type '<em>Processing Parameter</em>'.
	 * @see de.bsvrz.pua.prot.util.ProcessingParameter
	 * @model instanceClass="de.bsvrz.pua.prot.util.ProcessingParameter" serializeable="false"
	 * @generated
	 */
	EDataType getProcessingParameter();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData <em>Protocol Administration Data</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for data type '<em>Protocol Administration Data</em>'.
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData
	 * @model instanceClass="de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData" serializeable="false"
	 * @generated
	 */
	EDataType getProtocolAdministrationData();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData <em>Protocol Aggregation Data</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for data type '<em>Protocol Aggregation Data</em>'.
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData
	 * @model instanceClass="de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData" serializeable="false"
	 * @generated
	 */
	EDataType getProtocolAggregationData();

	/**
	 * Returns the meta object for data type '
	 * {@link de.bsvrz.pua.prot.client.dataobject.ProtocolNoChanges
	 * <em>Protocol No Changes</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for data type '<em>Protocol No Changes</em>'.
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolNoChanges
	 * @model 
	 *        instanceClass="de.bsvrz.pua.prot.client.dataobject.ProtocolNoChanges"
	 *        serializeable="false"
	 * @generated
	 */
	EDataType getProtocolNoChanges();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.pua.prot.client.dataobject.ProtocolResultData <em>Protocol Result Data</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for data type '<em>Protocol Result Data</em>'.
	 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolResultData
	 * @model instanceClass="de.bsvrz.pua.prot.client.dataobject.ProtocolResultData" serializeable="false"
	 * @generated
	 */
	EDataType getProtocolResultData();

	/**
	 * Returns the meta object for data type '{@link com.bitctrl.util.TwoDimensionalMap <em>Two Dimensional Map</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Two Dimensional Map</em>'.
	 * @see com.bitctrl.util.TwoDimensionalMap
	 * @model instanceClass="com.bitctrl.util.TwoDimensionalMap" typeParameters="R C D"
	 * @generated
	 */
	EDataType getTwoDimensionalMap();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid <em>Matrix Grid</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Matrix Grid</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid
	 * @model instanceClass="de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid" serializeable="false" typeParameters="R C D"
	 * @generated
	 */
	EDataType getMatrixGrid();

	/**
	 * Returns the meta object for data type '
	 * {@link de.bsvrz.pua.prot.client.dataobject.Column <em>Column</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for data type '<em>Column</em>'.
	 * @see de.bsvrz.pua.prot.client.dataobject.Column
	 * @model instanceClass="de.bsvrz.pua.prot.client.dataobject.Column"
	 * @generated
	 */
	EDataType getColumn();

	/**
	 * Returns the meta object for data type '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * <em>Series Type Object</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for data type '<em>Series Type Object</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
	 * @model 
	 *        instanceClass="de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType"
	 *        extendedMetaData="name='SeriesType:Object' baseType='SeriesType'"
	 * @generated
	 */
	EDataType getSeriesTypeObject();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness <em>Line Thinkness Object</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for data type '<em>Line Thinkness Object</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
	 * @model instanceClass="de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness"
	 *        extendedMetaData="name='LineThickness:Object' baseType='LineThickness'"
	 * @generated
	 */
	EDataType getLineThinknessObject();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.swt.graphics.RGB <em>RGB</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for data type '<em>RGB</em>'.
	 * @see org.eclipse.swt.graphics.RGB
	 * @model instanceClass="org.eclipse.swt.graphics.RGB"
	 * @generated
	 */
	EDataType getRGB();

	/**
	 * Returns the meta object for data type '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
	 * <em>Axis Side Object</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for data type '<em>Axis Side Object</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
	 * @model instanceClass="de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide"
	 *        extendedMetaData="name='AxisSide:Object' baseType='AxisSide'"
	 * @generated
	 */
	EDataType getAxisSideObject();

	/**
	 * Returns the meta object for data type '
	 * {@link de.bsvrz.pua.prot.util.ResultValue <em>Result Value</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for data type '<em>Result Value</em>'.
	 * @see de.bsvrz.pua.prot.util.ResultValue
	 * @model instanceClass="de.bsvrz.pua.prot.util.ResultValue"
	 *        serializeable="false"
	 * @generated
	 */
	EDataType getResultValue();

	/**
	 * Returns the meta object for data type '{@link java.util.NavigableSet <em>Navigable Set</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Navigable Set</em>'.
	 * @see java.util.NavigableSet
	 * @model instanceClass="java.util.NavigableSet" typeParameters="K"
	 * @generated
	 */
	EDataType getNavigableSet();

	/**
	 * Returns the meta object for data type '{@link java.util.NavigableMap <em>Navigable Map</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Navigable Map</em>'.
	 * @see java.util.NavigableMap
	 * @model instanceClass="java.util.NavigableMap" typeParameters="K V"
	 * @generated
	 */
	EDataType getNavigableMap();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ModelFactory getModelFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.RootImpl <em>Root</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.RootImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getRoot()
		 * @generated
		 */
		EClass ROOT = eINSTANCE.getRoot();

		/**
		 * The meta object literal for the '<em><b>Protokoll</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference ROOT__PROTOKOLL = eINSTANCE.getRoot_Protokoll();

		/**
		 * The meta object literal for the '<em><b>Pua Ganglinien</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference ROOT__PUA_GANGLINIEN = eINSTANCE.getRoot_PuaGanglinien();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl
		 * <em>Protokoll</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtokoll()
		 * @generated
		 */
		EClass PROTOKOLL = eINSTANCE.getProtokoll();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROTOKOLL__ROOT = eINSTANCE.getProtokoll_Root();

		/**
		 * The meta object literal for the '<em><b>Processing Parameter</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOKOLL__PROCESSING_PARAMETER = eINSTANCE.getProtokoll_ProcessingParameter();

		/**
		 * The meta object literal for the '<em><b>Administration Data</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOKOLL__ADMINISTRATION_DATA = eINSTANCE.getProtokoll_AdministrationData();

		/**
		 * The meta object literal for the '<em><b>Aggregation Data</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOKOLL__AGGREGATION_DATA = eINSTANCE.getProtokoll_AggregationData();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl <em>PUA Ganglinien</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getPUAGanglinien()
		 * @generated
		 */
		EClass PUA_GANGLINIEN = eINSTANCE.getPUAGanglinien();

		/**
		 * The meta object literal for the '<em><b>Root</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PUA_GANGLINIEN__ROOT = eINSTANCE.getPUAGanglinien_Root();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__NAME = eINSTANCE.getPUAGanglinien_Name();

		/**
		 * The meta object literal for the '<em><b>Matrix</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PUA_GANGLINIEN__MATRIX = eINSTANCE.getPUAGanglinien_Matrix();

		/**
		 * The meta object literal for the '<em><b>Matrix Grid</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__MATRIX_GRID = eINSTANCE.getPUAGanglinien_MatrixGrid();

		/**
		 * The meta object literal for the '<em><b>Precision Map</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__PRECISION_MAP = eINSTANCE.getPUAGanglinien_PrecisionMap();

		/**
		 * The meta object literal for the '<em><b>Merged Properties</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference PUA_GANGLINIEN__MERGED_PROPERTIES = eINSTANCE.getPUAGanglinien_MergedProperties();

		/**
		 * The meta object literal for the '<em><b>Axes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PUA_GANGLINIEN__AXES = eINSTANCE.getPUAGanglinien_Axes();

		/**
		 * The meta object literal for the '<em><b>Current Axis</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference PUA_GANGLINIEN__CURRENT_AXIS = eINSTANCE.getPUAGanglinien_CurrentAxis();

		/**
		 * The meta object literal for the '<em><b>Zoom XFrom</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__ZOOM_XFROM = eINSTANCE.getPUAGanglinien_ZoomXFrom();

		/**
		 * The meta object literal for the '<em><b>Zoom XTo</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__ZOOM_XTO = eINSTANCE.getPUAGanglinien_ZoomXTo();

		/**
		 * The meta object literal for the '<em><b>XAxis Step</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__XAXIS_STEP = eINSTANCE.getPUAGanglinien_XAxisStep();

		/**
		 * The meta object literal for the '<em><b>Auto Update Diagram</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM = eINSTANCE.getPUAGanglinien_AutoUpdateDiagram();

		/**
		 * The meta object literal for the '<em><b>Show Data Table</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__SHOW_DATA_TABLE = eINSTANCE.getPUAGanglinien_ShowDataTable();

		/**
		 * The meta object literal for the '<em><b>Background Color</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__BACKGROUND_COLOR = eINSTANCE.getPUAGanglinien_BackgroundColor();

		/**
		 * The meta object literal for the '<em><b>Helper Line Color</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__HELPER_LINE_COLOR = eINSTANCE.getPUAGanglinien_HelperLineColor();

		/**
		 * The meta object literal for the '<em><b>Title</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__TITLE = eINSTANCE.getPUAGanglinien_Title();

		/**
		 * The meta object literal for the '<em><b>Show Helper Lines</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUA_GANGLINIEN__SHOW_HELPER_LINES = eINSTANCE.getPUAGanglinien_ShowHelperLines();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl <em>Line Properties</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getLineProperties()
		 * @generated
		 */
		EClass LINE_PROPERTIES = eINSTANCE.getLineProperties();

		/**
		 * The meta object literal for the '<em><b>Series Type</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__SERIES_TYPE = eINSTANCE.getLineProperties_SeriesType();

		/**
		 * The meta object literal for the '<em><b>Line Style</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__LINE_STYLE = eINSTANCE.getLineProperties_LineStyle();

		/**
		 * The meta object literal for the '<em><b>Line Thickness</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__LINE_THICKNESS = eINSTANCE.getLineProperties_LineThickness();

		/**
		 * The meta object literal for the '<em><b>Line RGB</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__LINE_RGB = eINSTANCE.getLineProperties_LineRGB();

		/**
		 * The meta object literal for the '<em><b>Marker Type</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__MARKER_TYPE = eINSTANCE.getLineProperties_MarkerType();

		/**
		 * The meta object literal for the '<em><b>Fill RGB</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__FILL_RGB = eINSTANCE.getLineProperties_FillRGB();

		/**
		 * The meta object literal for the '<em><b>Axis</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference LINE_PROPERTIES__AXIS = eINSTANCE.getLineProperties_Axis();

		/**
		 * The meta object literal for the '<em><b>Values</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_PROPERTIES__VALUES = eINSTANCE.getLineProperties_Values();

		/**
		 * The meta object literal for the '<em><b>Defaults</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference LINE_PROPERTIES__DEFAULTS = eINSTANCE.getLineProperties_Defaults();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl <em>Axis Properties</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAxisProperties()
		 * @generated
		 */
		EClass AXIS_PROPERTIES = eINSTANCE.getAxisProperties();

		/**
		 * The meta object literal for the '<em><b>Title</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AXIS_PROPERTIES__TITLE = eINSTANCE.getAxisProperties_Title();

		/**
		 * The meta object literal for the '<em><b>Axis Side</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AXIS_PROPERTIES__AXIS_SIDE = eINSTANCE.getAxisProperties_AxisSide();

		/**
		 * The meta object literal for the '<em><b>Min</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AXIS_PROPERTIES__MIN = eINSTANCE.getAxisProperties_Min();

		/**
		 * The meta object literal for the '<em><b>Max</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AXIS_PROPERTIES__MAX = eINSTANCE.getAxisProperties_Max();

		/**
		 * The meta object literal for the '<em><b>Visible Grid</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AXIS_PROPERTIES__VISIBLE_GRID = eINSTANCE.getAxisProperties_VisibleGrid();

		/**
		 * The meta object literal for the '<em><b>Step</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AXIS_PROPERTIES__STEP = eINSTANCE.getAxisProperties_Step();

		/**
		 * The meta object literal for the '<em><b>Referenced Lines</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference AXIS_PROPERTIES__REFERENCED_LINES = eINSTANCE.getAxisProperties_ReferencedLines();

		/**
		 * The meta object literal for the '<em><b>Defaults</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference AXIS_PROPERTIES__DEFAULTS = eINSTANCE.getAxisProperties_Defaults();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.MergedPropertiesImpl <em>Merged Properties</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.MergedPropertiesImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getMergedProperties()
		 * @generated
		 */
		EClass MERGED_PROPERTIES = eINSTANCE.getMergedProperties();

		/**
		 * The meta object literal for the '<em><b>Pua Ganglinien</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference MERGED_PROPERTIES__PUA_GANGLINIEN = eINSTANCE.getMergedProperties_PuaGanglinien();

		/**
		 * The meta object literal for the '<em><b>Selected</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference MERGED_PROPERTIES__SELECTED = eINSTANCE.getMergedProperties_Selected();

		/**
		 * The meta object literal for the '<em><b>Merged</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference MERGED_PROPERTIES__MERGED = eINSTANCE.getMergedProperties_Merged();

		/**
		 * The meta object literal for the '
		 * <em><b>Unknown Multi Features</b></em>' reference list feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference MERGED_PROPERTIES__UNKNOWN_MULTI_FEATURES = eINSTANCE.getMergedProperties_UnknownMultiFeatures();

		/**
		 * The meta object literal for the '<em><b>Updating</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MERGED_PROPERTIES__UPDATING = eINSTANCE.getMergedProperties_Updating();

		/**
		 * The meta object literal for the '<em>Aggregations Typ</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.ganglinien.data.AggregationsTyp
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAggregationsTyp()
		 * @generated
		 */
		EDataType AGGREGATIONS_TYP = eINSTANCE.getAggregationsTyp();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType <em>Series Type</em>}' enum.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getSeriesType()
		 * @generated
		 */
		EEnum SERIES_TYPE = eINSTANCE.getSeriesType();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness <em>Line Thickness</em>}' enum.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getLineThickness()
		 * @generated
		 */
		EEnum LINE_THICKNESS = eINSTANCE.getLineThickness();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
		 * <em>Axis Side</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAxisSide()
		 * @generated
		 */
		EEnum AXIS_SIDE = eINSTANCE.getAxisSide();

		/**
		 * The meta object literal for the '<em>Processing Parameter</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.pua.prot.util.ProcessingParameter
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProcessingParameter()
		 * @generated
		 */
		EDataType PROCESSING_PARAMETER = eINSTANCE.getProcessingParameter();

		/**
		 * The meta object literal for the '<em>Protocol Administration Data</em>' data type.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolAdministrationData()
		 * @generated
		 */
		EDataType PROTOCOL_ADMINISTRATION_DATA = eINSTANCE.getProtocolAdministrationData();

		/**
		 * The meta object literal for the '<em>Protocol Aggregation Data</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolAggregationData()
		 * @generated
		 */
		EDataType PROTOCOL_AGGREGATION_DATA = eINSTANCE.getProtocolAggregationData();

		/**
		 * The meta object literal for the '<em>Protocol No Changes</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolNoChanges
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolNoChanges()
		 * @generated
		 */
		EDataType PROTOCOL_NO_CHANGES = eINSTANCE.getProtocolNoChanges();

		/**
		 * The meta object literal for the '<em>Protocol Result Data</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.pua.prot.client.dataobject.ProtocolResultData
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getProtocolResultData()
		 * @generated
		 */
		EDataType PROTOCOL_RESULT_DATA = eINSTANCE.getProtocolResultData();

		/**
		 * The meta object literal for the '<em>Two Dimensional Map</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see com.bitctrl.util.TwoDimensionalMap
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getTwoDimensionalMap()
		 * @generated
		 */
		EDataType TWO_DIMENSIONAL_MAP = eINSTANCE.getTwoDimensionalMap();

		/**
		 * The meta object literal for the '<em>Matrix Grid</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getMatrixGrid()
		 * @generated
		 */
		EDataType MATRIX_GRID = eINSTANCE.getMatrixGrid();

		/**
		 * The meta object literal for the '<em>Column</em>' data type. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.pua.prot.client.dataobject.Column
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getColumn()
		 * @generated
		 */
		EDataType COLUMN = eINSTANCE.getColumn();

		/**
		 * The meta object literal for the '<em>Series Type Object</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getSeriesTypeObject()
		 * @generated
		 */
		EDataType SERIES_TYPE_OBJECT = eINSTANCE.getSeriesTypeObject();

		/**
		 * The meta object literal for the '<em>Line Thinkness Object</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getLineThinknessObject()
		 * @generated
		 */
		EDataType LINE_THINKNESS_OBJECT = eINSTANCE.getLineThinknessObject();

		/**
		 * The meta object literal for the '<em>RGB</em>' data type. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see org.eclipse.swt.graphics.RGB
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getRGB()
		 * @generated
		 */
		EDataType RGB = eINSTANCE.getRGB();

		/**
		 * The meta object literal for the '<em>Axis Side Object</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getAxisSideObject()
		 * @generated
		 */
		EDataType AXIS_SIDE_OBJECT = eINSTANCE.getAxisSideObject();

		/**
		 * The meta object literal for the '<em>Result Value</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.pua.prot.util.ResultValue
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getResultValue()
		 * @generated
		 */
		EDataType RESULT_VALUE = eINSTANCE.getResultValue();

		/**
		 * The meta object literal for the '<em>Navigable Set</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see java.util.NavigableSet
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getNavigableSet()
		 * @generated
		 */
		EDataType NAVIGABLE_SET = eINSTANCE.getNavigableSet();

		/**
		 * The meta object literal for the '<em>Navigable Map</em>' data type.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see java.util.NavigableMap
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ModelPackageImpl#getNavigableMap()
		 * @generated
		 */
		EDataType NAVIGABLE_MAP = eINSTANCE.getNavigableMap();

	}

} // ModelPackage
