/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model;

import java.util.Date;
import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid;
import de.bsvrz.buv.plugin.pua.ganglinien.data.AggregationsTyp;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap;
import de.bsvrz.pua.prot.client.dataobject.Column;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>PUA Ganglinien</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getRoot
 * <em>Root</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getName
 * <em>Name</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrix
 * <em>Matrix</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrixGrid
 * <em>Matrix Grid</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getPrecisionMap
 * <em>Precision Map</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMergedProperties
 * <em>Merged Properties</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getAxes
 * <em>Axes</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getCurrentAxis
 * <em>Current Axis</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXFrom
 * <em>Zoom XFrom</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXTo
 * <em>Zoom XTo</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getXAxisStep
 * <em>XAxis Step</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isAutoUpdateDiagram
 * <em>Auto Update Diagram</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowDataTable
 * <em>Show Data Table</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getBackgroundColor
 * <em>Background Color</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getHelperLineColor
 * <em>Helper Line Color</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getTitle
 * <em>Title</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowHelperLines
 * <em>Show Helper Lines</em>}</li>
 * </ul>
 * </p>
 * 
 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien()
 * @model
 * @generated
 */
public interface PUAGanglinien extends EObject {
	/**
	 * Returns the value of the '<em><b>Root</b></em>' container reference. It
	 * is bidirectional and its opposite is '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.Root#getPuaGanglinien
	 * <em>Pua Ganglinien</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Root</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Root</em>' container reference.
	 * @see #setRoot(Root)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_Root()
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.Root#getPuaGanglinien
	 * @model opposite="puaGanglinien" transient="false"
	 * @generated
	 */
	Root getRoot();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getRoot
	 * <em>Root</em>}' container reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Root</em>' container reference.
	 * @see #getRoot()
	 * @generated
	 */
	void setRoot(Root value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. The default
	 * value is <code>""</code>. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_Name()
	 * @model default=""
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getName
	 * <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Matrix</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Matrix</em>' containment reference isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Matrix</em>' containment reference.
	 * @see #setMatrix(TwoDimensionalEMFMap)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_Matrix()
	 * @model type=
	 *        "de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap<de.bsvrz.buv.plugin.pua.ganglinien.model.AggregationsTyp, de.bsvrz.buv.plugin.pua.ganglinien.model.Column, de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties>"
	 *        containment="true"
	 * @generated
	 */
	TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> getMatrix();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrix
	 * <em>Matrix</em>}' containment reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Matrix</em>' containment reference.
	 * @see #getMatrix()
	 * @generated
	 */
	void setMatrix(
			TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> value);

	/**
	 * Returns the value of the '<em><b>Matrix Grid</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Matrix Grid</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Matrix Grid</em>' attribute.
	 * @see #setMatrixGrid(MatrixGrid)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_MatrixGrid()
	 * @model dataType=
	 *        "de.bsvrz.buv.plugin.pua.ganglinien.model.MatrixGrid<de.bsvrz.buv.plugin.pua.ganglinien.model.ApplyAggregation, de.bsvrz.buv.plugin.pua.ganglinien.model.Column, de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties>"
	 *        transient="true"
	 * @generated
	 */
	MatrixGrid<AggregationsTyp, Column, LineProperties> getMatrixGrid();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMatrixGrid
	 * <em>Matrix Grid</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Matrix Grid</em>' attribute.
	 * @see #getMatrixGrid()
	 * @generated
	 */
	void setMatrixGrid(MatrixGrid<AggregationsTyp, Column, LineProperties> value);

	/**
	 * Returns the value of the '<em><b>Precision Map</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Precision Map</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Precision Map</em>' attribute.
	 * @see #setPrecisionMap(Map)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_PrecisionMap()
	 * @model transient="true"
	 * @generated
	 */
	Map<Column, Double> getPrecisionMap();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getPrecisionMap
	 * <em>Precision Map</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Precision Map</em>' attribute.
	 * @see #getPrecisionMap()
	 * @generated
	 */
	void setPrecisionMap(Map<Column, Double> value);

	/**
	 * Returns the value of the '<em><b>Merged Properties</b></em>' containment
	 * reference. It is bidirectional and its opposite is '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getPuaGanglinien
	 * <em>Pua Ganglinien</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Merged Properties</em>' containment reference
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Merged Properties</em>' containment
	 *         reference.
	 * @see #setMergedProperties(MergedProperties)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_MergedProperties()
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties#getPuaGanglinien
	 * @model opposite="puaGanglinien" containment="true" required="true"
	 *        transient="true"
	 * @generated
	 */
	MergedProperties getMergedProperties();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getMergedProperties
	 * <em>Merged Properties</em>}' containment reference. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Merged Properties</em>' containment
	 *            reference.
	 * @see #getMergedProperties()
	 * @generated
	 */
	void setMergedProperties(MergedProperties value);

	/**
	 * Returns the value of the '<em><b>Axes</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties}. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Axes</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Axes</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_Axes()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<AxisProperties> getAxes();

	/**
	 * Returns the value of the '<em><b>Current Axis</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Current Axis</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Current Axis</em>' reference.
	 * @see #setCurrentAxis(AxisProperties)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_CurrentAxis()
	 * @model
	 * @generated
	 */
	AxisProperties getCurrentAxis();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getCurrentAxis
	 * <em>Current Axis</em>}' reference. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Current Axis</em>' reference.
	 * @see #getCurrentAxis()
	 * @generated
	 */
	void setCurrentAxis(AxisProperties value);

	/**
	 * Returns the value of the '<em><b>Zoom XFrom</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Zoom XFrom</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Zoom XFrom</em>' attribute.
	 * @see #setZoomXFrom(Date)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_ZoomXFrom()
	 * @model
	 * @generated
	 */
	Date getZoomXFrom();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXFrom
	 * <em>Zoom XFrom</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Zoom XFrom</em>' attribute.
	 * @see #getZoomXFrom()
	 * @generated
	 */
	void setZoomXFrom(Date value);

	/**
	 * Returns the value of the '<em><b>Zoom XTo</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Zoom XTo</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Zoom XTo</em>' attribute.
	 * @see #setZoomXTo(Date)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_ZoomXTo()
	 * @model
	 * @generated
	 */
	Date getZoomXTo();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getZoomXTo
	 * <em>Zoom XTo</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value
	 *            the new value of the '<em>Zoom XTo</em>' attribute.
	 * @see #getZoomXTo()
	 * @generated
	 */
	void setZoomXTo(Date value);

	/**
	 * Returns the value of the '<em><b>XAxis Step</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>XAxis Step</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>XAxis Step</em>' attribute.
	 * @see #setXAxisStep(Long)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_XAxisStep()
	 * @model
	 * @generated
	 */
	Long getXAxisStep();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getXAxisStep
	 * <em>XAxis Step</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>XAxis Step</em>' attribute.
	 * @see #getXAxisStep()
	 * @generated
	 */
	void setXAxisStep(Long value);

	/**
	 * Returns the value of the '<em><b>Auto Update Diagram</b></em>' attribute.
	 * The default value is <code>"true"</code>. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Auto Update Diagram</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Auto Update Diagram</em>' attribute.
	 * @see #setAutoUpdateDiagram(boolean)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_AutoUpdateDiagram()
	 * @model default="true" transient="true"
	 * @generated
	 */
	boolean isAutoUpdateDiagram();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isAutoUpdateDiagram
	 * <em>Auto Update Diagram</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Auto Update Diagram</em>' attribute.
	 * @see #isAutoUpdateDiagram()
	 * @generated
	 */
	void setAutoUpdateDiagram(boolean value);

	/**
	 * Returns the value of the '<em><b>Show Data Table</b></em>' attribute. The
	 * default value is <code>"false"</code>. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Show Data Table</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Show Data Table</em>' attribute.
	 * @see #setShowDataTable(boolean)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_ShowDataTable()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isShowDataTable();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowDataTable
	 * <em>Show Data Table</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Show Data Table</em>' attribute.
	 * @see #isShowDataTable()
	 * @generated
	 */
	void setShowDataTable(boolean value);

	/**
	 * Returns the value of the '<em><b>Background Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Background Color</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Background Color</em>' attribute.
	 * @see #setBackgroundColor(RGB)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_BackgroundColor()
	 * @model dataType="de.bsvrz.buv.plugin.pua.ganglinien.model.RGB"
	 * @generated
	 */
	RGB getBackgroundColor();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getBackgroundColor
	 * <em>Background Color</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Background Color</em>' attribute.
	 * @see #getBackgroundColor()
	 * @generated
	 */
	void setBackgroundColor(RGB value);

	/**
	 * Returns the value of the '<em><b>Helper Line Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Helper Line Color</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Helper Line Color</em>' attribute.
	 * @see #setHelperLineColor(RGB)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_HelperLineColor()
	 * @model dataType="de.bsvrz.buv.plugin.pua.ganglinien.model.RGB"
	 * @generated
	 */
	RGB getHelperLineColor();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getHelperLineColor
	 * <em>Helper Line Color</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Helper Line Color</em>' attribute.
	 * @see #getHelperLineColor()
	 * @generated
	 */
	void setHelperLineColor(RGB value);

	/**
	 * Returns the value of the '<em><b>Title</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Title</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Title</em>' attribute.
	 * @see #setTitle(String)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_Title()
	 * @model required="true"
	 * @generated
	 */
	String getTitle();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#getTitle
	 * <em>Title</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Title</em>' attribute.
	 * @see #getTitle()
	 * @generated
	 */
	void setTitle(String value);

	/**
	 * Returns the value of the '<em><b>Show Helper Lines</b></em>' attribute.
	 * The default value is <code>"true"</code>. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Show Helper Lines</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Show Helper Lines</em>' attribute.
	 * @see #setShowHelperLines(boolean)
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#getPUAGanglinien_ShowHelperLines()
	 * @model default="true"
	 * @generated
	 */
	boolean isShowHelperLines();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien#isShowHelperLines
	 * <em>Show Helper Lines</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Show Helper Lines</em>' attribute.
	 * @see #isShowHelperLines()
	 * @generated
	 */
	void setShowHelperLines(boolean value);

} // PUAGanglinien
