/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Axis Properties</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getAxisSide <em>Axis Side</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getMin <em>Min</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getMax <em>Max</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getVisibleGrid <em>Visible Grid</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getStep <em>Step</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getReferencedLines <em>Referenced Lines</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.AxisPropertiesImpl#getDefaults <em>Defaults</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AxisPropertiesImpl extends EObjectImpl implements AxisProperties {
	/**
	 * The default value of the '{@link #getAxisSide() <em>Axis Side</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAxisSide()
	 * @generated
	 * @ordered
	 */
	protected static final AxisSide AXIS_SIDE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAxisSide() <em>Axis Side</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAxisSide()
	 * @generated
	 * @ordered
	 */
	protected AxisSide axisSide = AXIS_SIDE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected static final String TITLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected String title = TITLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getMin() <em>Min</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected static final Integer MIN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMin() <em>Min</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected Integer min = MIN_EDEFAULT;

	/**
	 * The default value of the '{@link #getMax() <em>Max</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected static final Integer MAX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMax() <em>Max</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected Integer max = MAX_EDEFAULT;

	/**
	 * The default value of the '{@link #getVisibleGrid() <em>Visible Grid</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getVisibleGrid()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean VISIBLE_GRID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVisibleGrid() <em>Visible Grid</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getVisibleGrid()
	 * @generated
	 * @ordered
	 */
	protected Boolean visibleGrid = VISIBLE_GRID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStep() <em>Step</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStep()
	 * @generated
	 * @ordered
	 */
	protected static final Integer STEP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStep() <em>Step</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStep()
	 * @generated
	 * @ordered
	 */
	protected Integer step = STEP_EDEFAULT;

	/**
	 * The cached value of the '{@link #getReferencedLines() <em>Referenced Lines</em>}' reference list.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getReferencedLines()
	 * @generated
	 * @ordered
	 */
	protected EList<LineProperties> referencedLines;

	/**
	 * The cached value of the '{@link #getDefaults() <em>Defaults</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDefaults()
	 * @generated
	 * @ordered
	 */
	protected AxisProperties defaults;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AxisPropertiesImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ModelPackage.Literals.AXIS_PROPERTIES;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setTitle(String newTitle) {
		String oldTitle = title;
		title = newTitle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__TITLE, oldTitle, title));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AxisSide getAxisSide() {
		return axisSide;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAxisSide(AxisSide newAxisSide) {
		AxisSide oldAxisSide = axisSide;
		axisSide = newAxisSide;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__AXIS_SIDE, oldAxisSide, axisSide));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getMin() {
		return min;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setMin(Integer newMin) {
		Integer oldMin = min;
		min = newMin;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__MIN, oldMin, min));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getMax() {
		return max;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setMax(Integer newMax) {
		Integer oldMax = max;
		max = newMax;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__MAX, oldMax, max));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Boolean getVisibleGrid() {
		return visibleGrid;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisibleGrid(Boolean newVisibleGrid) {
		Boolean oldVisibleGrid = visibleGrid;
		visibleGrid = newVisibleGrid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__VISIBLE_GRID, oldVisibleGrid, visibleGrid));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getStep() {
		return step;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setStep(Integer newStep) {
		Integer oldStep = step;
		step = newStep;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__STEP, oldStep, step));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<LineProperties> getReferencedLines() {
		if (referencedLines == null) {
			referencedLines = new EObjectWithInverseResolvingEList<LineProperties>(LineProperties.class, this, ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES, ModelPackage.LINE_PROPERTIES__AXIS);
		}
		return referencedLines;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AxisProperties getDefaults() {
		return defaults;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDefaults(AxisProperties newDefaults,
			NotificationChain msgs) {
		AxisProperties oldDefaults = defaults;
		defaults = newDefaults;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__DEFAULTS, oldDefaults, newDefaults);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaults(AxisProperties newDefaults) {
		if (newDefaults != defaults) {
			NotificationChain msgs = null;
			if (defaults != null)
				msgs = ((InternalEObject)defaults).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ModelPackage.AXIS_PROPERTIES__DEFAULTS, null, msgs);
			if (newDefaults != null)
				msgs = ((InternalEObject)newDefaults).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ModelPackage.AXIS_PROPERTIES__DEFAULTS, null, msgs);
			msgs = basicSetDefaults(newDefaults, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.AXIS_PROPERTIES__DEFAULTS, newDefaults, newDefaults));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void updateMinMax(int value) {
		setMin(Math.min(getMin(),value));
		setMax(Math.max(getMax(),value));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getReferencedLines()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES:
				return ((InternalEList<?>)getReferencedLines()).basicRemove(otherEnd, msgs);
			case ModelPackage.AXIS_PROPERTIES__DEFAULTS:
				return basicSetDefaults(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ModelPackage.AXIS_PROPERTIES__AXIS_SIDE:
				return getAxisSide();
			case ModelPackage.AXIS_PROPERTIES__TITLE:
				return getTitle();
			case ModelPackage.AXIS_PROPERTIES__MIN:
				return getMin();
			case ModelPackage.AXIS_PROPERTIES__MAX:
				return getMax();
			case ModelPackage.AXIS_PROPERTIES__VISIBLE_GRID:
				return getVisibleGrid();
			case ModelPackage.AXIS_PROPERTIES__STEP:
				return getStep();
			case ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES:
				return getReferencedLines();
			case ModelPackage.AXIS_PROPERTIES__DEFAULTS:
				return getDefaults();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ModelPackage.AXIS_PROPERTIES__AXIS_SIDE:
				setAxisSide((AxisSide)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__TITLE:
				setTitle((String)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__MIN:
				setMin((Integer)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__MAX:
				setMax((Integer)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__VISIBLE_GRID:
				setVisibleGrid((Boolean)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__STEP:
				setStep((Integer)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES:
				getReferencedLines().clear();
				getReferencedLines().addAll((Collection<? extends LineProperties>)newValue);
				return;
			case ModelPackage.AXIS_PROPERTIES__DEFAULTS:
				setDefaults((AxisProperties)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ModelPackage.AXIS_PROPERTIES__AXIS_SIDE:
				setAxisSide(AXIS_SIDE_EDEFAULT);
				return;
			case ModelPackage.AXIS_PROPERTIES__TITLE:
				setTitle(TITLE_EDEFAULT);
				return;
			case ModelPackage.AXIS_PROPERTIES__MIN:
				setMin(MIN_EDEFAULT);
				return;
			case ModelPackage.AXIS_PROPERTIES__MAX:
				setMax(MAX_EDEFAULT);
				return;
			case ModelPackage.AXIS_PROPERTIES__VISIBLE_GRID:
				setVisibleGrid(VISIBLE_GRID_EDEFAULT);
				return;
			case ModelPackage.AXIS_PROPERTIES__STEP:
				setStep(STEP_EDEFAULT);
				return;
			case ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES:
				getReferencedLines().clear();
				return;
			case ModelPackage.AXIS_PROPERTIES__DEFAULTS:
				setDefaults((AxisProperties)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ModelPackage.AXIS_PROPERTIES__AXIS_SIDE:
				return AXIS_SIDE_EDEFAULT == null ? axisSide != null : !AXIS_SIDE_EDEFAULT.equals(axisSide);
			case ModelPackage.AXIS_PROPERTIES__TITLE:
				return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
			case ModelPackage.AXIS_PROPERTIES__MIN:
				return MIN_EDEFAULT == null ? min != null : !MIN_EDEFAULT.equals(min);
			case ModelPackage.AXIS_PROPERTIES__MAX:
				return MAX_EDEFAULT == null ? max != null : !MAX_EDEFAULT.equals(max);
			case ModelPackage.AXIS_PROPERTIES__VISIBLE_GRID:
				return VISIBLE_GRID_EDEFAULT == null ? visibleGrid != null : !VISIBLE_GRID_EDEFAULT.equals(visibleGrid);
			case ModelPackage.AXIS_PROPERTIES__STEP:
				return STEP_EDEFAULT == null ? step != null : !STEP_EDEFAULT.equals(step);
			case ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES:
				return referencedLines != null && !referencedLines.isEmpty();
			case ModelPackage.AXIS_PROPERTIES__DEFAULTS:
				return defaults != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (axisSide: ");
		result.append(axisSide);
		result.append(", title: ");
		result.append(title);
		result.append(", min: ");
		result.append(min);
		result.append(", max: ");
		result.append(max);
		result.append(", visibleGrid: ");
		result.append(visibleGrid);
		result.append(", step: ");
		result.append(step);
		result.append(')');
		return result.toString();
	}

} // AxisPropertiesImpl
