/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model.impl;

import java.util.NavigableMap;

import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Line Properties</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getSeriesType <em>Series Type</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getLineStyle <em>Line Style</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getLineThickness <em>Line Thickness</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getLineRGB <em>Line RGB</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getMarkerType <em>Marker Type</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getFillRGB <em>Fill RGB</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getAxis <em>Axis</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getValues <em>Values</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.LinePropertiesImpl#getDefaults <em>Defaults</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class LinePropertiesImpl extends EObjectImpl implements LineProperties {
	/**
	 * The default value of the '{@link #getSeriesType() <em>Series Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSeriesType()
	 * @generated
	 * @ordered
	 */
	protected static final SeriesType SERIES_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSeriesType() <em>Series Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSeriesType()
	 * @generated
	 * @ordered
	 */
	protected SeriesType seriesType = SERIES_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLineStyle() <em>Line Style</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLineStyle()
	 * @generated
	 * @ordered
	 */
	protected static final LineStyle LINE_STYLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLineStyle() <em>Line Style</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLineStyle()
	 * @generated
	 * @ordered
	 */
	protected LineStyle lineStyle = LINE_STYLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLineThickness() <em>Line Thickness</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getLineThickness()
	 * @generated
	 * @ordered
	 */
	protected static final LineThickness LINE_THICKNESS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLineThickness() <em>Line Thickness</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getLineThickness()
	 * @generated
	 * @ordered
	 */
	protected LineThickness lineThickness = LINE_THICKNESS_EDEFAULT;

	/**
	 * The default value of the '{@link #getLineRGB() <em>Line RGB</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLineRGB()
	 * @generated
	 * @ordered
	 */
	protected static final RGB LINE_RGB_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLineRGB() <em>Line RGB</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLineRGB()
	 * @generated
	 * @ordered
	 */
	protected RGB lineRGB = LINE_RGB_EDEFAULT;

	/**
	 * The default value of the '{@link #getMarkerType() <em>Marker Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getMarkerType()
	 * @generated
	 * @ordered
	 */
	protected static final MarkerType MARKER_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMarkerType() <em>Marker Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getMarkerType()
	 * @generated
	 * @ordered
	 */
	protected MarkerType markerType = MARKER_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getFillRGB() <em>Fill RGB</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFillRGB()
	 * @generated
	 * @ordered
	 */
	protected static final RGB FILL_RGB_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFillRGB() <em>Fill RGB</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFillRGB()
	 * @generated
	 * @ordered
	 */
	protected RGB fillRGB = FILL_RGB_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAxis() <em>Axis</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAxis()
	 * @generated
	 * @ordered
	 */
	protected AxisProperties axis;

	/**
	 * The cached value of the '{@link #getValues() <em>Values</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getValues()
	 * @generated
	 * @ordered
	 */
	protected NavigableMap<Long, Double> values;

	/**
	 * The cached value of the '{@link #getDefaults() <em>Defaults</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDefaults()
	 * @generated
	 * @ordered
	 */
	protected LineProperties defaults;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected LinePropertiesImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ModelPackage.Literals.LINE_PROPERTIES;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public SeriesType getSeriesType() {
		return seriesType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSeriesType(SeriesType newSeriesType) {
		SeriesType oldSeriesType = seriesType;
		seriesType = newSeriesType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__SERIES_TYPE, oldSeriesType, seriesType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LineStyle getLineStyle() {
		return lineStyle;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineStyle(LineStyle newLineStyle) {
		LineStyle oldLineStyle = lineStyle;
		lineStyle = newLineStyle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__LINE_STYLE, oldLineStyle, lineStyle));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LineThickness getLineThickness() {
		return lineThickness;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineThickness(LineThickness newLineThickness) {
		LineThickness oldLineThickness = lineThickness;
		lineThickness = newLineThickness;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__LINE_THICKNESS, oldLineThickness, lineThickness));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public RGB getLineRGB() {
		return lineRGB;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineRGB(RGB newLineRGB) {
		RGB oldLineRGB = lineRGB;
		lineRGB = newLineRGB;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__LINE_RGB, oldLineRGB, lineRGB));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public MarkerType getMarkerType() {
		return markerType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setMarkerType(MarkerType newMarkerType) {
		MarkerType oldMarkerType = markerType;
		markerType = newMarkerType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__MARKER_TYPE, oldMarkerType, markerType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public RGB getFillRGB() {
		return fillRGB;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setFillRGB(RGB newFillRGB) {
		RGB oldFillRGB = fillRGB;
		fillRGB = newFillRGB;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__FILL_RGB, oldFillRGB, fillRGB));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AxisProperties getAxis() {
		if (axis != null && axis.eIsProxy()) {
			InternalEObject oldAxis = (InternalEObject)axis;
			axis = (AxisProperties)eResolveProxy(oldAxis);
			if (axis != oldAxis) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ModelPackage.LINE_PROPERTIES__AXIS, oldAxis, axis));
			}
		}
		return axis;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public AxisProperties basicGetAxis() {
		return axis;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAxis(AxisProperties newAxis,
			NotificationChain msgs) {
		AxisProperties oldAxis = axis;
		axis = newAxis;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__AXIS, oldAxis, newAxis);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAxis(AxisProperties newAxis) {
		if (newAxis != axis) {
			NotificationChain msgs = null;
			if (axis != null)
				msgs = ((InternalEObject)axis).eInverseRemove(this, ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES, AxisProperties.class, msgs);
			if (newAxis != null)
				msgs = ((InternalEObject)newAxis).eInverseAdd(this, ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES, AxisProperties.class, msgs);
			msgs = basicSetAxis(newAxis, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__AXIS, newAxis, newAxis));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NavigableMap<Long, Double> getValues() {
		return values;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setValues(NavigableMap<Long, Double> newValues) {
		NavigableMap<Long, Double> oldValues = values;
		values = newValues;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__VALUES, oldValues, values));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LineProperties getDefaults() {
		return defaults;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDefaults(LineProperties newDefaults,
			NotificationChain msgs) {
		LineProperties oldDefaults = defaults;
		defaults = newDefaults;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__DEFAULTS, oldDefaults, newDefaults);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaults(LineProperties newDefaults) {
		if (newDefaults != defaults) {
			NotificationChain msgs = null;
			if (defaults != null)
				msgs = ((InternalEObject)defaults).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ModelPackage.LINE_PROPERTIES__DEFAULTS, null, msgs);
			if (newDefaults != null)
				msgs = ((InternalEObject)newDefaults).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ModelPackage.LINE_PROPERTIES__DEFAULTS, null, msgs);
			msgs = basicSetDefaults(newDefaults, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.LINE_PROPERTIES__DEFAULTS, newDefaults, newDefaults));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModelPackage.LINE_PROPERTIES__AXIS:
				if (axis != null)
					msgs = ((InternalEObject)axis).eInverseRemove(this, ModelPackage.AXIS_PROPERTIES__REFERENCED_LINES, AxisProperties.class, msgs);
				return basicSetAxis((AxisProperties)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModelPackage.LINE_PROPERTIES__AXIS:
				return basicSetAxis(null, msgs);
			case ModelPackage.LINE_PROPERTIES__DEFAULTS:
				return basicSetDefaults(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ModelPackage.LINE_PROPERTIES__SERIES_TYPE:
				return getSeriesType();
			case ModelPackage.LINE_PROPERTIES__LINE_STYLE:
				return getLineStyle();
			case ModelPackage.LINE_PROPERTIES__LINE_THICKNESS:
				return getLineThickness();
			case ModelPackage.LINE_PROPERTIES__LINE_RGB:
				return getLineRGB();
			case ModelPackage.LINE_PROPERTIES__MARKER_TYPE:
				return getMarkerType();
			case ModelPackage.LINE_PROPERTIES__FILL_RGB:
				return getFillRGB();
			case ModelPackage.LINE_PROPERTIES__AXIS:
				if (resolve) return getAxis();
				return basicGetAxis();
			case ModelPackage.LINE_PROPERTIES__VALUES:
				return getValues();
			case ModelPackage.LINE_PROPERTIES__DEFAULTS:
				return getDefaults();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ModelPackage.LINE_PROPERTIES__SERIES_TYPE:
				setSeriesType((SeriesType)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__LINE_STYLE:
				setLineStyle((LineStyle)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__LINE_THICKNESS:
				setLineThickness((LineThickness)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__LINE_RGB:
				setLineRGB((RGB)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__MARKER_TYPE:
				setMarkerType((MarkerType)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__FILL_RGB:
				setFillRGB((RGB)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__AXIS:
				setAxis((AxisProperties)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__VALUES:
				setValues((NavigableMap<Long, Double>)newValue);
				return;
			case ModelPackage.LINE_PROPERTIES__DEFAULTS:
				setDefaults((LineProperties)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ModelPackage.LINE_PROPERTIES__SERIES_TYPE:
				setSeriesType(SERIES_TYPE_EDEFAULT);
				return;
			case ModelPackage.LINE_PROPERTIES__LINE_STYLE:
				setLineStyle(LINE_STYLE_EDEFAULT);
				return;
			case ModelPackage.LINE_PROPERTIES__LINE_THICKNESS:
				setLineThickness(LINE_THICKNESS_EDEFAULT);
				return;
			case ModelPackage.LINE_PROPERTIES__LINE_RGB:
				setLineRGB(LINE_RGB_EDEFAULT);
				return;
			case ModelPackage.LINE_PROPERTIES__MARKER_TYPE:
				setMarkerType(MARKER_TYPE_EDEFAULT);
				return;
			case ModelPackage.LINE_PROPERTIES__FILL_RGB:
				setFillRGB(FILL_RGB_EDEFAULT);
				return;
			case ModelPackage.LINE_PROPERTIES__AXIS:
				setAxis((AxisProperties)null);
				return;
			case ModelPackage.LINE_PROPERTIES__VALUES:
				setValues((NavigableMap<Long, Double>)null);
				return;
			case ModelPackage.LINE_PROPERTIES__DEFAULTS:
				setDefaults((LineProperties)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ModelPackage.LINE_PROPERTIES__SERIES_TYPE:
				return SERIES_TYPE_EDEFAULT == null ? seriesType != null : !SERIES_TYPE_EDEFAULT.equals(seriesType);
			case ModelPackage.LINE_PROPERTIES__LINE_STYLE:
				return LINE_STYLE_EDEFAULT == null ? lineStyle != null : !LINE_STYLE_EDEFAULT.equals(lineStyle);
			case ModelPackage.LINE_PROPERTIES__LINE_THICKNESS:
				return LINE_THICKNESS_EDEFAULT == null ? lineThickness != null : !LINE_THICKNESS_EDEFAULT.equals(lineThickness);
			case ModelPackage.LINE_PROPERTIES__LINE_RGB:
				return LINE_RGB_EDEFAULT == null ? lineRGB != null : !LINE_RGB_EDEFAULT.equals(lineRGB);
			case ModelPackage.LINE_PROPERTIES__MARKER_TYPE:
				return MARKER_TYPE_EDEFAULT == null ? markerType != null : !MARKER_TYPE_EDEFAULT.equals(markerType);
			case ModelPackage.LINE_PROPERTIES__FILL_RGB:
				return FILL_RGB_EDEFAULT == null ? fillRGB != null : !FILL_RGB_EDEFAULT.equals(fillRGB);
			case ModelPackage.LINE_PROPERTIES__AXIS:
				return axis != null;
			case ModelPackage.LINE_PROPERTIES__VALUES:
				return values != null;
			case ModelPackage.LINE_PROPERTIES__DEFAULTS:
				return defaults != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (seriesType: ");
		result.append(seriesType);
		result.append(", lineStyle: ");
		result.append(lineStyle);
		result.append(", lineThickness: ");
		result.append(lineThickness);
		result.append(", lineRGB: ");
		result.append(lineRGB);
		result.append(", markerType: ");
		result.append(markerType);
		result.append(", fillRGB: ");
		result.append(fillRGB);
		result.append(", values: ");
		result.append(values);
		result.append(')');
		return result.toString();
	}

} // LinePropertiesImpl
