/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model.impl;

import java.util.NavigableMap;
import java.util.NavigableSet;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.util.TwoDimensionalMap;

import de.bsvrz.buv.plugin.pua.ganglinien.data.AggregationsTyp;
import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness;
import de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelFactory;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Root;
import de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType;
import de.bsvrz.pua.prot.client.dataobject.Column;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class ModelFactoryImpl extends EFactoryImpl implements ModelFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static ModelFactory init() {
		try {
			final ModelFactory theModelFactory = (ModelFactory) EPackage.Registry.INSTANCE
					.getEFactory("http://www.bitctrl.de/bsvrz/buv/pua/model");
			if (theModelFactory != null) {
				return theModelFactory;
			}
		} catch (final Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ModelFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ModelFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(final EClass eClass) {
		switch (eClass.getClassifierID()) {
		case ModelPackage.ROOT:
			return createRoot();
		case ModelPackage.PROTOKOLL:
			return createProtokoll();
		case ModelPackage.PUA_GANGLINIEN:
			return createPUAGanglinien();
		case ModelPackage.LINE_PROPERTIES:
			return createLineProperties();
		case ModelPackage.AXIS_PROPERTIES:
			return createAxisProperties();
		case ModelPackage.MERGED_PROPERTIES:
			return createMergedProperties();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName()
					+ "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object createFromString(final EDataType eDataType,
			final String initialValue) {
		switch (eDataType.getClassifierID()) {
		case ModelPackage.SERIES_TYPE:
			return createSeriesTypeFromString(eDataType, initialValue);
		case ModelPackage.LINE_THICKNESS:
			return createLineThicknessFromString(eDataType, initialValue);
		case ModelPackage.AXIS_SIDE:
			return createAxisSideFromString(eDataType, initialValue);
		case ModelPackage.TWO_DIMENSIONAL_MAP:
			return createTwoDimensionalMapFromString(eDataType, initialValue);
		case ModelPackage.COLUMN:
			return createColumnFromString(eDataType, initialValue);
		case ModelPackage.SERIES_TYPE_OBJECT:
			return createSeriesTypeObjectFromString(eDataType, initialValue);
		case ModelPackage.LINE_THINKNESS_OBJECT:
			return createLineThinknessObjectFromString(eDataType, initialValue);
		case ModelPackage.RGB:
			return createRGBFromString(eDataType, initialValue);
		case ModelPackage.AXIS_SIDE_OBJECT:
			return createAxisSideObjectFromString(eDataType, initialValue);
		case ModelPackage.NAVIGABLE_SET:
			return createNavigableSetFromString(eDataType, initialValue);
		case ModelPackage.NAVIGABLE_MAP:
			return createNavigableMapFromString(eDataType, initialValue);
		case ModelPackage.AGGREGATIONS_TYP:
			return createAggregationsTypFromString(eDataType, initialValue);
		default:
			throw new IllegalArgumentException("The datatype '"
					+ eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String convertToString(final EDataType eDataType,
			final Object instanceValue) {
		switch (eDataType.getClassifierID()) {
		case ModelPackage.SERIES_TYPE:
			return convertSeriesTypeToString(eDataType, instanceValue);
		case ModelPackage.LINE_THICKNESS:
			return convertLineThicknessToString(eDataType, instanceValue);
		case ModelPackage.AXIS_SIDE:
			return convertAxisSideToString(eDataType, instanceValue);
		case ModelPackage.TWO_DIMENSIONAL_MAP:
			return convertTwoDimensionalMapToString(eDataType, instanceValue);
		case ModelPackage.COLUMN:
			return convertColumnToString(eDataType, instanceValue);
		case ModelPackage.SERIES_TYPE_OBJECT:
			return convertSeriesTypeObjectToString(eDataType, instanceValue);
		case ModelPackage.LINE_THINKNESS_OBJECT:
			return convertLineThinknessObjectToString(eDataType, instanceValue);
		case ModelPackage.RGB:
			return convertRGBToString(eDataType, instanceValue);
		case ModelPackage.AXIS_SIDE_OBJECT:
			return convertAxisSideObjectToString(eDataType, instanceValue);
		case ModelPackage.NAVIGABLE_SET:
			return convertNavigableSetToString(eDataType, instanceValue);
		case ModelPackage.NAVIGABLE_MAP:
			return convertNavigableMapToString(eDataType, instanceValue);
		case ModelPackage.AGGREGATIONS_TYP:
			return convertAggregationsTypToString(eDataType, instanceValue);
		default:
			throw new IllegalArgumentException("The datatype '"
					+ eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Root createRoot() {
		final RootImpl root = new RootImpl();
		return root;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Protokoll createProtokoll() {
		final ProtokollImpl protokoll = new ProtokollImpl();
		return protokoll;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public PUAGanglinien createPUAGanglinien() {
		final PUAGanglinienImpl puaGanglinien = new PUAGanglinienImpl();
		return puaGanglinien;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LineProperties createLineProperties() {
		final LinePropertiesImpl lineProperties = new LinePropertiesImpl();
		return lineProperties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AxisProperties createAxisProperties() {
		final AxisPropertiesImpl axisProperties = new AxisPropertiesImpl();
		return axisProperties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MergedProperties createMergedProperties() {
		final MergedPropertiesImpl mergedProperties = new MergedPropertiesImpl();
		return mergedProperties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SeriesType createSeriesTypeFromString(final EDataType eDataType,
			final String initialValue) {
		final SeriesType result = SeriesType.get(initialValue);
		if (result == null) {
			throw new IllegalArgumentException("The value '" + initialValue
					+ "' is not a valid enumerator of '" + eDataType.getName()
					+ "'");
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertSeriesTypeToString(final EDataType eDataType,
			final Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LineThickness createLineThicknessFromString(
			final EDataType eDataType, final String initialValue) {
		final LineThickness result = LineThickness.get(initialValue);
		if (result == null) {
			throw new IllegalArgumentException("The value '" + initialValue
					+ "' is not a valid enumerator of '" + eDataType.getName()
					+ "'");
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLineThicknessToString(final EDataType eDataType,
			final Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AxisSide createAxisSideFromString(final EDataType eDataType,
			final String initialValue) {
		final AxisSide result = AxisSide.get(initialValue);
		if (result == null) {
			throw new IllegalArgumentException("The value '" + initialValue
					+ "' is not a valid enumerator of '" + eDataType.getName()
					+ "'");
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertAxisSideToString(final EDataType eDataType,
			final Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TwoDimensionalMap<?, ?, ?> createTwoDimensionalMapFromString(
			final EDataType eDataType, final String initialValue) {
		return (TwoDimensionalMap<?, ?, ?>) super
				.createFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertTwoDimensionalMapToString(final EDataType eDataType,
			final Object instanceValue) {
		return super.convertToString(instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Column createColumnFromString(final EDataType eDataType,
			final String initialValue) {
		return (Column) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertColumnToString(final EDataType eDataType,
			final Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SeriesType createSeriesTypeObjectFromString(
			final EDataType eDataType, final String initialValue) {
		return createSeriesTypeFromString(ModelPackage.Literals.SERIES_TYPE,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertSeriesTypeObjectToString(final EDataType eDataType,
			final Object instanceValue) {
		return convertSeriesTypeToString(ModelPackage.Literals.SERIES_TYPE,
				instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LineThickness createLineThinknessObjectFromString(
			final EDataType eDataType, final String initialValue) {
		return createLineThicknessFromString(
				ModelPackage.Literals.LINE_THICKNESS, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLineThinknessObjectToString(final EDataType eDataType,
			final Object instanceValue) {
		return convertLineThicknessToString(
				ModelPackage.Literals.LINE_THICKNESS, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public RGB createRGBFromString(final EDataType eDataType,
			final String initialValue) {
		final String[] strings = initialValue.split(",");// RGB{r,g,b}
		strings[0] = strings[0].split("\\{")[1]; // RGB{r => r
		strings[2] = strings[2].split("\\}")[0]; // b} => b
		final int r = Integer.parseInt(strings[0].trim());
		final int g = Integer.parseInt(strings[1].trim());
		final int b = Integer.parseInt(strings[2].trim());
		return new RGB(r, g, b);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertRGBToString(final EDataType eDataType,
			final Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AxisSide createAxisSideObjectFromString(final EDataType eDataType,
			final String initialValue) {
		return createAxisSideFromString(ModelPackage.Literals.AXIS_SIDE,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertAxisSideObjectToString(final EDataType eDataType,
			final Object instanceValue) {
		return convertAxisSideToString(ModelPackage.Literals.AXIS_SIDE,
				instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NavigableSet<?> createNavigableSetFromString(
			final EDataType eDataType, final String initialValue) {
		return (NavigableSet<?>) super.createFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertNavigableSetToString(final EDataType eDataType,
			final Object instanceValue) {
		return super.convertToString(instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NavigableMap<?, ?> createNavigableMapFromString(
			final EDataType eDataType, final String initialValue) {
		return (NavigableMap<?, ?>) super.createFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertNavigableMapToString(final EDataType eDataType,
			final Object instanceValue) {
		return super.convertToString(instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AggregationsTyp createAggregationsTypFromString(
			final EDataType eDataType, final String initialValue) {
		return (AggregationsTyp) super
				.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertAggregationsTypToString(final EDataType eDataType,
			final Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ModelPackage getModelPackage() {
		return (ModelPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ModelPackage getPackage() {
		return ModelPackage.eINSTANCE;
	}

} // ModelFactoryImpl
