/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model.impl;

import java.util.NavigableMap;
import java.util.NavigableSet;

import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.util.TwoDimensionalMap;

import de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid;
import de.bsvrz.buv.plugin.pua.ganglinien.data.AggregationsTyp;
import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisSide;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness;
import de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelFactory;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Root;
import de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage;
import de.bsvrz.pua.prot.client.dataobject.Column;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData;
import de.bsvrz.pua.prot.client.dataobject.ProtocolNoChanges;
import de.bsvrz.pua.prot.client.dataobject.ProtocolResultData;
import de.bsvrz.pua.prot.util.ProcessingParameter;
import de.bsvrz.pua.prot.util.ResultValue;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class ModelPackageImpl extends EPackageImpl implements ModelPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rootEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass protokollEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass puaGanglinienEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass linePropertiesEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass axisPropertiesEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass mergedPropertiesEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum seriesTypeEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum lineThicknessEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum axisSideEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType processingParameterEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType protocolAdministrationDataEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType protocolAggregationDataEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType protocolNoChangesEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType protocolResultDataEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType twoDimensionalMapEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType matrixGridEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType columnEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType seriesTypeObjectEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType lineThinknessObjectEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType rgbEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType axisSideObjectEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType resultValueEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType navigableSetEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType navigableMapEDataType = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EDataType aggregationsTypEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ModelPackageImpl() {
		super(eNS_URI, ModelFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link ModelPackage#eINSTANCE} when
	 * that field is accessed. Clients should not invoke it directly. Instead,
	 * they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ModelPackage init() {
		if (isInited) {
			return (ModelPackage) EPackage.Registry.INSTANCE
					.getEPackage(ModelPackage.eNS_URI);
		}

		// Obtain or create and register package
		final ModelPackageImpl theModelPackage = (ModelPackageImpl) (EPackage.Registry.INSTANCE
				.get(eNS_URI) instanceof ModelPackageImpl ? EPackage.Registry.INSTANCE
				.get(eNS_URI) : new ModelPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		AttributePackage.eINSTANCE.eClass();
		ComponentPackage.eINSTANCE.eClass();
		DataPackage.eINSTANCE.eClass();
		LayoutPackage.eINSTANCE.eClass();
		TwoDimMapPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theModelPackage.createPackageContents();

		// Initialize created meta-data
		theModelPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theModelPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ModelPackage.eNS_URI, theModelPackage);
		return theModelPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getRoot() {
		return rootEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getRoot_Protokoll() {
		return (EReference) rootEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getRoot_PuaGanglinien() {
		return (EReference) rootEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getProtokoll() {
		return protokollEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getProtokoll_Root() {
		return (EReference) protokollEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getProtokoll_ProcessingParameter() {
		return (EAttribute) protokollEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getProtokoll_AdministrationData() {
		return (EAttribute) protokollEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getProtokoll_AggregationData() {
		return (EAttribute) protokollEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getPUAGanglinien() {
		return puaGanglinienEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPUAGanglinien_Root() {
		return (EReference) puaGanglinienEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_Name() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPUAGanglinien_Matrix() {
		return (EReference) puaGanglinienEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_MatrixGrid() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_PrecisionMap() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPUAGanglinien_MergedProperties() {
		return (EReference) puaGanglinienEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPUAGanglinien_Axes() {
		return (EReference) puaGanglinienEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getPUAGanglinien_CurrentAxis() {
		return (EReference) puaGanglinienEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_ZoomXFrom() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_ZoomXTo() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_XAxisStep() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(10);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_AutoUpdateDiagram() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(11);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_ShowDataTable() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(12);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_BackgroundColor() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(13);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_HelperLineColor() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(14);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_Title() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(15);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getPUAGanglinien_ShowHelperLines() {
		return (EAttribute) puaGanglinienEClass.getEStructuralFeatures()
				.get(16);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getLineProperties() {
		return linePropertiesEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_SeriesType() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_LineStyle() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_LineThickness() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_LineRGB() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_MarkerType() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_FillRGB() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getLineProperties_Axis() {
		return (EReference) linePropertiesEClass.getEStructuralFeatures()
				.get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getLineProperties_Values() {
		return (EAttribute) linePropertiesEClass.getEStructuralFeatures()
				.get(7);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getLineProperties_Defaults() {
		return (EReference) linePropertiesEClass.getEStructuralFeatures()
				.get(8);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getAxisProperties() {
		return axisPropertiesEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getAxisProperties_Title() {
		return (EAttribute) axisPropertiesEClass.getEStructuralFeatures()
				.get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getAxisProperties_AxisSide() {
		return (EAttribute) axisPropertiesEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getAxisProperties_Min() {
		return (EAttribute) axisPropertiesEClass.getEStructuralFeatures()
				.get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getAxisProperties_Max() {
		return (EAttribute) axisPropertiesEClass.getEStructuralFeatures()
				.get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getAxisProperties_VisibleGrid() {
		return (EAttribute) axisPropertiesEClass.getEStructuralFeatures()
				.get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getAxisProperties_Step() {
		return (EAttribute) axisPropertiesEClass.getEStructuralFeatures()
				.get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getAxisProperties_ReferencedLines() {
		return (EReference) axisPropertiesEClass.getEStructuralFeatures()
				.get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getAxisProperties_Defaults() {
		return (EReference) axisPropertiesEClass.getEStructuralFeatures()
				.get(7);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getMergedProperties() {
		return mergedPropertiesEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getMergedProperties_PuaGanglinien() {
		return (EReference) mergedPropertiesEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getMergedProperties_Selected() {
		return (EReference) mergedPropertiesEClass.getEStructuralFeatures()
				.get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getMergedProperties_Merged() {
		return (EReference) mergedPropertiesEClass.getEStructuralFeatures()
				.get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getMergedProperties_UnknownMultiFeatures() {
		return (EReference) mergedPropertiesEClass.getEStructuralFeatures()
				.get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getMergedProperties_Updating() {
		return (EAttribute) mergedPropertiesEClass.getEStructuralFeatures()
				.get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getAggregationsTyp() {
		return aggregationsTypEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EEnum getSeriesType() {
		return seriesTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EEnum getLineThickness() {
		return lineThicknessEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EEnum getAxisSide() {
		return axisSideEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getProcessingParameter() {
		return processingParameterEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getProtocolAdministrationData() {
		return protocolAdministrationDataEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getProtocolAggregationData() {
		return protocolAggregationDataEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getProtocolNoChanges() {
		return protocolNoChangesEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getProtocolResultData() {
		return protocolResultDataEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getTwoDimensionalMap() {
		return twoDimensionalMapEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getMatrixGrid() {
		return matrixGridEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getColumn() {
		return columnEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getSeriesTypeObject() {
		return seriesTypeObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getLineThinknessObject() {
		return lineThinknessObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getRGB() {
		return rgbEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getAxisSideObject() {
		return axisSideObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getResultValue() {
		return resultValueEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getNavigableSet() {
		return navigableSetEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EDataType getNavigableMap() {
		return navigableMapEDataType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ModelFactory getModelFactory() {
		return (ModelFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		rootEClass = createEClass(ROOT);
		createEReference(rootEClass, ROOT__PROTOKOLL);
		createEReference(rootEClass, ROOT__PUA_GANGLINIEN);

		protokollEClass = createEClass(PROTOKOLL);
		createEReference(protokollEClass, PROTOKOLL__ROOT);
		createEAttribute(protokollEClass, PROTOKOLL__PROCESSING_PARAMETER);
		createEAttribute(protokollEClass, PROTOKOLL__ADMINISTRATION_DATA);
		createEAttribute(protokollEClass, PROTOKOLL__AGGREGATION_DATA);

		puaGanglinienEClass = createEClass(PUA_GANGLINIEN);
		createEReference(puaGanglinienEClass, PUA_GANGLINIEN__ROOT);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__NAME);
		createEReference(puaGanglinienEClass, PUA_GANGLINIEN__MATRIX);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__MATRIX_GRID);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__PRECISION_MAP);
		createEReference(puaGanglinienEClass, PUA_GANGLINIEN__MERGED_PROPERTIES);
		createEReference(puaGanglinienEClass, PUA_GANGLINIEN__AXES);
		createEReference(puaGanglinienEClass, PUA_GANGLINIEN__CURRENT_AXIS);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__ZOOM_XFROM);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__ZOOM_XTO);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__XAXIS_STEP);
		createEAttribute(puaGanglinienEClass,
				PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__SHOW_DATA_TABLE);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__BACKGROUND_COLOR);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__HELPER_LINE_COLOR);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__TITLE);
		createEAttribute(puaGanglinienEClass, PUA_GANGLINIEN__SHOW_HELPER_LINES);

		linePropertiesEClass = createEClass(LINE_PROPERTIES);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__SERIES_TYPE);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__LINE_STYLE);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__LINE_THICKNESS);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__LINE_RGB);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__MARKER_TYPE);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__FILL_RGB);
		createEReference(linePropertiesEClass, LINE_PROPERTIES__AXIS);
		createEAttribute(linePropertiesEClass, LINE_PROPERTIES__VALUES);
		createEReference(linePropertiesEClass, LINE_PROPERTIES__DEFAULTS);

		axisPropertiesEClass = createEClass(AXIS_PROPERTIES);
		createEAttribute(axisPropertiesEClass, AXIS_PROPERTIES__AXIS_SIDE);
		createEAttribute(axisPropertiesEClass, AXIS_PROPERTIES__TITLE);
		createEAttribute(axisPropertiesEClass, AXIS_PROPERTIES__MIN);
		createEAttribute(axisPropertiesEClass, AXIS_PROPERTIES__MAX);
		createEAttribute(axisPropertiesEClass, AXIS_PROPERTIES__VISIBLE_GRID);
		createEAttribute(axisPropertiesEClass, AXIS_PROPERTIES__STEP);
		createEReference(axisPropertiesEClass,
				AXIS_PROPERTIES__REFERENCED_LINES);
		createEReference(axisPropertiesEClass, AXIS_PROPERTIES__DEFAULTS);

		mergedPropertiesEClass = createEClass(MERGED_PROPERTIES);
		createEReference(mergedPropertiesEClass,
				MERGED_PROPERTIES__PUA_GANGLINIEN);
		createEReference(mergedPropertiesEClass, MERGED_PROPERTIES__SELECTED);
		createEReference(mergedPropertiesEClass, MERGED_PROPERTIES__MERGED);
		createEReference(mergedPropertiesEClass,
				MERGED_PROPERTIES__UNKNOWN_MULTI_FEATURES);
		createEAttribute(mergedPropertiesEClass, MERGED_PROPERTIES__UPDATING);

		// Create enums
		seriesTypeEEnum = createEEnum(SERIES_TYPE);
		lineThicknessEEnum = createEEnum(LINE_THICKNESS);
		axisSideEEnum = createEEnum(AXIS_SIDE);

		// Create data types
		processingParameterEDataType = createEDataType(PROCESSING_PARAMETER);
		protocolAdministrationDataEDataType = createEDataType(PROTOCOL_ADMINISTRATION_DATA);
		protocolAggregationDataEDataType = createEDataType(PROTOCOL_AGGREGATION_DATA);
		protocolNoChangesEDataType = createEDataType(PROTOCOL_NO_CHANGES);
		protocolResultDataEDataType = createEDataType(PROTOCOL_RESULT_DATA);
		twoDimensionalMapEDataType = createEDataType(TWO_DIMENSIONAL_MAP);
		matrixGridEDataType = createEDataType(MATRIX_GRID);
		columnEDataType = createEDataType(COLUMN);
		seriesTypeObjectEDataType = createEDataType(SERIES_TYPE_OBJECT);
		lineThinknessObjectEDataType = createEDataType(LINE_THINKNESS_OBJECT);
		rgbEDataType = createEDataType(RGB);
		axisSideObjectEDataType = createEDataType(AXIS_SIDE_OBJECT);
		resultValueEDataType = createEDataType(RESULT_VALUE);
		navigableSetEDataType = createEDataType(NAVIGABLE_SET);
		navigableMapEDataType = createEDataType(NAVIGABLE_MAP);
		aggregationsTypEDataType = createEDataType(AGGREGATIONS_TYP);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		final TwoDimMapPackage theTwoDimMapPackage = (TwoDimMapPackage) EPackage.Registry.INSTANCE
				.getEPackage(TwoDimMapPackage.eNS_URI);
		final AttributePackage theAttributePackage = (AttributePackage) EPackage.Registry.INSTANCE
				.getEPackage(AttributePackage.eNS_URI);

		// Create type parameters
		addETypeParameter(twoDimensionalMapEDataType, "R");
		addETypeParameter(twoDimensionalMapEDataType, "C");
		addETypeParameter(twoDimensionalMapEDataType, "D");
		addETypeParameter(matrixGridEDataType, "R");
		addETypeParameter(matrixGridEDataType, "C");
		addETypeParameter(matrixGridEDataType, "D");
		addETypeParameter(navigableSetEDataType, "K");
		addETypeParameter(navigableMapEDataType, "K");
		addETypeParameter(navigableMapEDataType, "V");

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(rootEClass, Root.class, "Root", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRoot_Protokoll(), getProtokoll(),
				getProtokoll_Root(), "protokoll", null, 1, 1, Root.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getRoot_PuaGanglinien(), getPUAGanglinien(),
				getPUAGanglinien_Root(), "puaGanglinien", null, 0, 1,
				Root.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(protokollEClass, Protokoll.class, "Protokoll", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProtokoll_Root(), getRoot(), getRoot_Protokoll(),
				"root", null, 0, 1, Protokoll.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getProtokoll_ProcessingParameter(),
				getProcessingParameter(), "processingParameter", null, 1, 1,
				Protokoll.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtokoll_AdministrationData(),
				getProtocolAdministrationData(), "administrationData", null, 1,
				1, Protokoll.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtokoll_AggregationData(),
				getProtocolAggregationData(), "aggregationData", null, 0, 1,
				Protokoll.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(puaGanglinienEClass, PUAGanglinien.class, "PUAGanglinien",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPUAGanglinien_Root(), getRoot(),
				getRoot_PuaGanglinien(), "root", null, 0, 1,
				PUAGanglinien.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_Name(), ecorePackage.getEString(),
				"name", "", 0, 1, PUAGanglinien.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		EGenericType g1 = createEGenericType(theTwoDimMapPackage
				.getTwoDimensionalEMFMap());
		EGenericType g2 = createEGenericType(getAggregationsTyp());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(getColumn());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(getLineProperties());
		g1.getETypeArguments().add(g2);
		initEReference(getPUAGanglinien_Matrix(), g1, null, "matrix", null, 0,
				1, PUAGanglinien.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		g1 = createEGenericType(getMatrixGrid());
		g2 = createEGenericType(getAggregationsTyp());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(getColumn());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(getLineProperties());
		g1.getETypeArguments().add(g2);
		initEAttribute(getPUAGanglinien_MatrixGrid(), g1, "matrixGrid", null,
				0, 1, PUAGanglinien.class, IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(getColumn());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEDoubleObject());
		g1.getETypeArguments().add(g2);
		initEAttribute(getPUAGanglinien_PrecisionMap(), g1, "precisionMap",
				null, 0, 1, PUAGanglinien.class, IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getPUAGanglinien_MergedProperties(),
				getMergedProperties(), getMergedProperties_PuaGanglinien(),
				"mergedProperties", null, 1, 1, PUAGanglinien.class,
				IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getPUAGanglinien_Axes(), getAxisProperties(), null,
				"axes", null, 1, -1, PUAGanglinien.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPUAGanglinien_CurrentAxis(), getAxisProperties(),
				null, "currentAxis", null, 0, 1, PUAGanglinien.class,
				IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getPUAGanglinien_ZoomXFrom(), ecorePackage.getEDate(),
				"zoomXFrom", null, 0, 1, PUAGanglinien.class, IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_ZoomXTo(), ecorePackage.getEDate(),
				"zoomXTo", null, 0, 1, PUAGanglinien.class, IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_XAxisStep(),
				ecorePackage.getELongObject(), "xAxisStep", null, 0, 1,
				PUAGanglinien.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getPUAGanglinien_AutoUpdateDiagram(),
				ecorePackage.getEBoolean(), "autoUpdateDiagram", "true", 0, 1,
				PUAGanglinien.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_ShowDataTable(),
				ecorePackage.getEBoolean(), "showDataTable", "false", 0, 1,
				PUAGanglinien.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_BackgroundColor(), getRGB(),
				"backgroundColor", null, 0, 1, PUAGanglinien.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_HelperLineColor(), getRGB(),
				"helperLineColor", null, 0, 1, PUAGanglinien.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_Title(), ecorePackage.getEString(),
				"title", null, 1, 1, PUAGanglinien.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getPUAGanglinien_ShowHelperLines(),
				ecorePackage.getEBoolean(), "showHelperLines", "true", 0, 1,
				PUAGanglinien.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);

		initEClass(linePropertiesEClass, LineProperties.class,
				"LineProperties", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLineProperties_SeriesType(), getSeriesTypeObject(),
				"seriesType", null, 0, 1, LineProperties.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getLineProperties_LineStyle(),
				theAttributePackage.getLineStyleObject(), "lineStyle", null, 0,
				1, LineProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getLineProperties_LineThickness(),
				getLineThinknessObject(), "lineThickness", null, 0, 1,
				LineProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getLineProperties_LineRGB(), getRGB(), "lineRGB", null,
				0, 1, LineProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getLineProperties_MarkerType(),
				theAttributePackage.getMarkerTypeObject(), "markerType", null,
				0, 1, LineProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getLineProperties_FillRGB(), getRGB(), "fillRGB", null,
				0, 1, LineProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getLineProperties_Axis(), getAxisProperties(),
				getAxisProperties_ReferencedLines(), "axis", null, 1, 1,
				LineProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		g1 = createEGenericType(getNavigableMap());
		g2 = createEGenericType(ecorePackage.getELongObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEDoubleObject());
		g1.getETypeArguments().add(g2);
		initEAttribute(getLineProperties_Values(), g1, "values", null, 0, 1,
				LineProperties.class, IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getLineProperties_Defaults(), getLineProperties(), null,
				"defaults", null, 0, 1, LineProperties.class, IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(axisPropertiesEClass, AxisProperties.class,
				"AxisProperties", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAxisProperties_AxisSide(), getAxisSideObject(),
				"axisSide", null, 0, 1, AxisProperties.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getAxisProperties_Title(), ecorePackage.getEString(),
				"title", null, 1, 1, AxisProperties.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getAxisProperties_Min(),
				ecorePackage.getEIntegerObject(), "min", null, 0, 1,
				AxisProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getAxisProperties_Max(),
				ecorePackage.getEIntegerObject(), "max", null, 0, 1,
				AxisProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getAxisProperties_VisibleGrid(),
				ecorePackage.getEBooleanObject(), "visibleGrid", null, 1, 1,
				AxisProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getAxisProperties_Step(),
				ecorePackage.getEIntegerObject(), "step", null, 0, 1,
				AxisProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getAxisProperties_ReferencedLines(),
				getLineProperties(), getLineProperties_Axis(),
				"referencedLines", null, 0, -1, AxisProperties.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getAxisProperties_Defaults(), getAxisProperties(), null,
				"defaults", null, 0, 1, AxisProperties.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		final EOperation op = addEOperation(axisPropertiesEClass, null,
				"updateMinMax", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEInt(), "value", 0, 1, IS_UNIQUE,
				IS_ORDERED);

		initEClass(mergedPropertiesEClass, MergedProperties.class,
				"MergedProperties", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMergedProperties_PuaGanglinien(), getPUAGanglinien(),
				getPUAGanglinien_MergedProperties(), "puaGanglinien", null, 1,
				1, MergedProperties.class, IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMergedProperties_Selected(), getLineProperties(),
				null, "selected", null, 0, -1, MergedProperties.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEReference(getMergedProperties_Merged(), getLineProperties(), null,
				"merged", null, 1, 1, MergedProperties.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMergedProperties_UnknownMultiFeatures(),
				ecorePackage.getEStructuralFeature(), null,
				"unknownMultiFeatures", null, 0, -1, MergedProperties.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getMergedProperties_Updating(),
				ecorePackage.getEBoolean(), "updating", "false", 1, 1,
				MergedProperties.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(seriesTypeEEnum, SeriesType.class, "SeriesType");
		addEEnumLiteral(seriesTypeEEnum, SeriesType.NONE);
		addEEnumLiteral(seriesTypeEEnum, SeriesType.LINE);
		addEEnumLiteral(seriesTypeEEnum, SeriesType.BAR);

		initEEnum(lineThicknessEEnum, LineThickness.class, "LineThickness");
		addEEnumLiteral(lineThicknessEEnum, LineThickness.THIN);
		addEEnumLiteral(lineThicknessEEnum, LineThickness.NORMAL);
		addEEnumLiteral(lineThicknessEEnum, LineThickness.THICK);
		addEEnumLiteral(lineThicknessEEnum, LineThickness.THICKER);

		initEEnum(axisSideEEnum, AxisSide.class, "AxisSide");
		addEEnumLiteral(axisSideEEnum, AxisSide.LEFT);
		addEEnumLiteral(axisSideEEnum, AxisSide.RIGHT);

		// Initialize data types
		initEDataType(processingParameterEDataType, ProcessingParameter.class,
				"ProcessingParameter", !IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(protocolAdministrationDataEDataType,
				ProtocolAdministrationData.class, "ProtocolAdministrationData",
				!IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(protocolAggregationDataEDataType,
				ProtocolAggregationData.class, "ProtocolAggregationData",
				!IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(protocolNoChangesEDataType, ProtocolNoChanges.class,
				"ProtocolNoChanges", !IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(protocolResultDataEDataType, ProtocolResultData.class,
				"ProtocolResultData", !IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(twoDimensionalMapEDataType, TwoDimensionalMap.class,
				"TwoDimensionalMap", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(matrixGridEDataType, MatrixGrid.class, "MatrixGrid",
				!IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(columnEDataType, Column.class, "Column", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);
		initEDataType(seriesTypeObjectEDataType, SeriesType.class,
				"SeriesTypeObject", IS_SERIALIZABLE,
				IS_GENERATED_INSTANCE_CLASS);
		initEDataType(lineThinknessObjectEDataType, LineThickness.class,
				"LineThinknessObject", IS_SERIALIZABLE,
				IS_GENERATED_INSTANCE_CLASS);
		initEDataType(rgbEDataType, org.eclipse.swt.graphics.RGB.class, "RGB",
				IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(axisSideObjectEDataType, AxisSide.class,
				"AxisSideObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);
		initEDataType(resultValueEDataType, ResultValue.class, "ResultValue",
				!IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(navigableSetEDataType, NavigableSet.class,
				"NavigableSet", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(navigableMapEDataType, NavigableMap.class,
				"NavigableMap", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(aggregationsTypEDataType, AggregationsTyp.class,
				"AggregationsTyp", IS_SERIALIZABLE,
				!IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/ecore/util/ExtendedMetaData
		createExtendedMetaDataAnnotations();
	}

	/**
	 * Initializes the annotations for
	 * <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void createExtendedMetaDataAnnotations() {
		final String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
		addAnnotation(seriesTypeObjectEDataType, source, new String[] { "name",
				"SeriesType:Object", "baseType", "SeriesType" });
		addAnnotation(lineThinknessObjectEDataType, source, new String[] {
				"name", "LineThickness:Object", "baseType", "LineThickness" });
		addAnnotation(axisSideObjectEDataType, source, new String[] { "name",
				"AxisSide:Object", "baseType", "AxisSide" });
	}

} // ModelPackageImpl
