/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid;
import de.bsvrz.buv.plugin.pua.ganglinien.data.AggregationsTyp;
import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.MergedProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.PUAGanglinien;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Root;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap;
import de.bsvrz.pua.prot.client.dataobject.Column;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>PUA Ganglinien</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getRoot
 * <em>Root</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getName
 * <em>Name</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getMatrix
 * <em>Matrix</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getMatrixGrid
 * <em>Matrix Grid</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getPrecisionMap
 * <em>Precision Map</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getMergedProperties
 * <em>Merged Properties</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getAxes
 * <em>Axes</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getCurrentAxis
 * <em>Current Axis</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getZoomXFrom
 * <em>Zoom XFrom</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getZoomXTo
 * <em>Zoom XTo</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getXAxisStep
 * <em>XAxis Step</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#isAutoUpdateDiagram
 * <em>Auto Update Diagram</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#isShowDataTable
 * <em>Show Data Table</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getBackgroundColor
 * <em>Background Color</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getHelperLineColor
 * <em>Helper Line Color</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#getTitle
 * <em>Title</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.PUAGanglinienImpl#isShowHelperLines
 * <em>Show Helper Lines</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class PUAGanglinienImpl extends EObjectImpl implements PUAGanglinien {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMatrix() <em>Matrix</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMatrix()
	 * @generated
	 * @ordered
	 */
	protected TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> matrix;

	/**
	 * The cached value of the '{@link #getMatrixGrid() <em>Matrix Grid</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMatrixGrid()
	 * @generated
	 * @ordered
	 */
	protected MatrixGrid<AggregationsTyp, Column, LineProperties> matrixGrid;

	/**
	 * The cached value of the '{@link #getPrecisionMap()
	 * <em>Precision Map</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getPrecisionMap()
	 * @generated
	 * @ordered
	 */
	protected Map<Column, Double> precisionMap;

	/**
	 * The cached value of the '{@link #getMergedProperties()
	 * <em>Merged Properties</em>}' containment reference. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getMergedProperties()
	 * @generated
	 * @ordered
	 */
	protected MergedProperties mergedProperties;

	/**
	 * The cached value of the '{@link #getAxes() <em>Axes</em>}' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getAxes()
	 * @generated
	 * @ordered
	 */
	protected EList<AxisProperties> axes;

	/**
	 * The cached value of the '{@link #getCurrentAxis() <em>Current Axis</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getCurrentAxis()
	 * @generated
	 * @ordered
	 */
	protected AxisProperties currentAxis;

	/**
	 * The default value of the '{@link #getZoomXFrom() <em>Zoom XFrom</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getZoomXFrom()
	 * @generated
	 * @ordered
	 */
	protected static final Date ZOOM_XFROM_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getZoomXFrom() <em>Zoom XFrom</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getZoomXFrom()
	 * @generated
	 * @ordered
	 */
	protected Date zoomXFrom = ZOOM_XFROM_EDEFAULT;

	/**
	 * The default value of the '{@link #getZoomXTo() <em>Zoom XTo</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getZoomXTo()
	 * @generated
	 * @ordered
	 */
	protected static final Date ZOOM_XTO_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getZoomXTo() <em>Zoom XTo</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getZoomXTo()
	 * @generated
	 * @ordered
	 */
	protected Date zoomXTo = ZOOM_XTO_EDEFAULT;

	/**
	 * The default value of the '{@link #getXAxisStep() <em>XAxis Step</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getXAxisStep()
	 * @generated
	 * @ordered
	 */
	protected static final Long XAXIS_STEP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getXAxisStep() <em>XAxis Step</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getXAxisStep()
	 * @generated
	 * @ordered
	 */
	protected Long xAxisStep = XAXIS_STEP_EDEFAULT;

	/**
	 * The default value of the '{@link #isAutoUpdateDiagram()
	 * <em>Auto Update Diagram</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isAutoUpdateDiagram()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUTO_UPDATE_DIAGRAM_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isAutoUpdateDiagram()
	 * <em>Auto Update Diagram</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isAutoUpdateDiagram()
	 * @generated
	 * @ordered
	 */
	protected boolean autoUpdateDiagram = AUTO_UPDATE_DIAGRAM_EDEFAULT;

	/**
	 * The default value of the '{@link #isShowDataTable()
	 * <em>Show Data Table</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isShowDataTable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_DATA_TABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isShowDataTable()
	 * <em>Show Data Table</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isShowDataTable()
	 * @generated
	 * @ordered
	 */
	protected boolean showDataTable = SHOW_DATA_TABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getBackgroundColor()
	 * <em>Background Color</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected static final RGB BACKGROUND_COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBackgroundColor()
	 * <em>Background Color</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected RGB backgroundColor = BACKGROUND_COLOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getHelperLineColor()
	 * <em>Helper Line Color</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getHelperLineColor()
	 * @generated
	 * @ordered
	 */
	protected static final RGB HELPER_LINE_COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHelperLineColor()
	 * <em>Helper Line Color</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getHelperLineColor()
	 * @generated
	 * @ordered
	 */
	protected RGB helperLineColor = HELPER_LINE_COLOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected static final String TITLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected String title = TITLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isShowHelperLines()
	 * <em>Show Helper Lines</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isShowHelperLines()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_HELPER_LINES_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isShowHelperLines()
	 * <em>Show Helper Lines</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isShowHelperLines()
	 * @generated
	 * @ordered
	 */
	protected boolean showHelperLines = SHOW_HELPER_LINES_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PUAGanglinienImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ModelPackage.Literals.PUA_GANGLINIEN;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Root getRoot() {
		if (eContainerFeatureID() != ModelPackage.PUA_GANGLINIEN__ROOT) {
			return null;
		}
		return (Root) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetRoot(final Root newRoot,
			NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newRoot,
				ModelPackage.PUA_GANGLINIEN__ROOT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setRoot(final Root newRoot) {
		if (newRoot != eInternalContainer()
				|| (eContainerFeatureID() != ModelPackage.PUA_GANGLINIEN__ROOT && newRoot != null)) {
			if (EcoreUtil.isAncestor(this, newRoot)) {
				throw new IllegalArgumentException(
						"Recursive containment not allowed for " + toString());
			}
			NotificationChain msgs = null;
			if (eInternalContainer() != null) {
				msgs = eBasicRemoveFromContainer(msgs);
			}
			if (newRoot != null) {
				msgs = ((InternalEObject) newRoot).eInverseAdd(this,
						ModelPackage.ROOT__PUA_GANGLINIEN, Root.class, msgs);
			}
			msgs = basicSetRoot(newRoot, msgs);
			if (msgs != null) {
				msgs.dispatch();
			}
		} else if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__ROOT, newRoot, newRoot));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setName(final String newName) {
		final String oldName = name;
		name = newName;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__NAME, oldName, name));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> getMatrix() {
		return matrix;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetMatrix(
			final TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> newMatrix,
			NotificationChain msgs) {
		final TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> oldMatrix = matrix;
		matrix = newMatrix;
		if (eNotificationRequired()) {
			final ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET, ModelPackage.PUA_GANGLINIEN__MATRIX,
					oldMatrix, newMatrix);
			if (msgs == null) {
				msgs = notification;
			} else {
				msgs.add(notification);
			}
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setMatrix(
			final TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties> newMatrix) {
		if (newMatrix != matrix) {
			NotificationChain msgs = null;
			if (matrix != null) {
				msgs = ((InternalEObject) matrix).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE
								- ModelPackage.PUA_GANGLINIEN__MATRIX, null,
						msgs);
			}
			if (newMatrix != null) {
				msgs = ((InternalEObject) newMatrix).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE
								- ModelPackage.PUA_GANGLINIEN__MATRIX, null,
						msgs);
			}
			msgs = basicSetMatrix(newMatrix, msgs);
			if (msgs != null) {
				msgs.dispatch();
			}
		} else if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__MATRIX, newMatrix, newMatrix));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MatrixGrid<AggregationsTyp, Column, LineProperties> getMatrixGrid() {
		return matrixGrid;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setMatrixGrid(
			final MatrixGrid<AggregationsTyp, Column, LineProperties> newMatrixGrid) {
		final MatrixGrid<AggregationsTyp, Column, LineProperties> oldMatrixGrid = matrixGrid;
		matrixGrid = newMatrixGrid;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__MATRIX_GRID, oldMatrixGrid,
					matrixGrid));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Map<Column, Double> getPrecisionMap() {
		return precisionMap;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setPrecisionMap(final Map<Column, Double> newPrecisionMap) {
		final Map<Column, Double> oldPrecisionMap = precisionMap;
		precisionMap = newPrecisionMap;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__PRECISION_MAP,
					oldPrecisionMap, precisionMap));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MergedProperties getMergedProperties() {
		return mergedProperties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetMergedProperties(
			final MergedProperties newMergedProperties, NotificationChain msgs) {
		final MergedProperties oldMergedProperties = mergedProperties;
		mergedProperties = newMergedProperties;
		if (eNotificationRequired()) {
			final ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET,
					ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES,
					oldMergedProperties, newMergedProperties);
			if (msgs == null) {
				msgs = notification;
			} else {
				msgs.add(notification);
			}
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setMergedProperties(final MergedProperties newMergedProperties) {
		if (newMergedProperties != mergedProperties) {
			NotificationChain msgs = null;
			if (mergedProperties != null) {
				msgs = ((InternalEObject) mergedProperties).eInverseRemove(
						this, ModelPackage.MERGED_PROPERTIES__PUA_GANGLINIEN,
						MergedProperties.class, msgs);
			}
			if (newMergedProperties != null) {
				msgs = ((InternalEObject) newMergedProperties).eInverseAdd(
						this, ModelPackage.MERGED_PROPERTIES__PUA_GANGLINIEN,
						MergedProperties.class, msgs);
			}
			msgs = basicSetMergedProperties(newMergedProperties, msgs);
			if (msgs != null) {
				msgs.dispatch();
			}
		} else if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES,
					newMergedProperties, newMergedProperties));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<AxisProperties> getAxes() {
		if (axes == null) {
			axes = new EObjectContainmentEList<AxisProperties>(
					AxisProperties.class, this,
					ModelPackage.PUA_GANGLINIEN__AXES);
		}
		return axes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AxisProperties getCurrentAxis() {
		if (currentAxis != null && currentAxis.eIsProxy()) {
			final InternalEObject oldCurrentAxis = (InternalEObject) currentAxis;
			currentAxis = (AxisProperties) eResolveProxy(oldCurrentAxis);
			if (currentAxis != oldCurrentAxis) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							ModelPackage.PUA_GANGLINIEN__CURRENT_AXIS,
							oldCurrentAxis, currentAxis));
				}
			}
		}
		return currentAxis;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AxisProperties basicGetCurrentAxis() {
		return currentAxis;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setCurrentAxis(final AxisProperties newCurrentAxis) {
		final AxisProperties oldCurrentAxis = currentAxis;
		currentAxis = newCurrentAxis;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__CURRENT_AXIS, oldCurrentAxis,
					currentAxis));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Date getZoomXFrom() {
		return zoomXFrom;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setZoomXFrom(final Date newZoomXFrom) {
		final Date oldZoomXFrom = zoomXFrom;
		zoomXFrom = newZoomXFrom;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__ZOOM_XFROM, oldZoomXFrom,
					zoomXFrom));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Date getZoomXTo() {
		return zoomXTo;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setZoomXTo(final Date newZoomXTo) {
		final Date oldZoomXTo = zoomXTo;
		zoomXTo = newZoomXTo;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__ZOOM_XTO, oldZoomXTo, zoomXTo));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Long getXAxisStep() {
		return xAxisStep;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setXAxisStep(final Long newXAxisStep) {
		final Long oldXAxisStep = xAxisStep;
		xAxisStep = newXAxisStep;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__XAXIS_STEP, oldXAxisStep,
					xAxisStep));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isAutoUpdateDiagram() {
		return autoUpdateDiagram;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setAutoUpdateDiagram(final boolean newAutoUpdateDiagram) {
		final boolean oldAutoUpdateDiagram = autoUpdateDiagram;
		autoUpdateDiagram = newAutoUpdateDiagram;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM,
					oldAutoUpdateDiagram, autoUpdateDiagram));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isShowDataTable() {
		return showDataTable;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setShowDataTable(final boolean newShowDataTable) {
		final boolean oldShowDataTable = showDataTable;
		showDataTable = newShowDataTable;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__SHOW_DATA_TABLE,
					oldShowDataTable, showDataTable));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public RGB getBackgroundColor() {
		return backgroundColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setBackgroundColor(final RGB newBackgroundColor) {
		final RGB oldBackgroundColor = backgroundColor;
		backgroundColor = newBackgroundColor;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__BACKGROUND_COLOR,
					oldBackgroundColor, backgroundColor));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public RGB getHelperLineColor() {
		return helperLineColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setHelperLineColor(final RGB newHelperLineColor) {
		final RGB oldHelperLineColor = helperLineColor;
		helperLineColor = newHelperLineColor;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__HELPER_LINE_COLOR,
					oldHelperLineColor, helperLineColor));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setTitle(final String newTitle) {
		final String oldTitle = title;
		title = newTitle;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__TITLE, oldTitle, title));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isShowHelperLines() {
		return showHelperLines;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setShowHelperLines(final boolean newShowHelperLines) {
		final boolean oldShowHelperLines = showHelperLines;
		showHelperLines = newShowHelperLines;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					ModelPackage.PUA_GANGLINIEN__SHOW_HELPER_LINES,
					oldShowHelperLines, showHelperLines));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(final InternalEObject otherEnd,
			final int featureID, NotificationChain msgs) {
		switch (featureID) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			if (eInternalContainer() != null) {
				msgs = eBasicRemoveFromContainer(msgs);
			}
			return basicSetRoot((Root) otherEnd, msgs);
		case ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES:
			if (mergedProperties != null) {
				msgs = ((InternalEObject) mergedProperties)
						.eInverseRemove(
								this,
								EOPPOSITE_FEATURE_BASE
										- ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES,
								null, msgs);
			}
			return basicSetMergedProperties((MergedProperties) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(final InternalEObject otherEnd,
			final int featureID, final NotificationChain msgs) {
		switch (featureID) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			return basicSetRoot(null, msgs);
		case ModelPackage.PUA_GANGLINIEN__MATRIX:
			return basicSetMatrix(null, msgs);
		case ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES:
			return basicSetMergedProperties(null, msgs);
		case ModelPackage.PUA_GANGLINIEN__AXES:
			return ((InternalEList<?>) getAxes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(
			final NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			return eInternalContainer().eInverseRemove(this,
					ModelPackage.ROOT__PUA_GANGLINIEN, Root.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(final int featureID, final boolean resolve,
			final boolean coreType) {
		switch (featureID) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			return getRoot();
		case ModelPackage.PUA_GANGLINIEN__NAME:
			return getName();
		case ModelPackage.PUA_GANGLINIEN__MATRIX:
			return getMatrix();
		case ModelPackage.PUA_GANGLINIEN__MATRIX_GRID:
			return getMatrixGrid();
		case ModelPackage.PUA_GANGLINIEN__PRECISION_MAP:
			return getPrecisionMap();
		case ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES:
			return getMergedProperties();
		case ModelPackage.PUA_GANGLINIEN__AXES:
			return getAxes();
		case ModelPackage.PUA_GANGLINIEN__CURRENT_AXIS:
			if (resolve) {
				return getCurrentAxis();
			}
			return basicGetCurrentAxis();
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XFROM:
			return getZoomXFrom();
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XTO:
			return getZoomXTo();
		case ModelPackage.PUA_GANGLINIEN__XAXIS_STEP:
			return getXAxisStep();
		case ModelPackage.PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM:
			return isAutoUpdateDiagram();
		case ModelPackage.PUA_GANGLINIEN__SHOW_DATA_TABLE:
			return isShowDataTable();
		case ModelPackage.PUA_GANGLINIEN__BACKGROUND_COLOR:
			return getBackgroundColor();
		case ModelPackage.PUA_GANGLINIEN__HELPER_LINE_COLOR:
			return getHelperLineColor();
		case ModelPackage.PUA_GANGLINIEN__TITLE:
			return getTitle();
		case ModelPackage.PUA_GANGLINIEN__SHOW_HELPER_LINES:
			return isShowHelperLines();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(final int featureID, final Object newValue) {
		switch (featureID) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			setRoot((Root) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__NAME:
			setName((String) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__MATRIX:
			setMatrix((TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties>) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__MATRIX_GRID:
			setMatrixGrid((MatrixGrid<AggregationsTyp, Column, LineProperties>) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__PRECISION_MAP:
			setPrecisionMap((Map<Column, Double>) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES:
			setMergedProperties((MergedProperties) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__AXES:
			getAxes().clear();
			getAxes().addAll((Collection<? extends AxisProperties>) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__CURRENT_AXIS:
			setCurrentAxis((AxisProperties) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XFROM:
			setZoomXFrom((Date) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XTO:
			setZoomXTo((Date) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__XAXIS_STEP:
			setXAxisStep((Long) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM:
			setAutoUpdateDiagram((Boolean) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__SHOW_DATA_TABLE:
			setShowDataTable((Boolean) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__BACKGROUND_COLOR:
			setBackgroundColor((RGB) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__HELPER_LINE_COLOR:
			setHelperLineColor((RGB) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__TITLE:
			setTitle((String) newValue);
			return;
		case ModelPackage.PUA_GANGLINIEN__SHOW_HELPER_LINES:
			setShowHelperLines((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(final int featureID) {
		switch (featureID) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			setRoot((Root) null);
			return;
		case ModelPackage.PUA_GANGLINIEN__NAME:
			setName(NAME_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__MATRIX:
			setMatrix((TwoDimensionalEMFMap<AggregationsTyp, Column, LineProperties>) null);
			return;
		case ModelPackage.PUA_GANGLINIEN__MATRIX_GRID:
			setMatrixGrid((MatrixGrid<AggregationsTyp, Column, LineProperties>) null);
			return;
		case ModelPackage.PUA_GANGLINIEN__PRECISION_MAP:
			setPrecisionMap((Map<Column, Double>) null);
			return;
		case ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES:
			setMergedProperties((MergedProperties) null);
			return;
		case ModelPackage.PUA_GANGLINIEN__AXES:
			getAxes().clear();
			return;
		case ModelPackage.PUA_GANGLINIEN__CURRENT_AXIS:
			setCurrentAxis((AxisProperties) null);
			return;
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XFROM:
			setZoomXFrom(ZOOM_XFROM_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XTO:
			setZoomXTo(ZOOM_XTO_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__XAXIS_STEP:
			setXAxisStep(XAXIS_STEP_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM:
			setAutoUpdateDiagram(AUTO_UPDATE_DIAGRAM_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__SHOW_DATA_TABLE:
			setShowDataTable(SHOW_DATA_TABLE_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__BACKGROUND_COLOR:
			setBackgroundColor(BACKGROUND_COLOR_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__HELPER_LINE_COLOR:
			setHelperLineColor(HELPER_LINE_COLOR_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__TITLE:
			setTitle(TITLE_EDEFAULT);
			return;
		case ModelPackage.PUA_GANGLINIEN__SHOW_HELPER_LINES:
			setShowHelperLines(SHOW_HELPER_LINES_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(final int featureID) {
		switch (featureID) {
		case ModelPackage.PUA_GANGLINIEN__ROOT:
			return getRoot() != null;
		case ModelPackage.PUA_GANGLINIEN__NAME:
			return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
					.equals(name);
		case ModelPackage.PUA_GANGLINIEN__MATRIX:
			return matrix != null;
		case ModelPackage.PUA_GANGLINIEN__MATRIX_GRID:
			return matrixGrid != null;
		case ModelPackage.PUA_GANGLINIEN__PRECISION_MAP:
			return precisionMap != null;
		case ModelPackage.PUA_GANGLINIEN__MERGED_PROPERTIES:
			return mergedProperties != null;
		case ModelPackage.PUA_GANGLINIEN__AXES:
			return axes != null && !axes.isEmpty();
		case ModelPackage.PUA_GANGLINIEN__CURRENT_AXIS:
			return currentAxis != null;
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XFROM:
			return ZOOM_XFROM_EDEFAULT == null ? zoomXFrom != null
					: !ZOOM_XFROM_EDEFAULT.equals(zoomXFrom);
		case ModelPackage.PUA_GANGLINIEN__ZOOM_XTO:
			return ZOOM_XTO_EDEFAULT == null ? zoomXTo != null
					: !ZOOM_XTO_EDEFAULT.equals(zoomXTo);
		case ModelPackage.PUA_GANGLINIEN__XAXIS_STEP:
			return XAXIS_STEP_EDEFAULT == null ? xAxisStep != null
					: !XAXIS_STEP_EDEFAULT.equals(xAxisStep);
		case ModelPackage.PUA_GANGLINIEN__AUTO_UPDATE_DIAGRAM:
			return autoUpdateDiagram != AUTO_UPDATE_DIAGRAM_EDEFAULT;
		case ModelPackage.PUA_GANGLINIEN__SHOW_DATA_TABLE:
			return showDataTable != SHOW_DATA_TABLE_EDEFAULT;
		case ModelPackage.PUA_GANGLINIEN__BACKGROUND_COLOR:
			return BACKGROUND_COLOR_EDEFAULT == null ? backgroundColor != null
					: !BACKGROUND_COLOR_EDEFAULT.equals(backgroundColor);
		case ModelPackage.PUA_GANGLINIEN__HELPER_LINE_COLOR:
			return HELPER_LINE_COLOR_EDEFAULT == null ? helperLineColor != null
					: !HELPER_LINE_COLOR_EDEFAULT.equals(helperLineColor);
		case ModelPackage.PUA_GANGLINIEN__TITLE:
			return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT
					.equals(title);
		case ModelPackage.PUA_GANGLINIEN__SHOW_HELPER_LINES:
			return showHelperLines != SHOW_HELPER_LINES_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", matrixGrid: ");
		result.append(matrixGrid);
		result.append(", precisionMap: ");
		result.append(precisionMap);
		result.append(", zoomXFrom: ");
		result.append(zoomXFrom);
		result.append(", zoomXTo: ");
		result.append(zoomXTo);
		result.append(", xAxisStep: ");
		result.append(xAxisStep);
		result.append(", autoUpdateDiagram: ");
		result.append(autoUpdateDiagram);
		result.append(", showDataTable: ");
		result.append(showDataTable);
		result.append(", backgroundColor: ");
		result.append(backgroundColor);
		result.append(", helperLineColor: ");
		result.append(helperLineColor);
		result.append(", title: ");
		result.append(title);
		result.append(", showHelperLines: ");
		result.append(showHelperLines);
		result.append(')');
		return result.toString();
	}

} // PUAGanglinienImpl
