/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Protokoll;
import de.bsvrz.buv.plugin.pua.ganglinien.model.Root;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAdministrationData;
import de.bsvrz.pua.prot.client.dataobject.ProtocolAggregationData;
import de.bsvrz.pua.prot.util.ProcessingParameter;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Protokoll</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl#getRoot <em>Root</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl#getProcessingParameter <em>Processing Parameter</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl#getAdministrationData <em>Administration Data</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.pua.ganglinien.model.impl.ProtokollImpl#getAggregationData <em>Aggregation Data</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProtokollImpl extends EObjectImpl implements Protokoll {
	/**
	 * The default value of the '{@link #getProcessingParameter() <em>Processing Parameter</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getProcessingParameter()
	 * @generated
	 * @ordered
	 */
	protected static final ProcessingParameter PROCESSING_PARAMETER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProcessingParameter() <em>Processing Parameter</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getProcessingParameter()
	 * @generated
	 * @ordered
	 */
	protected ProcessingParameter processingParameter = PROCESSING_PARAMETER_EDEFAULT;

	/**
	 * The default value of the '{@link #getAdministrationData() <em>Administration Data</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAdministrationData()
	 * @generated
	 * @ordered
	 */
	protected static final ProtocolAdministrationData ADMINISTRATION_DATA_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAdministrationData() <em>Administration Data</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAdministrationData()
	 * @generated
	 * @ordered
	 */
	protected ProtocolAdministrationData administrationData = ADMINISTRATION_DATA_EDEFAULT;

	/**
	 * The default value of the '{@link #getAggregationData() <em>Aggregation Data</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAggregationData()
	 * @generated
	 * @ordered
	 */
	protected static final ProtocolAggregationData AGGREGATION_DATA_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAggregationData() <em>Aggregation Data</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAggregationData()
	 * @generated
	 * @ordered
	 */
	protected ProtocolAggregationData aggregationData = AGGREGATION_DATA_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtokollImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ModelPackage.Literals.PROTOKOLL;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Root getRoot() {
		if (eContainerFeatureID() != ModelPackage.PROTOKOLL__ROOT) return null;
		return (Root)eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRoot(Root newRoot, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newRoot, ModelPackage.PROTOKOLL__ROOT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setRoot(Root newRoot) {
		if (newRoot != eInternalContainer() || (eContainerFeatureID() != ModelPackage.PROTOKOLL__ROOT && newRoot != null)) {
			if (EcoreUtil.isAncestor(this, newRoot))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRoot != null)
				msgs = ((InternalEObject)newRoot).eInverseAdd(this, ModelPackage.ROOT__PROTOKOLL, Root.class, msgs);
			msgs = basicSetRoot(newRoot, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.PROTOKOLL__ROOT, newRoot, newRoot));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessingParameter getProcessingParameter() {
		return processingParameter;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessingParameter(
			ProcessingParameter newProcessingParameter) {
		ProcessingParameter oldProcessingParameter = processingParameter;
		processingParameter = newProcessingParameter;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.PROTOKOLL__PROCESSING_PARAMETER, oldProcessingParameter, processingParameter));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ProtocolAdministrationData getAdministrationData() {
		return administrationData;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAdministrationData(
			ProtocolAdministrationData newAdministrationData) {
		ProtocolAdministrationData oldAdministrationData = administrationData;
		administrationData = newAdministrationData;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.PROTOKOLL__ADMINISTRATION_DATA, oldAdministrationData, administrationData));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ProtocolAggregationData getAggregationData() {
		return aggregationData;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAggregationData(ProtocolAggregationData newAggregationData) {
		ProtocolAggregationData oldAggregationData = aggregationData;
		aggregationData = newAggregationData;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.PROTOKOLL__AGGREGATION_DATA, oldAggregationData, aggregationData));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModelPackage.PROTOKOLL__ROOT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetRoot((Root)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ModelPackage.PROTOKOLL__ROOT:
				return basicSetRoot(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ModelPackage.PROTOKOLL__ROOT:
				return eInternalContainer().eInverseRemove(this, ModelPackage.ROOT__PROTOKOLL, Root.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ModelPackage.PROTOKOLL__ROOT:
				return getRoot();
			case ModelPackage.PROTOKOLL__PROCESSING_PARAMETER:
				return getProcessingParameter();
			case ModelPackage.PROTOKOLL__ADMINISTRATION_DATA:
				return getAdministrationData();
			case ModelPackage.PROTOKOLL__AGGREGATION_DATA:
				return getAggregationData();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ModelPackage.PROTOKOLL__ROOT:
				setRoot((Root)newValue);
				return;
			case ModelPackage.PROTOKOLL__PROCESSING_PARAMETER:
				setProcessingParameter((ProcessingParameter)newValue);
				return;
			case ModelPackage.PROTOKOLL__ADMINISTRATION_DATA:
				setAdministrationData((ProtocolAdministrationData)newValue);
				return;
			case ModelPackage.PROTOKOLL__AGGREGATION_DATA:
				setAggregationData((ProtocolAggregationData)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ModelPackage.PROTOKOLL__ROOT:
				setRoot((Root)null);
				return;
			case ModelPackage.PROTOKOLL__PROCESSING_PARAMETER:
				setProcessingParameter(PROCESSING_PARAMETER_EDEFAULT);
				return;
			case ModelPackage.PROTOKOLL__ADMINISTRATION_DATA:
				setAdministrationData(ADMINISTRATION_DATA_EDEFAULT);
				return;
			case ModelPackage.PROTOKOLL__AGGREGATION_DATA:
				setAggregationData(AGGREGATION_DATA_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ModelPackage.PROTOKOLL__ROOT:
				return getRoot() != null;
			case ModelPackage.PROTOKOLL__PROCESSING_PARAMETER:
				return PROCESSING_PARAMETER_EDEFAULT == null ? processingParameter != null : !PROCESSING_PARAMETER_EDEFAULT.equals(processingParameter);
			case ModelPackage.PROTOKOLL__ADMINISTRATION_DATA:
				return ADMINISTRATION_DATA_EDEFAULT == null ? administrationData != null : !ADMINISTRATION_DATA_EDEFAULT.equals(administrationData);
			case ModelPackage.PROTOKOLL__AGGREGATION_DATA:
				return AGGREGATION_DATA_EDEFAULT == null ? aggregationData != null : !AGGREGATION_DATA_EDEFAULT.equals(aggregationData);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (processingParameter: ");
		result.append(processingParameter);
		result.append(", administrationData: ");
		result.append(administrationData);
		result.append(", aggregationData: ");
		result.append(aggregationData);
		result.append(')');
		return result.toString();
	}

} // ProtokollImpl
