package de.bsvrz.buv.plugin.pua.ganglinien.model.observables;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;

/**
 * An Observable list wrapper for {@link AxisProperties}
 * 
 * @generated
 */
public class AxisPropertiesOS {
	public final IObservableSet o;

	public AxisPropertiesOS(final IObservableSet observableSet) {
		Object type = observableSet.getElementType();
		if (type instanceof EReference) {
			type = ((EReference) type).getEType().getInstanceClass();
		}
		Assert.isTrue(null == type || AxisProperties.class.equals(type));
		o = observableSet;
	}

	public IObservableMap getMapFeature(final EStructuralFeature feature) {
		if (ModelPackage.Literals.AXIS_PROPERTIES__TITLE.equals(feature)) {
			return getTitle();
		}
		if (ModelPackage.Literals.AXIS_PROPERTIES__AXIS_SIDE.equals(feature)) {
			return getAxisSide();
		}
		if (ModelPackage.Literals.AXIS_PROPERTIES__MIN.equals(feature)) {
			return getMin();
		}
		if (ModelPackage.Literals.AXIS_PROPERTIES__MAX.equals(feature)) {
			return getMax();
		}
		if (ModelPackage.Literals.AXIS_PROPERTIES__VISIBLE_GRID.equals(feature)) {
			return getVisibleGrid();
		}
		if (ModelPackage.Literals.AXIS_PROPERTIES__STEP.equals(feature)) {
			return getStep();
		}
		if (ModelPackage.Literals.AXIS_PROPERTIES__DEFAULTS.equals(feature)) {
			return getDefaults().o;
		}
		throw new UnsupportedOperationException("Feature " + feature
				+ " not supported!");
	}

	// features from type AxisProperties

	private IObservableMap title = null;

	public IObservableMap getTitle() {
		if (null == title) {
			title = EMFObservables.observeMap(o,
					ModelPackage.Literals.AXIS_PROPERTIES__TITLE);
		}
		return title;
	}

	private IObservableMap axisSide = null;

	public IObservableMap getAxisSide() {
		if (null == axisSide) {
			axisSide = EMFObservables.observeMap(o,
					ModelPackage.Literals.AXIS_PROPERTIES__AXIS_SIDE);
		}
		return axisSide;
	}

	private IObservableMap min = null;

	public IObservableMap getMin() {
		if (null == min) {
			min = EMFObservables.observeMap(o,
					ModelPackage.Literals.AXIS_PROPERTIES__MIN);
		}
		return min;
	}

	private IObservableMap max = null;

	public IObservableMap getMax() {
		if (null == max) {
			max = EMFObservables.observeMap(o,
					ModelPackage.Literals.AXIS_PROPERTIES__MAX);
		}
		return max;
	}

	private IObservableMap visibleGrid = null;

	public IObservableMap getVisibleGrid() {
		if (null == visibleGrid) {
			visibleGrid = EMFObservables.observeMap(o,
					ModelPackage.Literals.AXIS_PROPERTIES__VISIBLE_GRID);
		}
		return visibleGrid;
	}

	private IObservableMap step = null;

	public IObservableMap getStep() {
		if (null == step) {
			step = EMFObservables.observeMap(o,
					ModelPackage.Literals.AXIS_PROPERTIES__STEP);
		}
		return step;
	}

	// ??? many feature in set

	private AxisPropertiesOM<AxisProperties> defaults = null;

	public AxisPropertiesOM<AxisProperties> getDefaults() {
		if (null == defaults) {
			defaults = new AxisPropertiesOM<AxisProperties>(
					AxisProperties.class, EMFObservables.observeMap(o,
							ModelPackage.Literals.AXIS_PROPERTIES__DEFAULTS));
		}
		return defaults;
	}

}
