package de.bsvrz.buv.plugin.pua.ganglinien.model.observables;

import java.util.List;
import java.util.Set;

import net.randomice.emf.observables.runtime.IObservableListObject;
import net.randomice.emf.observables.runtime.ObservableSetRootObjects;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ListToSetAdapter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelFactory;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;

/**
 * An Observable list wrapper for {@link LineProperties}
 * 
 * @generated
 */
public class LinePropertiesOL implements IObservableListObject<LineProperties> {
	public final IObservableList o;

	public LinePropertiesOL(final IObservableList observableList) {
		Object type = observableList.getElementType();
		if (type instanceof EReference) {
			type = ((EReference) type).getEType().getInstanceClass();
		}
		Assert.isTrue(null == type || LineProperties.class.equals(type));
		o = observableList;
	}

	@SuppressWarnings("unchecked")
	public List<LineProperties> getList() {
		return o;
	}

	public LinePropertiesOO add(final LineProperties object) {
		getObservableObjects();
		o.add(object);
		return observableObjects.get(object);
	}

	public LinePropertiesOO addNew() {
		return add(ModelFactory.eINSTANCE.createLineProperties());
	}

	public boolean isEmpty() {
		return o.isEmpty();
	}

	private IObservableSet listToSetAdapter = null;

	public IObservableSet getObservableSet() {
		if (null == listToSetAdapter) {
			listToSetAdapter = new ListToSetAdapter(o);
		}
		return listToSetAdapter;
	}

	private ObservableSetRootObjects<LineProperties, LinePropertiesOO> observableObjects = null;

	@SuppressWarnings("unchecked")
	public Set<LinePropertiesOO> getObservableObjects() {
		if (null == observableObjects) {
			observableObjects = new ObservableSetRootObjects<LineProperties, LinePropertiesOO>(
					getObservableSet(), LinePropertiesOO.class,
					LinePropertiesOO.CREATOR);
		}
		return observableObjects;
	}

	public IObservableMap getMapFeature(final EStructuralFeature feature) {
		if (ModelPackage.Literals.LINE_PROPERTIES__SERIES_TYPE.equals(feature)) {
			return getSeriesType();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_STYLE.equals(feature)) {
			return getLineStyle();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_THICKNESS
				.equals(feature)) {
			return getLineThickness();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_RGB.equals(feature)) {
			return getLineRGB();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__MARKER_TYPE.equals(feature)) {
			return getMarkerType();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__FILL_RGB.equals(feature)) {
			return getFillRGB();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__AXIS.equals(feature)) {
			return getAxis().o;
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__VALUES.equals(feature)) {
			return getValues();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS.equals(feature)) {
			return getDefaults().o;
		}
		throw new UnsupportedOperationException("Feature " + feature
				+ " not supported!");
	}

	// features from type LineProperties

	private IObservableMap seriesType = null;

	public IObservableMap getSeriesType() {
		if (null == seriesType) {
			seriesType = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__SERIES_TYPE);
		}
		return seriesType;
	}

	private IObservableMap lineStyle = null;

	public IObservableMap getLineStyle() {
		if (null == lineStyle) {
			lineStyle = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__LINE_STYLE);
		}
		return lineStyle;
	}

	private IObservableMap lineThickness = null;

	public IObservableMap getLineThickness() {
		if (null == lineThickness) {
			lineThickness = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__LINE_THICKNESS);
		}
		return lineThickness;
	}

	private IObservableMap lineRGB = null;

	public IObservableMap getLineRGB() {
		if (null == lineRGB) {
			lineRGB = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__LINE_RGB);
		}
		return lineRGB;
	}

	private IObservableMap markerType = null;

	public IObservableMap getMarkerType() {
		if (null == markerType) {
			markerType = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__MARKER_TYPE);
		}
		return markerType;
	}

	private IObservableMap fillRGB = null;

	public IObservableMap getFillRGB() {
		if (null == fillRGB) {
			fillRGB = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__FILL_RGB);
		}
		return fillRGB;
	}

	private AxisPropertiesOM<LineProperties> axis = null;

	public AxisPropertiesOM<LineProperties> getAxis() {
		if (null == axis) {
			axis = new AxisPropertiesOM<LineProperties>(LineProperties.class,
					EMFObservables.observeMap(getObservableSet(),
							ModelPackage.Literals.LINE_PROPERTIES__AXIS));
		}
		return axis;
	}

	private IObservableMap values = null;

	public IObservableMap getValues() {
		if (null == values) {
			values = EMFObservables.observeMap(getObservableSet(),
					ModelPackage.Literals.LINE_PROPERTIES__VALUES);
		}
		return values;
	}

	private LinePropertiesOM<LineProperties> defaults = null;

	public LinePropertiesOM<LineProperties> getDefaults() {
		if (null == defaults) {
			defaults = new LinePropertiesOM<LineProperties>(
					LineProperties.class, EMFObservables.observeMap(
							getObservableSet(),
							ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS));
		}
		return defaults;
	}

}
