package de.bsvrz.buv.plugin.pua.ganglinien.model.observables;

import java.util.NavigableMap;

import net.randomice.emf.observables.runtime.IObservableAbstractListObject;
import net.randomice.emf.observables.runtime.IObservableObject;

import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.LineThickness;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelFactory;
import de.bsvrz.buv.plugin.pua.ganglinien.model.ModelPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.model.SeriesType;

/**
 * An Observable object wrapper for {@link LineProperties}
 * 
 * @generated
 */
public class LinePropertiesOO implements IObservableObject<LineProperties> {
	// root object stuff

	public final static Creator<LineProperties, LinePropertiesOO> CREATOR = new Creator<LineProperties, LinePropertiesOO>() {
		public LinePropertiesOO createRoot(final LineProperties object) {
			return new LinePropertiesOO(Observables.constantObservableValue(
					object, LineProperties.class));
		}

		public LinePropertiesOO createRoot() {
			return createRoot(ModelFactory.eINSTANCE.createLineProperties());
		}
	};

	public static LinePropertiesOO createRoot(final LineProperties object) {
		return CREATOR.createRoot(object);
	}

	public static LinePropertiesOO createRoot() {
		return CREATOR.createRoot();
	}

	public EClass eClass() {
		return LinePropertiesOO.eClassStatic();
	}

	public static EClass eClassStatic() {
		return ModelPackage.Literals.LINE_PROPERTIES;
	}

	// instance stuff

	public final IObservableValue o;

	public final IObservableValue getObservable() {
		return o;
	}

	public LinePropertiesOO(final IObservableValue observableValue) {
		Object type = observableValue.getValueType();
		if (type instanceof EReference) {
			type = ((EReference) type).getEType().getInstanceClass();
		}
		Assert.isTrue(null == type || LineProperties.class.equals(type));
		o = observableValue;
	}

	public LineProperties getValue() {
		return (LineProperties) o.getValue();
	}

	public void setValue(final LineProperties newValue) {
		o.setValue(newValue);
	}

	// generic feature getters

	public IObservableValue getValueFeature(final EStructuralFeature feature) {
		if (ModelPackage.Literals.LINE_PROPERTIES__SERIES_TYPE.equals(feature)) {
			return getSeriesType();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_STYLE.equals(feature)) {
			return getLineStyle();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_THICKNESS
				.equals(feature)) {
			return getLineThickness();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__LINE_RGB.equals(feature)) {
			return getLineRGB();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__MARKER_TYPE.equals(feature)) {
			return getMarkerType();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__FILL_RGB.equals(feature)) {
			return getFillRGB();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__AXIS.equals(feature)) {
			return getAxis().o;
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__VALUES.equals(feature)) {
			return getValues();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS.equals(feature)) {
			return getDefaults().o;
		}
		throw new UnsupportedOperationException("Feature " + feature
				+ " not supported!");
	}

	public IObservableList getListFeature(final EStructuralFeature feature) {
		throw new UnsupportedOperationException("Feature " + feature
				+ " not supported!");
	}

	public IObservableObject<?> getValueObject(final EReference feature) {
		if (ModelPackage.Literals.LINE_PROPERTIES__AXIS.equals(feature)) {
			return getAxis();
		}
		if (ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS.equals(feature)) {
			return getDefaults();
		}
		throw new UnsupportedOperationException("Feature " + feature
				+ " not supported!");
	}

	public IObservableAbstractListObject<?> getListObject(
			final EReference feature) {
		throw new UnsupportedOperationException("Feature " + feature
				+ " not supported!");
	}

	// features from type LineProperties

	private IObservableValue seriesType = null;

	public IObservableValue getSeriesType() {
		if (null == seriesType) {
			seriesType = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__SERIES_TYPE);
		}
		return seriesType;
	}

	public SeriesType getSeriesTypeValue() {
		return (SeriesType) getSeriesType().getValue();
	}

	public IObservableValue setSeriesType(final SeriesType value) {
		getSeriesType().setValue(value);
		return seriesType;
	}

	private IObservableValue lineStyle = null;

	public IObservableValue getLineStyle() {
		if (null == lineStyle) {
			lineStyle = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__LINE_STYLE);
		}
		return lineStyle;
	}

	public LineStyle getLineStyleValue() {
		return (LineStyle) getLineStyle().getValue();
	}

	public IObservableValue setLineStyle(final LineStyle value) {
		getLineStyle().setValue(value);
		return lineStyle;
	}

	private IObservableValue lineThickness = null;

	public IObservableValue getLineThickness() {
		if (null == lineThickness) {
			lineThickness = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__LINE_THICKNESS);
		}
		return lineThickness;
	}

	public LineThickness getLineThicknessValue() {
		return (LineThickness) getLineThickness().getValue();
	}

	public IObservableValue setLineThickness(final LineThickness value) {
		getLineThickness().setValue(value);
		return lineThickness;
	}

	private IObservableValue lineRGB = null;

	public IObservableValue getLineRGB() {
		if (null == lineRGB) {
			lineRGB = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__LINE_RGB);
		}
		return lineRGB;
	}

	public RGB getLineRGBValue() {
		return (RGB) getLineRGB().getValue();
	}

	public IObservableValue setLineRGB(final RGB value) {
		getLineRGB().setValue(value);
		return lineRGB;
	}

	private IObservableValue markerType = null;

	public IObservableValue getMarkerType() {
		if (null == markerType) {
			markerType = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__MARKER_TYPE);
		}
		return markerType;
	}

	public MarkerType getMarkerTypeValue() {
		return (MarkerType) getMarkerType().getValue();
	}

	public IObservableValue setMarkerType(final MarkerType value) {
		getMarkerType().setValue(value);
		return markerType;
	}

	private IObservableValue fillRGB = null;

	public IObservableValue getFillRGB() {
		if (null == fillRGB) {
			fillRGB = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__FILL_RGB);
		}
		return fillRGB;
	}

	public RGB getFillRGBValue() {
		return (RGB) getFillRGB().getValue();
	}

	public IObservableValue setFillRGB(final RGB value) {
		getFillRGB().setValue(value);
		return fillRGB;
	}

	private AxisPropertiesOO axis = null;

	public AxisPropertiesOO getAxis() {
		if (null == axis) {
			axis = new AxisPropertiesOO(EMFObservables.observeDetailValue(
					o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__AXIS));
		}
		return axis;
	}

	public AxisProperties getAxisValue() {
		return getAxis().getValue();
	}

	public AxisPropertiesOO setAxis(final AxisProperties value) {
		getAxis().setValue(value);
		return axis;
	}

	private IObservableValue values = null;

	public IObservableValue getValues() {
		if (null == values) {
			values = EMFObservables.observeDetailValue(o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__VALUES);
		}
		return values;
	}

	@SuppressWarnings("unchecked")
	public NavigableMap<Long, Double> getValuesValue() {
		return (NavigableMap<Long, Double>) getValues().getValue();
	}

	public IObservableValue setValues(final NavigableMap<Long, Double> value) {
		getValues().setValue(value);
		return values;
	}

	private LinePropertiesOO defaults = null;

	public LinePropertiesOO getDefaults() {
		if (null == defaults) {
			defaults = new LinePropertiesOO(EMFObservables.observeDetailValue(
					o.getRealm(), o,
					ModelPackage.Literals.LINE_PROPERTIES__DEFAULTS));
		}
		return defaults;
	}

	public LineProperties getDefaultsValue() {
		return getDefaults().getValue();
	}

	public LinePropertiesOO setDefaults(final LineProperties value) {
		getDefaults().setValue(value);
		return defaults;
	}

}
