/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapFactory
 * @model kind="package"
 * @generated
 */
public interface TwoDimMapPackage extends EPackage {
	/**
	 * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME = "twoDimMap";

	/**
	 * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI = "http://www.bitctrl.de/bsvrz/buv/pua/twoDimMap";

	/**
	 * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX = "de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap";

	/**
	 * The singleton instance of the package. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	TwoDimMapPackage eINSTANCE = de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl
			.init();

	/**
	 * The meta object id for the '{@link com.bitctrl.util.ITwoDimensionalMap
	 * <em>ITwo Dimensional Map</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see com.bitctrl.util.ITwoDimensionalMap
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getITwoDimensionalMap()
	 * @generated
	 */
	int ITWO_DIMENSIONAL_MAP = 4;

	/**
	 * The number of structural features of the '<em>ITwo Dimensional Map</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ITWO_DIMENSIONAL_MAP_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl
	 * <em>Two Dimensional EMF Map</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getTwoDimensionalEMFMap()
	 * @generated
	 */
	int TWO_DIMENSIONAL_EMF_MAP = 0;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TWO_DIMENSIONAL_EMF_MAP__ROWS = ITWO_DIMENSIONAL_MAP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TWO_DIMENSIONAL_EMF_MAP__COLUMNS = ITWO_DIMENSIONAL_MAP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TWO_DIMENSIONAL_EMF_MAP__DATA = ITWO_DIMENSIONAL_MAP_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '
	 * <em>Two Dimensional EMF Map</em>' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TWO_DIMENSIONAL_EMF_MAP_FEATURE_COUNT = ITWO_DIMENSIONAL_MAP_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowImpl
	 * <em>Row</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getRow()
	 * @generated
	 */
	int ROW = 1;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROW__ENTRIES = 0;

	/**
	 * The number of structural features of the '<em>Row</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROW_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowEntryImpl
	 * <em>Row Entry</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowEntryImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getRowEntry()
	 * @generated
	 */
	int ROW_ENTRY = 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROW_ENTRY__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Row Entry</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROW_ENTRY_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.IndexEntryImpl
	 * <em>Index Entry</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.IndexEntryImpl
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getIndexEntry()
	 * @generated
	 */
	int INDEX_ENTRY = 3;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INDEX_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INDEX_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Index Entry</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INDEX_ENTRY_FEATURE_COUNT = 2;

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap
	 * <em>Two Dimensional EMF Map</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Two Dimensional EMF Map</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap
	 * @generated
	 */
	EClass getTwoDimensionalEMFMap();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getRows
	 * <em>Rows</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '<em>Rows</em>
	 *         '.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getRows()
	 * @see #getTwoDimensionalEMFMap()
	 * @generated
	 */
	EReference getTwoDimensionalEMFMap_Rows();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getColumns
	 * <em>Columns</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Columns</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getColumns()
	 * @see #getTwoDimensionalEMFMap()
	 * @generated
	 */
	EReference getTwoDimensionalEMFMap_Columns();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getData
	 * <em>Data</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '<em>Data</em>
	 *         '.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getData()
	 * @see #getTwoDimensionalEMFMap()
	 * @generated
	 */
	EReference getTwoDimensionalEMFMap_Data();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row <em>Row</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Row</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row
	 * @generated
	 */
	EClass getRow();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row#getEntries
	 * <em>Entries</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Entries</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row#getEntries()
	 * @see #getRow()
	 * @generated
	 */
	EReference getRow_Entries();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry
	 * <em>Row Entry</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Row Entry</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry
	 * @generated
	 */
	EClass getRowEntry();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry#getValue
	 * <em>Value</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry#getValue()
	 * @see #getRowEntry()
	 * @generated
	 */
	EReference getRowEntry_Value();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry
	 * <em>Index Entry</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Index Entry</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry
	 * @generated
	 */
	EClass getIndexEntry();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry#getKey
	 * <em>Key</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry#getKey()
	 * @see #getIndexEntry()
	 * @generated
	 */
	EAttribute getIndexEntry_Key();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry#getValue
	 * <em>Value</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry#getValue()
	 * @see #getIndexEntry()
	 * @generated
	 */
	EAttribute getIndexEntry_Value();

	/**
	 * Returns the meta object for class '
	 * {@link com.bitctrl.util.ITwoDimensionalMap <em>ITwo Dimensional Map</em>}
	 * '. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>ITwo Dimensional Map</em>'.
	 * @see com.bitctrl.util.ITwoDimensionalMap
	 * @model instanceClass="com.bitctrl.util.ITwoDimensionalMap"
	 *        typeParameters="R C D"
	 * @generated
	 */
	EClass getITwoDimensionalMap();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TwoDimMapFactory getTwoDimMapFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl
		 * <em>Two Dimensional EMF Map</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getTwoDimensionalEMFMap()
		 * @generated
		 */
		EClass TWO_DIMENSIONAL_EMF_MAP = eINSTANCE.getTwoDimensionalEMFMap();

		/**
		 * The meta object literal for the '<em><b>Rows</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference TWO_DIMENSIONAL_EMF_MAP__ROWS = eINSTANCE
				.getTwoDimensionalEMFMap_Rows();

		/**
		 * The meta object literal for the '<em><b>Columns</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference TWO_DIMENSIONAL_EMF_MAP__COLUMNS = eINSTANCE
				.getTwoDimensionalEMFMap_Columns();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference TWO_DIMENSIONAL_EMF_MAP__DATA = eINSTANCE
				.getTwoDimensionalEMFMap_Data();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowImpl
		 * <em>Row</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getRow()
		 * @generated
		 */
		EClass ROW = eINSTANCE.getRow();

		/**
		 * The meta object literal for the '<em><b>Entries</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference ROW__ENTRIES = eINSTANCE.getRow_Entries();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowEntryImpl
		 * <em>Row Entry</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.RowEntryImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getRowEntry()
		 * @generated
		 */
		EClass ROW_ENTRY = eINSTANCE.getRowEntry();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference ROW_ENTRY__VALUE = eINSTANCE.getRowEntry_Value();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.IndexEntryImpl
		 * <em>Index Entry</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.IndexEntryImpl
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getIndexEntry()
		 * @generated
		 */
		EClass INDEX_ENTRY = eINSTANCE.getIndexEntry();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute INDEX_ENTRY__KEY = eINSTANCE.getIndexEntry_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute INDEX_ENTRY__VALUE = eINSTANCE.getIndexEntry_Value();

		/**
		 * The meta object literal for the '
		 * {@link com.bitctrl.util.ITwoDimensionalMap
		 * <em>ITwo Dimensional Map</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see com.bitctrl.util.ITwoDimensionalMap
		 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimMapPackageImpl#getITwoDimensionalMap()
		 * @generated
		 */
		EClass ITWO_DIMENSIONAL_MAP = eINSTANCE.getITwoDimensionalMap();

	}

} // TwoDimMapPackage
