/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import com.bitctrl.util.ITwoDimensionalMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Two Dimensional EMF Map</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getRows
 * <em>Rows</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getColumns
 * <em>Columns</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap#getData
 * <em>Data</em>}</li>
 * </ul>
 * </p>
 * 
 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage#getTwoDimensionalEMFMap()
 * @model superTypes=
 *        "de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.ITwoDimensionalMap<R, C, D>"
 * @generated
 */
public interface TwoDimensionalEMFMap<R, C, D> extends EObject,
		ITwoDimensionalMap<R, C, D> {
	/**
	 * Returns the value of the '<em><b>Rows</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry}&lt;R>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Rows</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Rows</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage#getTwoDimensionalEMFMap_Rows()
	 * @model containment="true" keys="key"
	 * @generated
	 */
	EList<IndexEntry<R>> getRows();

	/**
	 * Returns the value of the '<em><b>Columns</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry}&lt;C>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Columns</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Columns</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage#getTwoDimensionalEMFMap_Columns()
	 * @model containment="true" keys="key"
	 * @generated
	 */
	EList<IndexEntry<C>> getColumns();

	/**
	 * Returns the value of the '<em><b>Data</b></em>' containment reference
	 * list. The list contents are of type
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row}&lt;D>. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Data</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Data</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage#getTwoDimensionalEMFMap_Data()
	 * @model containment="true"
	 * @generated
	 */
	EList<Row<D>> getData();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='EList<IndexEntry<C>> columns = getColumns();\r\n\t\tInteger cIndex = findValue(columns, column);\r\n\t\tif (null == cIndex) {\r\n\t\t\tgetColumnInternal(column);\r\n\t\t\tcIndex = findValue(columns, column);\r\n\t\t}\r\n\t\tEList<IndexEntry<R>> rows = getRows();\r\n\t\tInteger rIndex = findValue(rows, row);\r\n\t\tif (null == rIndex) {\r\n\t\t\tgetRowInternal(row);\r\n\t\t\trIndex = findValue(rows, row);\r\n\t\t}\r\n\t\treturn this.data.get(rIndex).getEntries().get(cIndex).getValue();'"
	 * @generated
	 */
	D get(R row, C column);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='EList<IndexEntry<C>> columns = getColumns();\r\n\t\tInteger cIndex = findValue(columns, column);\r\n\t\tif (null == cIndex) {\r\n\t\t\tgetColumnInternal(column);\r\n\t\t\tcIndex = findValue(columns, column);\r\n\t\t}\r\n\t\tEList<IndexEntry<R>> rows = getRows();\r\n\t\tInteger rIndex = findValue(rows, row);\r\n\t\tif (null == rIndex) {\r\n\t\t\tgetRowInternal(row);\r\n\t\t\trIndex = findValue(rows, row);\r\n\t\t}\r\n\t\tRowEntry<D> d=TwoDimMapFactory.eINSTANCE.createRowEntry();\r\n\t\td.setValue(value);\r\n\t\treturn getData().get(rIndex).getEntries().set(cIndex, d).getValue();'"
	 * @generated
	 */
	D put(R row, C column, D value);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model indexMany="true" annotation="http://www.eclipse.org/emf/2002/GenModel body='for (final IndexEntry<K> indexEntry : index) {\r\n\t\t\tif (indexEntry.getKey().equals(key)) {\r\n\t\t\t\treturn indexEntry.getValue();\r\n\t\t\t}\r\n\t\t}\r\n\t\tthrow new NoSuchElementException();'"
	 * @generated
	 */
	<K> Integer findValue(EList<IndexEntry<K>> index, K key);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model indexMany="true" annotation="http://www.eclipse.org/emf/2002/GenModel body='EList<K> ret = new BasicEList<K>(index.size());\r\n\t\tfor (IndexEntry<K> indexEntry : index) {\r\n\t\t\tret.add(indexEntry.getKey());\r\n\t\t}\r\n\t\treturn ECollections.unmodifiableEList(ret);'"
	 * @generated
	 */
	<K> EList<K> getAllKeys(EList<IndexEntry<K>> index);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model kind="operation" annotation="http://www.eclipse.org/emf/2002/GenModel body='return getAllKeys(getColumns());'"
	 * @generated
	 */
	EList<C> getColumnKeys();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model kind="operation" annotation=
	 *        "http://www.eclipse.org/emf/2002/GenModel body='return getAllKeys(getRows());'"
	 * @generated
	 */
	EList<R> getRowKeys();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='try {\r\n\t\t\tfindValue(getColumns(), column);\r\n\t\t} catch (final NoSuchElementException e) {\r\n\t\t\tfinal IndexEntry<C> ie = TwoDimMapFactory.eINSTANCE\r\n\t\t\t\t\t.createIndexEntry();\r\n\t\t\tie.setKey(column);\r\n\t\t\tie.setValue(columns.size());\r\n\t\t\tcolumns.add(ie);\r\n\t\t\tfor (final Row<D> rowsData : getData()) {\r\n\t\t\t\trowsData.getEntries().add(null);\r\n\t\t\t}\r\n\t\t}\r\n'"
	 * @generated
	 */
	void addColumn(C column);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='final Integer cIndex = findValue(getColumns(), column);\r\n\t\tfinal EList<D> cData = new BasicEList<D>(getRows().size());\r\n\t\tfor (final Row<D> rowsData : getData()) {\r\n\t\t\tcData.add(rowsData.getEntries().get(cIndex).getValue());\r\n\t\t}\r\n\t\treturn cData;\r\n'"
	 * @generated
	 */
	EList<D> getColumnInternal(C column);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='return ECollections.unmodifiableEList(getColumnInternal(column));'"
	 * @generated
	 */
	EList<D> getColumn(C column);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='try {\r\n\t\t\tfindValue(getRows(), row);\r\n\t\t} catch (final NoSuchElementException e) {\r\n\t\t\tfinal IndexEntry<R> ie = TwoDimMapFactory.eINSTANCE\r\n\t\t\t\t\t.createIndexEntry();\r\n\t\t\tie.setKey(row);\r\n\t\t\tie.setValue(rows.size());\r\n\t\t\trows.add(ie);\r\n\t\t\tfinal Row<D> r = TwoDimMapFactory.eINSTANCE.createRow();\r\n\t\t\tfinal EList<RowEntry<D>> entries = r.getEntries();\r\n\t\t\tfor (@SuppressWarnings(\"unused\")\r\n\t\t\tfinal IndexEntry<C> d : getColumns()) {\r\n\t\t\t\tfinal RowEntry<D> re = TwoDimMapFactory.eINSTANCE\r\n\t\t\t\t\t\t.createRowEntry();\r\n\t\t\t\tre.setValue(null);\r\n\t\t\t\tentries.add(re);\r\n\t\t\t}\r\n\t\t\tgetData().add(r);\r\n\t\t}'"
	 * @generated
	 */
	void addRow(R row);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='final Integer rIndex = findValue(getRows(), row);\r\n\t\tfinal EList<D> rData = new BasicEList<D>(getColumns().size());\r\n\t\tfinal EList<RowEntry<D>> r = getData().get(rIndex).getEntries();\r\n\t\tfor (final IndexEntry<C> ie : columns) {\r\n\t\t\trData.add(r.get(ie.getValue()).getValue());\r\n\t\t}\r\n\t\treturn rData;'"
	 * @generated
	 */
	EList<D> getRowInternal(R row);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='return ECollections.unmodifiableEList(getRowInternal(row));'"
	 * @generated
	 */
	EList<D> getRow(R row);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='final Integer rIndex = findValue(getRows(), row);\r\n\t\tfinal EList<D> rData = new BasicEList<D>(getColumns().size());\r\n\t\tfinal EList<RowEntry<D>> r = getData().get(rIndex).getEntries();\r\n\t\tfor (final IndexEntry<C> ie : columns) {\r\n\t\t\trData.add(r.get(ie.getValue()).getValue());\r\n\t\t}\r\n\t\tgetData().remove((int) rIndex);\r\n\t\tgetRows().remove((int) rIndex);\r\n\t\tfor (final IndexEntry<R> e : getRows()) {\r\n\t\t\tfinal Integer v = e.getValue();\r\n\t\t\tif (v > rIndex) {\r\n\t\t\t\te.setValue(v - 1);\r\n\t\t\t}\r\n\t\t}\r\n\t\treturn ECollections.unmodifiableEList(rData);'"
	 * @generated
	 */
	EList<D> removeRow(R row);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='final EList<D> values = new BasicEList<D>(getRows().size()\r\n\t\t\t\t* getColumns().size());\r\n\t\tfor (final Row<D> ld : getData()) {\r\n\t\t\tEList<RowEntry<D>> entries = ld.getEntries();\r\n\t\t\tfor (RowEntry<D> rowEntry : entries) {\r\n\t\t\t\tvalues.add(rowEntry.getValue());\r\n\t\t\t}\r\n\t\t}\r\n\t\treturn ECollections.unmodifiableEList(values);'"
	 * @generated
	 */
	EList<D> values();

} // TwoDimensionalEMFMap
