/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.util.ITwoDimensionalMap;

import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapFactory;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class TwoDimMapPackageImpl extends EPackageImpl implements
		TwoDimMapPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass twoDimensionalEMFMapEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rowEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rowEntryEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass indexEntryEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass iTwoDimensionalMapEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private TwoDimMapPackageImpl() {
		super(eNS_URI, TwoDimMapFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link TwoDimMapPackage#eINSTANCE} when
	 * that field is accessed. Clients should not invoke it directly. Instead,
	 * they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static TwoDimMapPackage init() {
		if (isInited) {
			return (TwoDimMapPackage) EPackage.Registry.INSTANCE
					.getEPackage(TwoDimMapPackage.eNS_URI);
		}

		// Obtain or create and register package
		final TwoDimMapPackageImpl theTwoDimMapPackage = (TwoDimMapPackageImpl) (EPackage.Registry.INSTANCE
				.get(eNS_URI) instanceof TwoDimMapPackageImpl ? EPackage.Registry.INSTANCE
				.get(eNS_URI)
				: new TwoDimMapPackageImpl());

		isInited = true;

		// Create package meta-data objects
		theTwoDimMapPackage.createPackageContents();

		// Initialize created meta-data
		theTwoDimMapPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTwoDimMapPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(TwoDimMapPackage.eNS_URI,
				theTwoDimMapPackage);
		return theTwoDimMapPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getTwoDimensionalEMFMap() {
		return twoDimensionalEMFMapEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getTwoDimensionalEMFMap_Rows() {
		return (EReference) twoDimensionalEMFMapEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getTwoDimensionalEMFMap_Columns() {
		return (EReference) twoDimensionalEMFMapEClass.getEStructuralFeatures()
				.get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getTwoDimensionalEMFMap_Data() {
		return (EReference) twoDimensionalEMFMapEClass.getEStructuralFeatures()
				.get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getRow() {
		return rowEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getRow_Entries() {
		return (EReference) rowEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getRowEntry() {
		return rowEntryEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EReference getRowEntry_Value() {
		return (EReference) rowEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getIndexEntry() {
		return indexEntryEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getIndexEntry_Key() {
		return (EAttribute) indexEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EAttribute getIndexEntry_Value() {
		return (EAttribute) indexEntryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EClass getITwoDimensionalMap() {
		return iTwoDimensionalMapEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TwoDimMapFactory getTwoDimMapFactory() {
		return (TwoDimMapFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		twoDimensionalEMFMapEClass = createEClass(TWO_DIMENSIONAL_EMF_MAP);
		createEReference(twoDimensionalEMFMapEClass,
				TWO_DIMENSIONAL_EMF_MAP__ROWS);
		createEReference(twoDimensionalEMFMapEClass,
				TWO_DIMENSIONAL_EMF_MAP__COLUMNS);
		createEReference(twoDimensionalEMFMapEClass,
				TWO_DIMENSIONAL_EMF_MAP__DATA);

		rowEClass = createEClass(ROW);
		createEReference(rowEClass, ROW__ENTRIES);

		rowEntryEClass = createEClass(ROW_ENTRY);
		createEReference(rowEntryEClass, ROW_ENTRY__VALUE);

		indexEntryEClass = createEClass(INDEX_ENTRY);
		createEAttribute(indexEntryEClass, INDEX_ENTRY__KEY);
		createEAttribute(indexEntryEClass, INDEX_ENTRY__VALUE);

		iTwoDimensionalMapEClass = createEClass(ITWO_DIMENSIONAL_MAP);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters
		final ETypeParameter twoDimensionalEMFMapEClass_R = addETypeParameter(
				twoDimensionalEMFMapEClass, "R");
		final ETypeParameter twoDimensionalEMFMapEClass_C = addETypeParameter(
				twoDimensionalEMFMapEClass, "C");
		final ETypeParameter twoDimensionalEMFMapEClass_D = addETypeParameter(
				twoDimensionalEMFMapEClass, "D");
		final ETypeParameter rowEClass_D = addETypeParameter(rowEClass, "D");
		final ETypeParameter rowEntryEClass_D = addETypeParameter(
				rowEntryEClass, "D");
		final ETypeParameter indexEntryEClass_K = addETypeParameter(
				indexEntryEClass, "K");
		addETypeParameter(iTwoDimensionalMapEClass, "R");
		addETypeParameter(iTwoDimensionalMapEClass, "C");
		addETypeParameter(iTwoDimensionalMapEClass, "D");

		// Set bounds for type parameters

		// Add supertypes to classes
		EGenericType g1 = createEGenericType(getITwoDimensionalMap());
		EGenericType g2 = createEGenericType(twoDimensionalEMFMapEClass_R);
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(twoDimensionalEMFMapEClass_C);
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(twoDimensionalEMFMapEClass_D);
		g1.getETypeArguments().add(g2);
		twoDimensionalEMFMapEClass.getEGenericSuperTypes().add(g1);

		// Initialize classes and features; add operations and parameters
		initEClass(twoDimensionalEMFMapEClass, TwoDimensionalEMFMap.class,
				"TwoDimensionalEMFMap", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		g1 = createEGenericType(getIndexEntry());
		g2 = createEGenericType(twoDimensionalEMFMapEClass_R);
		g1.getETypeArguments().add(g2);
		initEReference(getTwoDimensionalEMFMap_Rows(), g1, null, "rows", null,
				0, -1, TwoDimensionalEMFMap.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		getTwoDimensionalEMFMap_Rows().getEKeys().add(getIndexEntry_Key());
		g1 = createEGenericType(getIndexEntry());
		g2 = createEGenericType(twoDimensionalEMFMapEClass_C);
		g1.getETypeArguments().add(g2);
		initEReference(getTwoDimensionalEMFMap_Columns(), g1, null, "columns",
				null, 0, -1, TwoDimensionalEMFMap.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		getTwoDimensionalEMFMap_Columns().getEKeys().add(getIndexEntry_Key());
		g1 = createEGenericType(getRow());
		g2 = createEGenericType(twoDimensionalEMFMapEClass_D);
		g1.getETypeArguments().add(g2);
		initEReference(getTwoDimensionalEMFMap_Data(), g1, null, "data", null,
				0, -1, TwoDimensionalEMFMap.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		EOperation op = addEOperation(twoDimensionalEMFMapEClass, null, "get",
				0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		addEParameter(op, g1, "row", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_C);
		addEParameter(op, g1, "column", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "put", 0, 1,
				IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		addEParameter(op, g1, "row", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_C);
		addEParameter(op, g1, "column", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		addEParameter(op, g1, "value", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, ecorePackage
				.getEIntegerObject(), "findValue", 0, 1, IS_UNIQUE, IS_ORDERED);
		ETypeParameter t1 = addETypeParameter(op, "K");
		g1 = createEGenericType(getIndexEntry());
		g2 = createEGenericType(t1);
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "index", 0, -1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(t1);
		addEParameter(op, g1, "key", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "getAllKeys", 0,
				-1, IS_UNIQUE, IS_ORDERED);
		t1 = addETypeParameter(op, "K");
		g1 = createEGenericType(getIndexEntry());
		g2 = createEGenericType(t1);
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "index", 0, -1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(t1);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "getColumnKeys",
				0, -1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_C);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "getRowKeys", 0,
				-1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "addColumn", 0, 1,
				IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_C);
		addEParameter(op, g1, "column", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(twoDimensionalEMFMapEClass, null,
				"getColumnInternal", 0, -1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_C);
		addEParameter(op, g1, "column", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "getColumn", 0,
				-1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_C);
		addEParameter(op, g1, "column", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "addRow", 0, 1,
				IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		addEParameter(op, g1, "row", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "getRowInternal",
				0, -1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		addEParameter(op, g1, "row", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "getRow", 0, -1,
				IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		addEParameter(op, g1, "row", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "removeRow", 0,
				-1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_R);
		addEParameter(op, g1, "row", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		op = addEOperation(twoDimensionalEMFMapEClass, null, "values", 0, -1,
				IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(twoDimensionalEMFMapEClass_D);
		initEOperation(op, g1);

		initEClass(rowEClass, Row.class, "Row", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		g1 = createEGenericType(getRowEntry());
		g2 = createEGenericType(rowEClass_D);
		g1.getETypeArguments().add(g2);
		initEReference(getRow_Entries(), g1, null, "entries", null, 0, -1,
				Row.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(rowEntryEClass, RowEntry.class, "RowEntry", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		g1 = createEGenericType(rowEntryEClass_D);
		initEReference(getRowEntry_Value(), g1, null, "value", null, 0, 1,
				RowEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(indexEntryEClass, IndexEntry.class, "IndexEntry",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		g1 = createEGenericType(indexEntryEClass_K);
		initEAttribute(getIndexEntry_Key(), g1, "key", null, 0, 1,
				IndexEntry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getIndexEntry_Value(), ecorePackage.getEIntegerObject(),
				"value", null, 0, 1, IndexEntry.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(iTwoDimensionalMapEClass, ITwoDimensionalMap.class,
				"ITwoDimensionalMap", IS_ABSTRACT, IS_INTERFACE,
				!IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} // TwoDimMapPackageImpl
