/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl;

import java.util.Collection;
import java.util.NoSuchElementException;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapFactory;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Two Dimensional EMF Map</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl#getRows
 * <em>Rows</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl#getColumns
 * <em>Columns</em>}</li>
 * <li>
 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.impl.TwoDimensionalEMFMapImpl#getData
 * <em>Data</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class TwoDimensionalEMFMapImpl<R, C, D> extends EObjectImpl implements
		TwoDimensionalEMFMap<R, C, D> {
	/**
	 * The cached value of the '{@link #getRows() <em>Rows</em>}' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getRows()
	 * @generated
	 * @ordered
	 */
	protected EList<IndexEntry<R>> rows;

	/**
	 * The cached value of the '{@link #getColumns() <em>Columns</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getColumns()
	 * @generated
	 * @ordered
	 */
	protected EList<IndexEntry<C>> columns;

	/**
	 * The cached value of the '{@link #getData() <em>Data</em>}' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getData()
	 * @generated
	 * @ordered
	 */
	protected EList<Row<D>> data;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TwoDimensionalEMFMapImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TwoDimMapPackage.Literals.TWO_DIMENSIONAL_EMF_MAP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<IndexEntry<R>> getRows() {
		if (rows == null) {
			rows = new EObjectContainmentEList<IndexEntry<R>>(IndexEntry.class,
					this, TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__ROWS);
		}
		return rows;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<IndexEntry<C>> getColumns() {
		if (columns == null) {
			columns = new EObjectContainmentEList<IndexEntry<C>>(
					IndexEntry.class, this,
					TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__COLUMNS);
		}
		return columns;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Row<D>> getData() {
		if (data == null) {
			data = new EObjectContainmentEList<Row<D>>(Row.class, this,
					TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__DATA);
		}
		return data;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public D get(final R row, final C column) {
		final EList<IndexEntry<C>> columns = getColumns();
		Integer cIndex = findValue(columns, column);
		if (null == cIndex) {
			getColumnInternal(column);
			cIndex = findValue(columns, column);
		}
		final EList<IndexEntry<R>> rows = getRows();
		Integer rIndex = findValue(rows, row);
		if (null == rIndex) {
			getRowInternal(row);
			rIndex = findValue(rows, row);
		}
		return this.data.get(rIndex).getEntries().get(cIndex).getValue();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public D put(final R row, final C column, final D value) {
		final EList<IndexEntry<C>> columns = getColumns();
		Integer cIndex = findValue(columns, column);
		if (null == cIndex) {
			getColumnInternal(column);
			cIndex = findValue(columns, column);
		}
		final EList<IndexEntry<R>> rows = getRows();
		Integer rIndex = findValue(rows, row);
		if (null == rIndex) {
			getRowInternal(row);
			rIndex = findValue(rows, row);
		}
		final RowEntry<D> d = TwoDimMapFactory.eINSTANCE.createRowEntry();
		d.setValue(value);
		return getData().get(rIndex).getEntries().set(cIndex, d).getValue();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public <K> Integer findValue(final EList<IndexEntry<K>> index, final K key) {
		for (final IndexEntry<K> indexEntry : index) {
			if (indexEntry.getKey().equals(key)) {
				return indexEntry.getValue();
			}
		}
		throw new NoSuchElementException();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public <K> EList<K> getAllKeys(final EList<IndexEntry<K>> index) {
		final EList<K> ret = new BasicEList<K>(index.size());
		for (final IndexEntry<K> indexEntry : index) {
			ret.add(indexEntry.getKey());
		}
		return ECollections.unmodifiableEList(ret);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<C> getColumnKeys() {
		return getAllKeys(getColumns());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<R> getRowKeys() {
		return getAllKeys(getRows());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<D> getColumnInternal(final C column) {
		final Integer cIndex = findValue(getColumns(), column);
		final EList<D> cData = new BasicEList<D>(getRows().size());
		for (final Row<D> rowsData : getData()) {
			cData.add(rowsData.getEntries().get(cIndex).getValue());
		}
		return cData;

	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addColumn(final C column) {
		try {
			findValue(getColumns(), column);
		} catch (final NoSuchElementException e) {
			final IndexEntry<C> ie = TwoDimMapFactory.eINSTANCE
					.createIndexEntry();
			ie.setKey(column);
			ie.setValue(columns.size());
			columns.add(ie);
			for (final Row<D> rowsData : getData()) {
				rowsData.getEntries().add(null);
			}
		}

	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<D> getColumn(final C column) {
		return ECollections.unmodifiableEList(getColumnInternal(column));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<D> getRowInternal(final R row) {
		final Integer rIndex = findValue(getRows(), row);
		final EList<D> rData = new BasicEList<D>(getColumns().size());
		final EList<RowEntry<D>> r = getData().get(rIndex).getEntries();
		for (final IndexEntry<C> ie : columns) {
			rData.add(r.get(ie.getValue()).getValue());
		}
		return rData;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addRow(final R row) {
		try {
			findValue(getRows(), row);
		} catch (final NoSuchElementException e) {
			final IndexEntry<R> ie = TwoDimMapFactory.eINSTANCE
					.createIndexEntry();
			ie.setKey(row);
			ie.setValue(rows.size());
			rows.add(ie);
			final Row<D> r = TwoDimMapFactory.eINSTANCE.createRow();
			final EList<RowEntry<D>> entries = r.getEntries();

			for (int idx = 0; idx < getColumns().size(); idx++) {
				final RowEntry<D> re = TwoDimMapFactory.eINSTANCE
						.createRowEntry();
				re.setValue(null);
				entries.add(re);
			}
			getData().add(r);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<D> getRow(final R row) {
		return ECollections.unmodifiableEList(getRowInternal(row));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<D> removeRow(final R row) {
		final Integer rIndex = findValue(getRows(), row);
		final EList<D> rData = new BasicEList<D>(getColumns().size());
		final EList<RowEntry<D>> r = getData().get(rIndex).getEntries();
		for (final IndexEntry<C> ie : columns) {
			rData.add(r.get(ie.getValue()).getValue());
		}
		getData().remove((int) rIndex);
		getRows().remove((int) rIndex);
		for (final IndexEntry<R> e : getRows()) {
			final Integer v = e.getValue();
			if (v > rIndex) {
				e.setValue(v - 1);
			}
		}
		return ECollections.unmodifiableEList(rData);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<D> values() {
		final EList<D> values = new BasicEList<D>(getRows().size()
				* getColumns().size());
		for (final Row<D> ld : getData()) {
			final EList<RowEntry<D>> entries = ld.getEntries();
			for (final RowEntry<D> rowEntry : entries) {
				values.add(rowEntry.getValue());
			}
		}
		return ECollections.unmodifiableEList(values);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(final InternalEObject otherEnd,
			final int featureID, final NotificationChain msgs) {
		switch (featureID) {
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__ROWS:
			return ((InternalEList<?>) getRows()).basicRemove(otherEnd, msgs);
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__COLUMNS:
			return ((InternalEList<?>) getColumns())
					.basicRemove(otherEnd, msgs);
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__DATA:
			return ((InternalEList<?>) getData()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(final int featureID, final boolean resolve,
			final boolean coreType) {
		switch (featureID) {
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__ROWS:
			return getRows();
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__COLUMNS:
			return getColumns();
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__DATA:
			return getData();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(final int featureID, final Object newValue) {
		switch (featureID) {
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__ROWS:
			getRows().clear();
			getRows().addAll((Collection<? extends IndexEntry<R>>) newValue);
			return;
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__COLUMNS:
			getColumns().clear();
			getColumns().addAll((Collection<? extends IndexEntry<C>>) newValue);
			return;
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__DATA:
			getData().clear();
			getData().addAll((Collection<? extends Row<D>>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(final int featureID) {
		switch (featureID) {
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__ROWS:
			getRows().clear();
			return;
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__COLUMNS:
			getColumns().clear();
			return;
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__DATA:
			getData().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(final int featureID) {
		switch (featureID) {
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__ROWS:
			return rows != null && !rows.isEmpty();
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__COLUMNS:
			return columns != null && !columns.isEmpty();
		case TwoDimMapPackage.TWO_DIMENSIONAL_EMF_MAP__DATA:
			return data != null && !data.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} // TwoDimensionalEMFMapImpl
