/**
 * Rahmenwerk-Plug-in "Gangliniendarstellung fuer PuA-Protokolle"
 * Copyright (C) 2009 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import com.bitctrl.util.ITwoDimensionalMap;

import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage;
import de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimMapPackage
 * @generated
 */
public class TwoDimMapAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static TwoDimMapPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public TwoDimMapAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = TwoDimMapPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * 
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TwoDimMapSwitch<Adapter> modelSwitch = new TwoDimMapSwitch<Adapter>() {
		@Override
		public <R, C, D> Adapter caseTwoDimensionalEMFMap(
				TwoDimensionalEMFMap<R, C, D> object) {
			return createTwoDimensionalEMFMapAdapter();
		}

		@Override
		public <D> Adapter caseRow(Row<D> object) {
			return createRowAdapter();
		}

		@Override
		public <D> Adapter caseRowEntry(RowEntry<D> object) {
			return createRowEntryAdapter();
		}

		@Override
		public <K> Adapter caseIndexEntry(IndexEntry<K> object) {
			return createIndexEntryAdapter();
		}

		@Override
		public <R, C, D> Adapter caseITwoDimensionalMap(
				ITwoDimensionalMap<R, C, D> object) {
			return createITwoDimensionalMapAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param target
	 *            the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap
	 * <em>Two Dimensional EMF Map</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.TwoDimensionalEMFMap
	 * @generated
	 */
	public Adapter createTwoDimensionalEMFMapAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row <em>Row</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.Row
	 * @generated
	 */
	public Adapter createRowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry
	 * <em>Row Entry</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.RowEntry
	 * @generated
	 */
	public Adapter createRowEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry
	 * <em>Index Entry</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.pua.ganglinien.twoDimMap.IndexEntry
	 * @generated
	 */
	public Adapter createIndexEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link com.bitctrl.util.ITwoDimensionalMap <em>ITwo Dimensional Map</em>}
	 * '. <!-- begin-user-doc --> This default implementation returns null so
	 * that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see com.bitctrl.util.ITwoDimensionalMap
	 * @generated
	 */
	public Adapter createITwoDimensionalMapAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case. <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // TwoDimMapAdapterFactory
