/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

/**
 * Syntax-Scanner-Konfiguration.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaPartitionScanner extends RuleBasedPartitionScanner {
	/** Zeichenketten-Abschnitt. */
	public static final String STRING = "__uda_string";

	/** Kommentar-Abschnitt. */
	public static final String COMMENT = "__uda_comment";

	/** Zeichenketten-Abschnitt. */
	public static final String KEYWORD = "__uda_keyword";

	/**
	 * die definierten Partitionstypen.
	 */
	static final String[] PARTITION_TYPES = new String[] { IDocument.DEFAULT_CONTENT_TYPE,
			UdaPartitionScanner.STRING, UdaPartitionScanner.COMMENT };

	/**
	 * Standardkonstruktor.
	 */
	public UdaPartitionScanner() {
		final IToken string = new Token(UdaPartitionScanner.STRING);
		final IToken comment = new Token(UdaPartitionScanner.COMMENT);

		final List<IPredicateRule> rules = new ArrayList<>();

		rules.add(new SingleLineRule("\"", "\"", string, '\\'));
		rules.add(new MultiLineRule("/*", "*/", comment));
		rules.add(new EndOfLineRule("#", comment));

		setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
	}
}
