/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.editor;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

/**
 * Versorgt den Editor mit den Attributen für die Textdarstellung.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class UdaStyleProvider {

	/**
	 * Syntax-Highlighting Spezifikation von Schluesselworten.
	 */
	private final IToken keyWordToken = new Token(
			new TextAttribute(Display.getDefault().getSystemColor(SWT.COLOR_DARK_MAGENTA), null, SWT.BOLD));

	/**
	 * Syntax-Highlighting Spezifikation von Strings.
	 */
	private final IToken stringToken = new Token(
			new TextAttribute(Display.getDefault().getSystemColor(SWT.COLOR_BLUE), null, SWT.ITALIC));

	/**
	 * Syntax-Highlighting Spezifikation vom Kommentaren.
	 */
	private final IToken commentToken = new Token(
			new TextAttribute(Display.getDefault().getSystemColor(SWT.COLOR_GRAY), null, SWT.ITALIC));

	/**
	 * Rest.
	 */
	private final IToken defaultToken = new Token(
			new TextAttribute(Display.getDefault().getSystemColor(SWT.COLOR_BLACK)));

	/**
	 * Liefert die Textattribute für einen Textbereich.
	 *
	 * @param keyword
	 *            der Name des Bereiches.
	 * @return die Attribute.
	 */
	public IToken getToken(final String keyword) {
		IToken result = defaultToken;
		if (UdaPartitionScanner.KEYWORD.equals(keyword)) {
			result = keyWordToken;
		} else if (UdaPartitionScanner.STRING.equals(keyword)) {
			result = stringToken;
		} else if (UdaPartitionScanner.COMMENT.equals(keyword)) {
			result = commentToken;
		}
		return result;
	}

}
