/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.uda.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.uda.views.LaufLogSicht;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;
import de.bsvrz.ibv.uda.verwaltung.protokoll.Protokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.ProtokollTyp;

public class SkriptLaufViewHandler extends UdaHandler {

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		openView(getSkriptLauf(event));
		return null;
	}

	public void openView(final ClientSkriptLauf skriptLauf) {
		if (skriptLauf != null) {

			boolean protokollVerfuegbar = false;
			for (final Protokoll protokoll : skriptLauf.getProtokolle()) {
				if (ProtokollTyp.DAV.equals(protokoll.getTyp())) {
					protokollVerfuegbar = true;
					break;
				}
			}

			if (protokollVerfuegbar) {

				final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
				try {
					final LaufLogSicht view = (LaufLogSicht) page.showView(LaufLogSicht.ID,
							skriptLauf.getDavObjekt().getPid(), IWorkbenchPage.VIEW_ACTIVATE);
					view.setLauf(skriptLauf);
				} catch (final PartInitException e) {
					e.printStackTrace();
				}
			} else {
				// TODO Enablement für Handler erweitern
				MessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
						"Information", "Der ausgewählte Skriptlauf enthält kein Datenverteiler-Protokoll!");
			}
		}
	}
}
