/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.handler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.uda.UdaToolsPlugin;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ParserResult;
import de.bsvrz.ibv.uda.interpreter.UdaParserFehler;

/**
 * Handler für das Kommando zum Parsen und Syntaxcheck eines UDA-Skriptes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class SkriptParsenHandler extends UdaHandler {

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final ClientSkript skript = getSkript(event);

		if (skript != null) {

			try {
				// TODO Encoding betrachten
				final File file = File.createTempFile("skriptparser", ".tmp");
				file.deleteOnExit();

				try (FileWriter writer = new FileWriter(file)) {
					for (final String line : skript.getSourceCode()) {
						writer.write(line);
						writer.write(System.getProperty("line.separator"));
					}
					writer.flush();
				}
				final ParserResult result = UdaToolsPlugin.getDefault().getConnector()
						.parseSkriptText(file.getAbsolutePath());
				if (!file.delete()) {
					MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Fehler",
							"Temporäre Datei " + file.getAbsolutePath() + " konnte nicht gelöscht werden");
				}

				if (result.isParsed()) {
					MessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
							"Prüfung", "Prüfung des Skripts erfolgreich durchgeführt");
				} else {
					final StringBuffer buffer = new StringBuffer();
					buffer.append("Skript enthält Fehler:");
					buffer.append(System.getProperty("line.separator"));
					buffer.append("=======================");
					for (final UdaParserFehler fehler : result.getFehlerListe()) {
						buffer.append(System.getProperty("line.separator"));
						buffer.append(fehler.getLine() + ": " + fehler.getMessage());
					}
					MessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
							"Prüfung", buffer.toString());
				}
			} catch (final IOException e) {
				MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Fehler",
						"Prüfung des Skripts fehlgeschlagen: " + System.getProperty("line.separator") + e.getMessage());
			} catch (final MissingParameterException e) {
				MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Fehler",
						"Prüfung des Skripts fehlgeschlagen: " + System.getProperty("line.separator") + e.getMessage());
			}
		}
		return null;
	}
}
