/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.navigator;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.bsvrz.buv.plugin.uda.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;

/**
 * Content-Provider fuer den UDA-Navigator.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class UdaModulNavigatorContentProvider implements ITreeContentProvider {

	/** der Navigator. */
	private final UdaModulNavigator navigator;

	/**
	 * Standardkonstruktor.
	 *
	 * @param navigator
	 *            der UDA-Modul-Navigator.
	 */
	public UdaModulNavigatorContentProvider(final UdaModulNavigator navigator) {
		this.navigator = navigator;
	}

	@Override
	public void dispose() {
		//
	}

	@Override
	public Object[] getChildren(final Object element) {
		return getElements(element);
	}

	@Override
	public Object[] getElements(final Object parent) {
		final Collection<Object> elemente = new ArrayList<>();

		final ClientDavInterface daVVerbindung = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();

		if (parent instanceof UdaModulNavigator) {
			if (daVVerbindung == null) {
				elemente.add("Keine Datenverteierverbindung");
			} else if (daVVerbindung.getClientDavParameters().getSimulationVariant() != 0) {
				elemente.add("Simulationsvariante ist nicht 0");
			} else {
				for (final ClientModul object : ((UdaModulNavigator) parent).getConnector().getModule()) {
					elemente.add(object);
				}
			}
		} else if (parent instanceof ClientModul) {
			final ClientModul udaModul = (ClientModul) parent;
			if (udaModul.isValid()) {
				for (final ClientSkript skript : udaModul.getSkripts()) {
					elemente.add(skript);
				}
			}
			for (final ClientSkriptLauf lauf : udaModul.getSkriptLaeufe()) {
				if (lauf.getSkript() == null) {
					elemente.add(lauf);
				}
			}
		} else if (parent instanceof ClientSkript) {
			for (final ClientSkriptLauf lauf : ((ClientSkript) parent).getModul().getSkriptLaeufe()) {
				if (((ClientSkript) parent).equals(lauf.getSkript())) {
					elemente.add(lauf);
				}
			}
		}

		return elemente.toArray();
	}

	@Override
	public Object getParent(final Object element) {
		Object result = null;
		if (element instanceof ClientModul) {
			result = navigator;
		} else if (element instanceof ClientSkript) {
			result = ((ClientSkript) element).getModul();
		} else if (element instanceof ClientSkriptLauf) {
			final ClientSkriptLauf lauf = (ClientSkriptLauf) element;
			if (lauf.getSkript() == null) {
				result = lauf.getModul();
			} else {
				result = lauf.getSkript();
			}
		}
		return result;
	}

	@Override
	public boolean hasChildren(final Object element) {
		return getElements(element).length > 0;
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		//
	}
}
