/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.navigator;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.ibv.uda.client.ClientModul;
import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;

/**
 * Labelprovider fuer UDA-Module.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class UdaModulNavigatorLabelProvider extends LabelProvider {

	@Override
	public Image getImage(final Object element) {
		Image result = null;
		if (element instanceof ClientModul) {
			result = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);
		} else if (element instanceof ClientSkript) {
			result = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FILE);
		} else if (element instanceof ClientSkriptLauf) {
			result = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_ELEMENT);
		} else {
			result = super.getImage(element);
		}

		return result;
	}

	@Override
	public String getText(final Object element) {
		String result = null;
		if (element instanceof ClientModul) {
			result = ((ClientModul) element).getModulObjekt().getNameOrPidOrId();
			if (!((ClientModul) element).isValid()) {
				result = result + " -->ungültig";
			}
		} else if (element instanceof ClientSkript) {
			final ClientSkript skript = (ClientSkript) element;
			result = skript.getName();
			if (!skript.isValid()) {
				result = result + " -->ungültig";
			}
		} else if (element instanceof ClientSkriptLauf) {
			final ClientSkriptLauf lauf = (ClientSkriptLauf) element;
			result = lauf.getName();
			if (!lauf.isValid()) {
				result = result + " -->ungültig";
			}
		} else {
			return super.getText(element);
		}

		return result;
	}
}
