/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import java.util.List;

import org.eclipse.jface.wizard.Wizard;

import de.bsvrz.ibv.uda.verwaltung.protokoll.Protokoll;

/**
 * Wizard zum Anlegen eines Skriptlaufes.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class CreateProtokollWizard extends Wizard {

	/**
	 * Protokollliste.
	 */
	private final List<Protokoll> liste;

	/**
	 * Datenseite.
	 */
	private ProtokollDataPage dataPage;

	/** das zu bearbeitende Protokoll. */
	private final Protokoll protokoll;

	/**
	 * Konstruktor, für einen Dialog zum Anlegen oder Bearbeiten eines Protokolls.
	 *
	 * @param protokolle
	 *            Protokollliste.
	 * @param protokoll
	 *            ein zu bearbeitendes Protokoll, beim Anlegen eines neuen
	 *            Protokolls wird hier <code>null</code> übergeben.
	 */
	public CreateProtokollWizard(final List<Protokoll> protokolle, final Protokoll protokoll) {
		this.liste = protokolle;
		this.protokoll = protokoll;
	}

	@Override
	public void addPages() {
		dataPage = new ProtokollDataPage(protokoll);
		addPage(dataPage);
		super.addPages();
	}

	@Override
	public boolean performFinish() {

		final Protokoll protokollData = dataPage.getProtokoll();
		boolean result = false;

		if (protokollData != null) {
			if (protokoll == null) {
				liste.add(protokollData);
			} else {
				final int idx = liste.indexOf(protokoll);
				if (idx >= 0) {
					liste.remove(idx);
					liste.add(idx, protokollData);
				} else {
					liste.add(protokollData);
				}
			}
			result = true;
		}

		return result;
	}

}
