/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.ibv.uda.client.ClientException;
import de.bsvrz.ibv.uda.client.ClientSkriptLauf;
import de.bsvrz.ibv.uda.client.SkriptLaufDaten;

/**
 * Wizard zum Editieren der Daten eines Skriptlaufs.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class EditSkriptLaufWizard extends Wizard {

	/** die Datenseite zur Anzeige der Skriptlaufdaten. */
	private SkriptLaufDataPage dataPage;

	/** der editierte Skriptlauf. */
	private final ClientSkriptLauf lauf;

	/**
	 * Konstruktor.
	 *
	 * @param lauf
	 *            der Skriptlauf, der editiert werden soll
	 */
	public EditSkriptLaufWizard(final ClientSkriptLauf lauf) {
		this.lauf = lauf;
	}

	@Override
	public void addPages() {
		super.addPages();
		dataPage = new SkriptLaufDataPage(lauf.getModul(), lauf);
		addPage(dataPage);
	}

	@Override
	public boolean performFinish() {
		boolean result = false;
		final String benutzer = dataPage.getEditBenutzerName();
		if ((benutzer != null) && (benutzer.length() > 0)) {
			try {
				final SkriptLaufDaten daten = dataPage.getSkriptLauf();
				lauf.kopiereDaten(daten);
				lauf.save(benutzer, dataPage.getGrund());
				result = true;
			} catch (final ClientException e) {
				MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
						"Die Daten konnten nicht gesichert werden: " + e.getMessage());
			}
		} else {
			MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
					"Der Name des ändernden Nutzers muss eingetragen werden");
		}
		return result;
	}
}
