/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

import de.bsvrz.ibv.uda.verwaltung.protokoll.DateiProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.DavProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.KonsoleProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.LogProtokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.Protokoll;
import de.bsvrz.ibv.uda.verwaltung.protokoll.ProtokollTyp;

/**
 * DAV-Protokolltabelle.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class ProtokollDataPage extends WizardPage {

	/**
	 * Auswahlbox fuer Protokolltyp.
	 */
	private ComboViewer protokollTypSelector;

	/**
	 * Feld fuer Name des Protokolls.
	 */
	private Text nameField;

	/**
	 * Feld fuer Zeilen des Protokolls.
	 */
	private Spinner anzahlField;

	/**
	 * Feld fuer Groesse der Datei.
	 */
	private Spinner groesseField;

	/** ein optional zu bearbeitendes Prootkoll zur Initialisierung der Felder. */
	private final Protokoll protokoll;

	/**
	 * Standardkonstruktor.
	 *
	 * @param protokoll
	 *            das initial zu verwendende Protokoll
	 */
	protected ProtokollDataPage(final Protokoll protokoll) {
		super("Protokolldaten");
		setTitle("Protokollinformationen");
		setMessage("Geben Sie hier die Informationen zur Definition des Protokolls an");

		this.protokoll = protokoll;

	}

	@Override
	public void createControl(final Composite parent) {

		parent.setLayout(new GridLayout(2, false));

		Label label = new Label(parent, SWT.NONE);
		label.setText("Protokolltyp: ");
		protokollTypSelector = new ComboViewer(parent, SWT.NONE);
		protokollTypSelector.setContentProvider(new ProtokollTypProvider());
		protokollTypSelector.setInput(this);
		protokollTypSelector.getCombo().setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));

		if (protokoll != null) {
			protokollTypSelector.setSelection(new StructuredSelection(protokoll.getTyp()));
		} else {
			protokollTypSelector.setSelection(new StructuredSelection(ProtokollTyp.KONSOLE));
		}

		label = new Label(parent, SWT.NONE);
		label.setText("Name: ");
		nameField = new Text(parent, SWT.BORDER);
		nameField.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
		if (protokoll != null) {
			nameField.setText(protokoll.getName());
		}

		label = new Label(parent, SWT.NONE);
		label.setText("Anzahl: ");
		anzahlField = new Spinner(parent, SWT.BORDER);
		anzahlField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));
		if (protokoll != null) {
			anzahlField.setSelection((int) protokoll.getAnzahl());
		}

		label = new Label(parent, SWT.NONE);
		label.setText("Größe (MB): ");
		groesseField = new Spinner(parent, SWT.BORDER);
		groesseField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));
		if (protokoll != null) {
			groesseField.setSelection((int) protokoll.getMaxSize());
		}

		setControl(parent);
	}

	/**
	 * Erfragt das Protokoll.
	 *
	 * @return das Protokoll.
	 */
	public Protokoll getProtokoll() {
		final ProtokollTyp typ = (ProtokollTyp) ((IStructuredSelection) protokollTypSelector.getSelection())
				.getFirstElement();
		Protokoll ausgewaehltesProtokoll = null;
		if (ProtokollTyp.DATEI.equals(typ)) {
			ausgewaehltesProtokoll = new DateiProtokoll();
		} else if (ProtokollTyp.KONSOLE.equals(typ)) {
			ausgewaehltesProtokoll = new KonsoleProtokoll();
		} else if (ProtokollTyp.DAV.equals(typ)) {
			ausgewaehltesProtokoll = new DavProtokoll();
		} else if (ProtokollTyp.LOGGING.equals(typ)) {
			ausgewaehltesProtokoll = new LogProtokoll();
		}

		if (ausgewaehltesProtokoll != null) {
			ausgewaehltesProtokoll.setAnzahl(anzahlField.getSelection());
			ausgewaehltesProtokoll.setMaxSize(groesseField.getSelection());
			ausgewaehltesProtokoll.setName(nameField.getText());
		}
		return ausgewaehltesProtokoll;
	}

}
