/*
 * Rahmenwerk-Plugin fuer den Zugriff auf die Umfassende Datenanalyse (UDA)
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.uda.wizards;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import de.bsvrz.ibv.uda.client.ClientSkript;
import de.bsvrz.ibv.uda.uda.data.SkriptZustand;

/**
 * Skriptdatenseite.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public class SkriptDataPage extends WizardPage {

	/**
	 * Feld fuer Skriptname.
	 */
	private Text nameField;

	/**
	 * Feld fuer Beschreibung.
	 */
	private Text descField;

	/**
	 * Feld fuer Nutzernamen.
	 */
	private Text userField;

	/**
	 * Feld fuer Grund.
	 */
	private Text reasonField;

	/**
	 * Auswahlfeld fuer Skriptzustand.
	 */
	private ComboViewer zustandsSelector;

	/**
	 * Feld fuer Skriptdaten.
	 */
	private final SkriptDaten skriptDaten;

	/**
	 * Standardkonstruktor.
	 *
	 * @param skript
	 *            das Skript.
	 */
	protected SkriptDataPage(final ClientSkript skript) {
		super("Skriptdaten");
		setTitle("Skriptinformationen");
		setMessage("Geben Sie hier die Informationen zur Definition des Skripts an");

		skriptDaten = new SkriptDaten(skript);
	}

	@Override
	public void createControl(final Composite parent) {
		final GridLayout pageLayout = new GridLayout();
		pageLayout.numColumns = 2;
		parent.setLayout(pageLayout);
		parent.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label label = new Label(parent, SWT.NONE);
		label.setText("Skriptname: ");
		nameField = new Text(parent, SWT.BORDER);
		nameField.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
		nameField.setText(skriptDaten.getName());

		label = new Label(parent, SWT.NONE);
		label.setText("Beschreibung: ");
		descField = new Text(parent, SWT.BORDER);
		descField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));
		descField.setText(skriptDaten.getBeschreibung());

		label = new Label(parent, SWT.NONE);
		label.setText("Zustand: ");
		zustandsSelector = new ComboViewer(parent, SWT.NONE);
		zustandsSelector.setContentProvider(new UdaSkriptZustandsProvider());
		zustandsSelector.setInput(this);
		zustandsSelector.getCombo().setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));
		zustandsSelector.setSelection(new StructuredSelection(skriptDaten.getZustand()));

		label = new Label(parent, SWT.NONE);
		label.setText("Benutzer: ");
		userField = new Text(parent, SWT.BORDER);
		userField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));
		userField.setText(System.getProperty("user.name"));

		label = new Label(parent, SWT.NONE);
		label.setText("Grund: ");
		reasonField = new Text(parent, SWT.BORDER);
		reasonField.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL));

		setControl(parent);
	}

	/**
	 * Erfragt den Benutzernamen.
	 *
	 * @return den Benutzernamen.
	 */
	public String getBenutzer() {
		return userField.getText();
	}

	/**
	 * Erfragt den Grund.
	 *
	 * @return den Grund.
	 */
	public String getGrund() {
		return reasonField.getText();
	}

	/**
	 * Erfragt die Skriptdaten.
	 *
	 * @return die Skriptdaten.
	 */
	public SkriptDaten getSkriptDaten() {
		skriptDaten.setSkriptName(nameField.getText());
		skriptDaten.setSkriptBeschreibung(descField.getText());
		skriptDaten
				.setZustand((SkriptZustand) ((IStructuredSelection) zustandsSelector.getSelection()).getFirstElement());
		return skriptDaten;
	}
}
