/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.emf.dav;

import org.osgi.framework.BundleContext;

import com.bitctrl.lib.eclipse.emf.dav.model.provider.DavEditPlugin;
import com.bitctrl.lib.eclipse.log.PluginLogger;

import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProviderServiceTracker;

/**
 * BitCtrl Rahmenwerk Plug-in.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public final class DavPlugin extends DavEditPlugin.Implementation {

	/**
	 * Die Plugin-ID.
	 */
	public static final String PLUGIN_ID = "com.bitctrl.lib.eclipse.emf.dav";

	private static DavPlugin instance;

	/**
	 * Gibt die gemeinsame Instanz des Plug-ins zurück.
	 *
	 * @return das Singleton des Plug-ins.
	 */
	public static DavPlugin getDefault() {
		return instance;
	}

	private PluginLogger logger;
	private DavProviderServiceTracker davProviderServiceTracker;

	/**
	 * Gibt den Logger fÃ¼r das Plug-in zurÃ¼ck.
	 *
	 * @return der Plug-in-Logger.
	 */
	public PluginLogger getLogger() {
		if (logger == null) {
			logger = new PluginLogger(getLog());
		}
		return logger;
	}

	/**
	 * Gibt den {@link DavProvider} fÃ¼r die Nutzerverbindung zurück, der als
	 * OSGi-Service zur Verfügung gestellt wurde.
	 *
	 * @return die Nutzerverbindung.
	 * @throws IllegalStateException
	 *             wenn kein Nutzverbindung zur VerfÃ¼gung steht.
	 */
	public DavProvider getNutzerverbindung() {
		final DavProvider factory = davProviderServiceTracker
				.getNutzerverbindung();
		if (factory == null) {
			getLogger().error(
					"Von der Applikation wird kein DavProvider-Service fÃ¼r die Nutzerverbindung bereitgestellt. Erwartet wird ein Service der die Schnittstelle "
							+ DavProvider.class
							+ " implementiert und die Eigenschaft name=Nutzerverbindung besitzt.");
			throw new IllegalStateException(
					"Es steht derzeit keine ObjektFactory für die Nutzerverbindung zur VerfÃ¼gung.");
		}

		return factory;
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);

		instance = this;

		davProviderServiceTracker = new DavProviderServiceTracker(context);
		davProviderServiceTracker.open();
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		davProviderServiceTracker.close();

		instance = null;

		super.stop(context);
	}

}
