/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.emf.dav.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

import com.bitctrl.lib.eclipse.emf.dav.DavPlugin;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeGroupUsage;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectInfo;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Mock Implementierung für {@link SystemObject}e, die nicht (mehr) im
 * Datenverteiler existieren.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 */
public class MockSystemObject implements SystemObject, MockDavObject {

	private final String pid;

	public MockSystemObject(final String pid) {
		this.pid = pid;
	}

	@Override
	public int compareTo(Object arg0) {
		return 0;
	}

	@Override
	public long getId() {
		return 0;
	}

	@Override
	public SystemObjectType getType() {
		return new MockSystemObjectType("typ.unbekannterTyp");
	}

	@Override
	public boolean isOfType(SystemObjectType type) {
		return false;
	}

	@Override
	public boolean isOfType(String typePid) {
		return false;
	}

	@Override
	public String getPid() {
		return pid;
	}

	@Override
	public String getName() {
		return "Unbekanntes SystemObjekt " + pid;
	}

	@Override
	public void setName(String name) throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public String getNameOrPidOrId() {
		return getPid();
	}

	@Override
	public String getPidOrNameOrId() {
		return getPid();
	}

	@Override
	public String getPidOrId() {
		return getPid();
	}

	@Override
	public boolean isValid() {
		return false;
	}

	@Override
	public void invalidate() throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public DataModel getDataModel() {
		return DavPlugin.getDefault().getNutzerverbindung().getDav()
				.getDataModel();
	}

	@Override
	public Data getConfigurationData(AttributeGroup atg) {
		return null;
	}

	@Override
	public Data getConfigurationData(AttributeGroup atg, Aspect asp) {
		return null;
	}

	@Override
	public Data getConfigurationData(AttributeGroupUsage atgUsage) {
		return null;
	}

	@Override
	public void setConfigurationData(AttributeGroup atg, Data data)
			throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public void setConfigurationData(AttributeGroup atg, Aspect asp, Data data)
			throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public void setConfigurationData(AttributeGroupUsage atgUsage, Data data)
			throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public Collection<AttributeGroupUsage> getUsedAttributeGroupUsages() {
		return new ArrayList<>();
	}

	@Override
	public SystemObjectInfo getInfo() {
		return null;
	}

	@Override
	public ConfigurationArea getConfigurationArea() {
		return new MockConfigurationArea("unbekannte.configuration.area");
	}

	@Override
	public int hashCode() {
		return Objects.hash(pid);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if ((obj == null) || (getClass() != obj.getClass())) {
			return false;
		}
		final MockSystemObject other = (MockSystemObject) obj;
		return Objects.equals(pid, other.pid);
	}

	@Override
	public String toString() {
		return "Unbekanntes SystemObject [pid=" + pid + "]";
	}

}
