/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.emf.dav.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.ObjectSet;
import de.bsvrz.dav.daf.main.config.ObjectSetUse;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Mock Implementierung für {@link SystemObjectType}en, die nicht (mehr) im
 * Datenverteiler existieren.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 */
public class MockSystemObjectType extends MockSystemObject
		implements SystemObjectType {

	public MockSystemObjectType(final String pid) {
		super(pid);
	}

	@Override
	public short getValidSince() {
		return 0;
	}

	@Override
	public short getNotValidSince() {
		return 0;
	}

	@Override
	public NonMutableSet getNonMutableSet(String name) {
		return null;
	}

	@Override
	public MutableSet getMutableSet(String name) {
		return null;
	}

	@Override
	public ObjectSet getObjectSet(String name) {
		return null;
	}

	@Override
	public List<ObjectSet> getObjectSets() {
		return new ArrayList<>();
	}

	@Override
	public void revalidate() throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public SystemObject duplicate() throws ConfigurationChangeException {
		return null;
	}

	@Override
	public SystemObject duplicate(Map<String, String> substitudePids)
			throws ConfigurationChangeException {
		return null;
	}

	@Override
	public void addSet(ObjectSet set) throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public void removeSet(ObjectSet set) throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public long getId() {
		return 0;
	}

	@Override
	public SystemObjectType getType() {
		return null;
	}

	@Override
	public boolean isOfType(SystemObjectType type) {
		return false;
	}

	@Override
	public boolean isOfType(String typePid) {
		return false;
	}

	@Override
	public String getName() {
		return "Unbekannter SystemObjectType ";
	}

	@Override
	public void setName(String name) throws ConfigurationChangeException {
		// nüscht
	}

	@Override
	public List<SystemObject> getElements() {
		return new ArrayList<>();
	}

	@Override
	public List<SystemObject> getElements(long time) {
		return new ArrayList<>();
	}

	@Override
	public List<SystemObject> getElementsInPeriod(long startTime,
			long endTime) {
		return new ArrayList<>();
	}

	@Override
	public List<SystemObject> getElementsDuringPeriod(long startTime,
			long endTime) {
		return new ArrayList<>();
	}

	@Override
	public List<SystemObjectType> getSubTypes() {
		return new ArrayList<>();
	}

	@Override
	public List<SystemObjectType> getSuperTypes() {
		return new ArrayList<>(Arrays.asList(this));
	}

	@Override
	public boolean inheritsFrom(SystemObjectType other) {
		return false;
	}

	@Override
	public boolean isBaseType() {
		return true;
	}

	@Override
	public boolean isConfigurating() {
		return false;
	}

	@Override
	public boolean isNameOfObjectsPermanent() {
		return false;
	}

	@Override
	public List<SystemObject> getObjects() {
		return new ArrayList<>();
	}

	@Override
	public List<AttributeGroup> getDirectAttributeGroups() {
		return new ArrayList<>();
	}

	@Override
	public List<AttributeGroup> getAttributeGroups() {
		return new ArrayList<>();
	}

	@Override
	public List<ObjectSetUse> getDirectObjectSetUses() {
		return new ArrayList<>();
	}

	@Override
	public List<ObjectSetUse> getObjectSetUses() {
		return new ArrayList<>();
	}

	@Override
	public String toString() {
		return "Unbekannter SystemObjectType [pid=" + getPid() + "]";
	}

}
