/**
 * BitCtrl Rahmenwerk Plug-in
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weiï¿½enfelser Straï¿½e 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package com.bitctrl.lib.eclipse.emf.dav.model;

import de.bsvrz.dav.daf.main.config.AttributeGroup;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.bitctrl.lib.eclipse.emf.dav.model.DavFactory
 * @model kind="package"
 * @generated
 */
public interface DavPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "dav";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://com.bitctrl.lib.eclipse.dav/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "dav";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DavPackage eINSTANCE = com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl
			.init();

	/**
	 * The meta object id for the '<em>System Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.config.SystemObject
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getSystemObject()
	 * @generated
	 */
	int SYSTEM_OBJECT = 2;

	/**
	 * The meta object id for the '<em>Mutable Set</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.config.MutableSet
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getMutableSet()
	 * @generated
	 */
	int MUTABLE_SET = 3;

	/**
	 * The meta object id for the '<em>Attribute Group</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.config.AttributeGroup
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getAttributeGroup()
	 * @generated
	 */
	int ATTRIBUTE_GROUP = 4;

	/**
	 * The meta object id for the '<em>Aspect</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.config.Aspect
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getAspect()
	 * @generated
	 */
	int ASPECT = 5;

	/**
	 * The meta object id for the '<em>Data Description</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.DataDescription
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getDataDescription()
	 * @generated
	 */
	int DATA_DESCRIPTION = 6;

	/**
	 * The meta object id for the '<em>Result Data</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.ResultData
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getResultData()
	 * @generated
	 */
	int RESULT_DATA = 7;

	/**
	 * The meta object id for the '<em>Data</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.Data
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getData()
	 * @generated
	 */
	int DATA = 8;

	/**
	 * The meta object id for the '<em>System Object Type</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.config.SystemObjectType
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getSystemObjectType()
	 * @generated
	 */
	int SYSTEM_OBJECT_TYPE = 1;

	/**
	 * The meta object id for the '<em>Configuration Area</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.dav.daf.main.config.ConfigurationArea
	 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getConfigurationArea()
	 * @generated
	 */
	int CONFIGURATION_AREA = 0;

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.config.SystemObject <em>System Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>System Object</em>'.
	 * @see de.bsvrz.dav.daf.main.config.SystemObject
	 * @model instanceClass="de.bsvrz.dav.daf.main.config.SystemObject"
	 * @generated
	 */
	EDataType getSystemObject();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.config.MutableSet <em>Mutable Set</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Mutable Set</em>'.
	 * @see de.bsvrz.dav.daf.main.config.MutableSet
	 * @model instanceClass="de.bsvrz.dav.daf.main.config.MutableSet"
	 * @generated
	 */
	EDataType getMutableSet();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.config.AttributeGroup <em>Attribute Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Attribute Group</em>'.
	 * @see de.bsvrz.dav.daf.main.config.AttributeGroup
	 * @model instanceClass="de.bsvrz.dav.daf.main.config.AttributeGroup"
	 * @generated
	 */
	EDataType getAttributeGroup();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.config.Aspect <em>Aspect</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Aspect</em>'.
	 * @see de.bsvrz.dav.daf.main.config.Aspect
	 * @model instanceClass="de.bsvrz.dav.daf.main.config.Aspect"
	 * @generated
	 */
	EDataType getAspect();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.DataDescription <em>Data Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Data Description</em>'.
	 * @see de.bsvrz.dav.daf.main.DataDescription
	 * @model instanceClass="de.bsvrz.dav.daf.main.DataDescription" serializeable="false"
	 * @generated
	 */
	EDataType getDataDescription();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.ResultData <em>Result Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Result Data</em>'.
	 * @see de.bsvrz.dav.daf.main.ResultData
	 * @model instanceClass="de.bsvrz.dav.daf.main.ResultData" serializeable="false"
	 * @generated
	 */
	EDataType getResultData();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.Data <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Data</em>'.
	 * @see de.bsvrz.dav.daf.main.Data
	 * @model instanceClass="de.bsvrz.dav.daf.main.Data" serializeable="false"
	 * @generated
	 */
	EDataType getData();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.config.SystemObjectType <em>System Object Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>System Object Type</em>'.
	 * @see de.bsvrz.dav.daf.main.config.SystemObjectType
	 * @model instanceClass="de.bsvrz.dav.daf.main.config.SystemObjectType"
	 * @generated
	 */
	EDataType getSystemObjectType();

	/**
	 * Returns the meta object for data type '{@link de.bsvrz.dav.daf.main.config.ConfigurationArea <em>Configuration Area</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Configuration Area</em>'.
	 * @see de.bsvrz.dav.daf.main.config.ConfigurationArea
	 * @model instanceClass="de.bsvrz.dav.daf.main.config.ConfigurationArea"
	 * @generated
	 */
	EDataType getConfigurationArea();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DavFactory getDavFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '<em>System Object</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.config.SystemObject
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getSystemObject()
		 * @generated
		 */
		EDataType SYSTEM_OBJECT = eINSTANCE.getSystemObject();

		/**
		 * The meta object literal for the '<em>Mutable Set</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.config.MutableSet
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getMutableSet()
		 * @generated
		 */
		EDataType MUTABLE_SET = eINSTANCE.getMutableSet();

		/**
		 * The meta object literal for the '<em>Attribute Group</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.config.AttributeGroup
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getAttributeGroup()
		 * @generated
		 */
		EDataType ATTRIBUTE_GROUP = eINSTANCE.getAttributeGroup();

		/**
		 * The meta object literal for the '<em>Aspect</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.config.Aspect
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getAspect()
		 * @generated
		 */
		EDataType ASPECT = eINSTANCE.getAspect();

		/**
		 * The meta object literal for the '<em>Data Description</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.DataDescription
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getDataDescription()
		 * @generated
		 */
		EDataType DATA_DESCRIPTION = eINSTANCE.getDataDescription();

		/**
		 * The meta object literal for the '<em>Result Data</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.ResultData
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getResultData()
		 * @generated
		 */
		EDataType RESULT_DATA = eINSTANCE.getResultData();

		/**
		 * The meta object literal for the '<em>Data</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.Data
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getData()
		 * @generated
		 */
		EDataType DATA = eINSTANCE.getData();

		/**
		 * The meta object literal for the '<em>System Object Type</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.config.SystemObjectType
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getSystemObjectType()
		 * @generated
		 */
		EDataType SYSTEM_OBJECT_TYPE = eINSTANCE.getSystemObjectType();

		/**
		 * The meta object literal for the '<em>Configuration Area</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.dav.daf.main.config.ConfigurationArea
		 * @see com.bitctrl.lib.eclipse.emf.dav.model.impl.DavPackageImpl#getConfigurationArea()
		 * @generated
		 */
		EDataType CONFIGURATION_AREA = eINSTANCE.getConfigurationArea();

	}

} //DavPackage
