/**
 * BitCtrl Rahmenwerk Plug-in
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weiï¿½enfelser Straï¿½e 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package com.bitctrl.lib.eclipse.emf.dav.model.impl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import com.bitctrl.lib.eclipse.emf.dav.DavPlugin;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockAttributeGroup;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockConfigurationArea;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockMutableSet;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockSystemObject;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockSystemObjectType;
import com.bitctrl.lib.eclipse.emf.dav.model.DavFactory;
import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;

import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class DavFactoryImpl extends EFactoryImpl implements DavFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static DavFactory init() {
		try {
			DavFactory theDavFactory = (DavFactory) EPackage.Registry.INSTANCE
					.getEFactory("http://com.bitctrl.lib.eclipse.dav/1.0");
			if (theDavFactory != null) {
				return theDavFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DavFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public DavFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName()
					+ "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
		case DavPackage.CONFIGURATION_AREA:
			return createConfigurationAreaFromString(eDataType, initialValue);
		case DavPackage.SYSTEM_OBJECT_TYPE:
			return createSystemObjectTypeFromString(eDataType, initialValue);
		case DavPackage.SYSTEM_OBJECT:
			return createSystemObjectFromString(eDataType, initialValue);
		case DavPackage.MUTABLE_SET:
			return createMutableSetFromString(eDataType, initialValue);
		case DavPackage.ATTRIBUTE_GROUP:
			return createAttributeGroupFromString(eDataType, initialValue);
		case DavPackage.ASPECT:
			return createAspectFromString(eDataType, initialValue);
		default:
			throw new IllegalArgumentException("The datatype '"
					+ eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
		case DavPackage.CONFIGURATION_AREA:
			return convertConfigurationAreaToString(eDataType, instanceValue);
		case DavPackage.SYSTEM_OBJECT_TYPE:
			return convertSystemObjectTypeToString(eDataType, instanceValue);
		case DavPackage.SYSTEM_OBJECT:
			return convertSystemObjectToString(eDataType, instanceValue);
		case DavPackage.MUTABLE_SET:
			return convertMutableSetToString(eDataType, instanceValue);
		case DavPackage.ATTRIBUTE_GROUP:
			return convertAttributeGroupToString(eDataType, instanceValue);
		case DavPackage.ASPECT:
			return convertAspectToString(eDataType, instanceValue);
		default:
			throw new IllegalArgumentException("The datatype '"
					+ eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public SystemObject createSystemObjectFromString(EDataType eDataType,
			String initialValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT));

		SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav()
				.getDataModel().getObject(initialValue);
		if (so == null) {
			DavPlugin.getDefault().getLog().log(new Status(IStatus.ERROR,
					DavPlugin.PLUGIN_ID,
					"Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: "
							+ initialValue));

			so = new MockSystemObject(initialValue);
		}
		return so;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertSystemObjectToString(EDataType eDataType,
			Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT));
		return ((SystemObject) instanceValue).getPid();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public MutableSet createMutableSetFromString(EDataType eDataType,
			String initialValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.MUTABLE_SET));

		SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav()
				.getDataModel().getObject(Long.valueOf(initialValue));
		if (so == null) {
			DavPlugin.getDefault().getLog().log(new Status(IStatus.ERROR,
					DavPlugin.PLUGIN_ID,
					"Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: "
							+ initialValue));
			so = new MockMutableSet(initialValue);
		}
		return (MutableSet) so;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertMutableSetToString(EDataType eDataType,
			Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.MUTABLE_SET));
		return String.valueOf(((MutableSet) instanceValue).getId());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public AttributeGroup createAttributeGroupFromString(EDataType eDataType,
			String initialValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.ATTRIBUTE_GROUP));

		SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav()
				.getDataModel().getObject(initialValue);
		if (so == null) {
			DavPlugin.getDefault().getLog().log(new Status(IStatus.ERROR,
					DavPlugin.PLUGIN_ID,
					"Attributgruppe konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: "
							+ initialValue));
			so = new MockAttributeGroup(initialValue);
		}
		return (AttributeGroup) so;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertAttributeGroupToString(EDataType eDataType,
			Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.ATTRIBUTE_GROUP));
		return ((AttributeGroup) instanceValue).getPid();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Aspect createAspectFromString(EDataType eDataType,
			String initialValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.ASPECT));

		SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav()
				.getDataModel().getObject(initialValue);
		if (so == null) {
			DavPlugin.getDefault().getLog().log(new Status(IStatus.ERROR,
					DavPlugin.PLUGIN_ID,
					"Aspekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: "
							+ initialValue));
			so = new MockConfigurationArea(initialValue);
		}
		return (Aspect) so;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertAspectToString(EDataType eDataType,
			Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavPackage.Literals.ASPECT));
		return ((Aspect) instanceValue).getPid();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public SystemObjectType createSystemObjectTypeFromString(
			EDataType eDataType, String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT_TYPE));
		SystemObjectType type = DavPlugin.getDefault().getNutzerverbindung()
				.getDav().getDataModel().getType(initialValue);
		if (type == null) {
			DavPlugin.getDefault().getLog().log(new Status(IStatus.ERROR,
					DavPlugin.PLUGIN_ID,
					"Systemobjekttyp konnte nicht deserialisiert werden, weil er nicht (mehr?) existert: "
							+ initialValue));
			type = new MockSystemObjectType(initialValue);
		}
		return type;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertSystemObjectTypeToString(EDataType eDataType,
			Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT_TYPE));
		if (instanceValue == null) {
			return "";
		}
		return ((SystemObjectType) instanceValue).getPid();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public ConfigurationArea createConfigurationAreaFromString(
			EDataType eDataType, String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavPackage.Literals.CONFIGURATION_AREA));

		ConfigurationArea kb = DavPlugin.getDefault().getNutzerverbindung()
				.getDav().getDataModel().getConfigurationArea(initialValue);
		if (kb == null) {
			DavPlugin.getDefault().getLog().log(new Status(IStatus.ERROR,
					DavPlugin.PLUGIN_ID,
					"Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: "
							+ initialValue));
			kb = new MockConfigurationArea(initialValue);
		}
		return kb;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertConfigurationAreaToString(EDataType eDataType,
			Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavPackage.Literals.CONFIGURATION_AREA));
		return ((ConfigurationArea) instanceValue).getPid();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public DavPackage getDavPackage() {
		return (DavPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DavPackage getPackage() {
		return DavPackage.eINSTANCE;
	}

} // DavFactoryImpl
