/*
 * Decompiled with CFR 0.152.
 */
package com.bitctrl.lib.eclipse.emf.dav.model.impl;

import com.bitctrl.lib.eclipse.emf.dav.DavPlugin;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockAttributeGroup;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockConfigurationArea;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockMutableSet;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockSystemObject;
import com.bitctrl.lib.eclipse.emf.dav.mock.MockSystemObjectType;
import com.bitctrl.lib.eclipse.emf.dav.model.DavFactory;
import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DavFactoryImpl
extends EFactoryImpl
implements DavFactory {
    public static DavFactory init() {
        try {
            DavFactory theDavFactory = (DavFactory)EPackage.Registry.INSTANCE.getEFactory("http://com.bitctrl.lib.eclipse.dav/1.0");
            if (theDavFactory != null) {
                return theDavFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DavFactoryImpl();
    }

    public EObject create(EClass eClass) {
        eClass.getClassifierID();
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.createConfigurationAreaFromString(eDataType, initialValue);
            }
            case 1: {
                return this.createSystemObjectTypeFromString(eDataType, initialValue);
            }
            case 2: {
                return this.createSystemObjectFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createMutableSetFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createAttributeGroupFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createAspectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.convertConfigurationAreaToString(eDataType, instanceValue);
            }
            case 1: {
                return this.convertSystemObjectTypeToString(eDataType, instanceValue);
            }
            case 2: {
                return this.convertSystemObjectToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertMutableSetToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertAttributeGroupToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertAspectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public SystemObject createSystemObjectFromString(EDataType eDataType, String initialValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT));
        SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav().getDataModel().getObject(initialValue);
        if (so == null) {
            DavPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.bitctrl.lib.eclipse.emf.dav", "Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: " + initialValue));
            so = new MockSystemObject(initialValue);
        }
        return so;
    }

    public String convertSystemObjectToString(EDataType eDataType, Object instanceValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT));
        return ((SystemObject)instanceValue).getPid();
    }

    public MutableSet createMutableSetFromString(EDataType eDataType, String initialValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.MUTABLE_SET));
        SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav().getDataModel().getObject(Long.valueOf(initialValue).longValue());
        if (so == null) {
            DavPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.bitctrl.lib.eclipse.emf.dav", "Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: " + initialValue));
            so = new MockMutableSet(initialValue);
        }
        return (MutableSet)so;
    }

    public String convertMutableSetToString(EDataType eDataType, Object instanceValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.MUTABLE_SET));
        return String.valueOf(((MutableSet)instanceValue).getId());
    }

    public AttributeGroup createAttributeGroupFromString(EDataType eDataType, String initialValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.ATTRIBUTE_GROUP));
        SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav().getDataModel().getObject(initialValue);
        if (so == null) {
            DavPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.bitctrl.lib.eclipse.emf.dav", "Attributgruppe konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: " + initialValue));
            so = new MockAttributeGroup(initialValue);
        }
        return (AttributeGroup)so;
    }

    public String convertAttributeGroupToString(EDataType eDataType, Object instanceValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.ATTRIBUTE_GROUP));
        return ((AttributeGroup)instanceValue).getPid();
    }

    public Aspect createAspectFromString(EDataType eDataType, String initialValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.ASPECT));
        SystemObject so = DavPlugin.getDefault().getNutzerverbindung().getDav().getDataModel().getObject(initialValue);
        if (so == null) {
            DavPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.bitctrl.lib.eclipse.emf.dav", "Aspekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: " + initialValue));
            so = new MockConfigurationArea(initialValue);
        }
        return (Aspect)so;
    }

    public String convertAspectToString(EDataType eDataType, Object instanceValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.ASPECT));
        return ((Aspect)instanceValue).getPid();
    }

    public SystemObjectType createSystemObjectTypeFromString(EDataType eDataType, String initialValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT_TYPE));
        SystemObjectType type = DavPlugin.getDefault().getNutzerverbindung().getDav().getDataModel().getType(initialValue);
        if (type == null) {
            DavPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.bitctrl.lib.eclipse.emf.dav", "Systemobjekttyp konnte nicht deserialisiert werden, weil er nicht (mehr?) existert: " + initialValue));
            type = new MockSystemObjectType(initialValue);
        }
        return type;
    }

    public String convertSystemObjectTypeToString(EDataType eDataType, Object instanceValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.SYSTEM_OBJECT_TYPE));
        if (instanceValue == null) {
            return "";
        }
        return ((SystemObjectType)instanceValue).getPid();
    }

    public ConfigurationArea createConfigurationAreaFromString(EDataType eDataType, String initialValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.CONFIGURATION_AREA));
        ConfigurationArea kb = DavPlugin.getDefault().getNutzerverbindung().getDav().getDataModel().getConfigurationArea(initialValue);
        if (kb == null) {
            DavPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.bitctrl.lib.eclipse.emf.dav", "Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existert: " + initialValue));
            kb = new MockConfigurationArea(initialValue);
        }
        return kb;
    }

    public String convertConfigurationAreaToString(EDataType eDataType, Object instanceValue) {
        Assert.isLegal((boolean)eDataType.equals(DavPackage.Literals.CONFIGURATION_AREA));
        return ((ConfigurationArea)instanceValue).getPid();
    }

    @Override
    public DavPackage getDavPackage() {
        return (DavPackage)this.getEPackage();
    }

    @Deprecated
    public static DavPackage getPackage() {
        return DavPackage.eINSTANCE;
    }
}

