/**
 * BitCtrl Rahmenwerk Plug-in
 * Copyright (C) 2010 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * WeiÃenfelser StraÃe 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package com.bitctrl.lib.eclipse.emf.davbitctrl.model.impl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import com.bitctrl.lib.eclipse.emf.davbitctrl.DavBitCtrl;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlFactory;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;

import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Gewaesser;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Kreis;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortslage;
import de.bsvrz.sys.funclib.bitctrl.modell.mifimportobjektetypen.objekte.Ortsname;
import de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.BestehtAusLinienObjekten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.FlaecheXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmswis.objekte.Gma;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsFahrBahnOberFlaechenTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsFahrBahnOberFlaechenZustand;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsLuftTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsNiederschlagsIntensitaet;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsSichtWeite;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class DavbitctrlFactoryImpl extends EFactoryImpl
		implements DavbitctrlFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static DavbitctrlFactory init() {
		try {
			final DavbitctrlFactory theDavbitctrlFactory = (DavbitctrlFactory) EPackage.Registry.INSTANCE
					.getEFactory(DavbitctrlPackage.eNS_URI);
			if (theDavbitctrlFactory != null) {
				return theDavbitctrlFactory;
			}
		} catch (final Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DavbitctrlFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public DavbitctrlFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName()
					+ "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		return switch (eDataType.getClassifierID()) {
		case DavbitctrlPackage.BILD -> createBildFromString(eDataType, initialValue);
		case DavbitctrlPackage.NETZ -> createNetzFromString(eDataType, initialValue);
		case DavbitctrlPackage.SYSTEM_OBJEKT -> createSystemObjektFromString(eDataType, initialValue);
		case DavbitctrlPackage.MESS_QUERSCHNITT_ALLGEMEIN -> createMessQuerschnittAllgemeinFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.FAHR_STREIFEN -> createFahrStreifenFromString(eDataType, initialValue);
		case DavbitctrlPackage.PORTABLE_BITMAP -> createPortableBitmapFromString(eDataType, initialValue);
		case DavbitctrlPackage.STRASSEN_SEGMENT -> createStrassenSegmentFromString(eDataType, initialValue);
		case DavbitctrlPackage.KREIS -> createKreisFromString(eDataType, initialValue);
		case DavbitctrlPackage.ORTSLAGE -> createOrtslageFromString(eDataType, initialValue);
		case DavbitctrlPackage.ORTSNAME -> createOrtsnameFromString(eDataType, initialValue);
		case DavbitctrlPackage.STRASSEN_KNOTEN -> createStrassenKnotenFromString(eDataType, initialValue);
		case DavbitctrlPackage.STOERFALL_INDIKATOR -> createStoerfallIndikatorFromString(eDataType, initialValue);
		case DavbitctrlPackage.UMFELD_DATEN_MESS_STELLE -> createUmfeldDatenMessStelleFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.ANZEIGE_QUERSCHNITT -> createAnzeigeQuerschnittFromString(eDataType, initialValue);
		case DavbitctrlPackage.GEWAESSER -> createGewaesserFromString(eDataType, initialValue);
		case DavbitctrlPackage.SITUATION -> createSituationFromString(eDataType, initialValue);
		case DavbitctrlPackage.BAUSTELLE -> createBaustelleFromString(eDataType, initialValue);
		case DavbitctrlPackage.STAU -> createStauFromString(eDataType, initialValue);
		case DavbitctrlPackage.UNFALL -> createUnfallFromString(eDataType, initialValue);
		case DavbitctrlPackage.RDS_MELDUNG -> createRdsMeldungFromString(eDataType, initialValue);
		case DavbitctrlPackage.UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT -> createUfdsWindGeschwindigkeitMittelWertFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT -> createUfdsWindGeschwindigkeitSpitzenWertFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.UFDS_WIND_RICHTUNG -> createUfdsWindRichtungFromString(eDataType, initialValue);
		case DavbitctrlPackage.VBA_EVENT -> createVbaEventFromString(eDataType, initialValue);
		case DavbitctrlPackage.GMA -> createGmaFromString(eDataType, initialValue);
		case DavbitctrlPackage.GEO_REFERENZ_OBJEKT -> createGeoReferenzObjektFromString(eDataType, initialValue);
		case DavbitctrlPackage.PUNKT -> createPunktFromString(eDataType, initialValue);
		case DavbitctrlPackage.PUNKT_XY -> createPunktXYFromString(eDataType, initialValue);
		case DavbitctrlPackage.PUNKT_LIEGT_AUF_LINIEN_OBJEKT -> createPunktLiegtAufLinienObjektFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.LINIE -> createLinieFromString(eDataType, initialValue);
		case DavbitctrlPackage.LINIE_XY -> createLinieXYFromString(eDataType, initialValue);
		case DavbitctrlPackage.BESTEHT_AUS_LINIEN_OBJEKTEN -> createBestehtAusLinienObjektenFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.FLAECHE -> createFlaecheFromString(eDataType, initialValue);
		case DavbitctrlPackage.FLAECHE_XY -> createFlaecheXYFromString(eDataType, initialValue);
		case DavbitctrlPackage.KOMPLEX -> createKomplexFromString(eDataType, initialValue);
		case DavbitctrlPackage.KOMPLEX_XY -> createKomplexXYFromString(eDataType, initialValue);
		case DavbitctrlPackage.TMC_VERKEHRS_MELDUNG -> createTmcVerkehrsMeldungFromString(eDataType, initialValue);
		case DavbitctrlPackage.UMFELD_DATEN_SENSOR -> createUmfeldDatenSensorFromString(eDataType, initialValue);
		case DavbitctrlPackage.UFDS_NIEDERSCHLAGS_INTENSITAET -> createUfdsNiederschlagsIntensitaetFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.UFDS_LUFT_TEMPERATUR -> createUfdsLuftTemperaturFromString(eDataType, initialValue);
		case DavbitctrlPackage.UFDS_FAHR_BAHN_OBER_FLAECHEN_TEMPERATUR -> createUfdsFahrBahnOberFlaechenTemperaturFromString(eDataType,
							initialValue);
		case DavbitctrlPackage.UFDS_SICHT_WEITE -> createUfdsSichtWeiteFromString(eDataType, initialValue);
		case DavbitctrlPackage.UFDS_FAHR_BAHN_OBER_FLAECHEN_ZUSTAND -> createUfdsFahrBahnOberFlaechenZustandFromString(eDataType,
							initialValue);
		default -> throw new IllegalArgumentException("The datatype '"
				+ eDataType.getName() + "' is not a valid classifier");
		};
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		return switch (eDataType.getClassifierID()) {
		case DavbitctrlPackage.BILD -> convertBildToString(eDataType, instanceValue);
		case DavbitctrlPackage.NETZ -> convertNetzToString(eDataType, instanceValue);
		case DavbitctrlPackage.SYSTEM_OBJEKT -> convertSystemObjektToString(eDataType, instanceValue);
		case DavbitctrlPackage.MESS_QUERSCHNITT_ALLGEMEIN -> convertMessQuerschnittAllgemeinToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.FAHR_STREIFEN -> convertFahrStreifenToString(eDataType, instanceValue);
		case DavbitctrlPackage.PORTABLE_BITMAP -> convertPortableBitmapToString(eDataType, instanceValue);
		case DavbitctrlPackage.STRASSEN_SEGMENT -> convertStrassenSegmentToString(eDataType, instanceValue);
		case DavbitctrlPackage.KREIS -> convertKreisToString(eDataType, instanceValue);
		case DavbitctrlPackage.ORTSLAGE -> convertOrtslageToString(eDataType, instanceValue);
		case DavbitctrlPackage.ORTSNAME -> convertOrtsnameToString(eDataType, instanceValue);
		case DavbitctrlPackage.STRASSEN_KNOTEN -> convertStrassenKnotenToString(eDataType, instanceValue);
		case DavbitctrlPackage.STOERFALL_INDIKATOR -> convertStoerfallIndikatorToString(eDataType, instanceValue);
		case DavbitctrlPackage.UMFELD_DATEN_MESS_STELLE -> convertUmfeldDatenMessStelleToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.ANZEIGE_QUERSCHNITT -> convertAnzeigeQuerschnittToString(eDataType, instanceValue);
		case DavbitctrlPackage.GEWAESSER -> convertGewaesserToString(eDataType, instanceValue);
		case DavbitctrlPackage.SITUATION -> convertSituationToString(eDataType, instanceValue);
		case DavbitctrlPackage.BAUSTELLE -> convertBaustelleToString(eDataType, instanceValue);
		case DavbitctrlPackage.STAU -> convertStauToString(eDataType, instanceValue);
		case DavbitctrlPackage.UNFALL -> convertUnfallToString(eDataType, instanceValue);
		case DavbitctrlPackage.RDS_MELDUNG -> convertRdsMeldungToString(eDataType, instanceValue);
		case DavbitctrlPackage.UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT -> convertUfdsWindGeschwindigkeitMittelWertToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT -> convertUfdsWindGeschwindigkeitSpitzenWertToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.UFDS_WIND_RICHTUNG -> convertUfdsWindRichtungToString(eDataType, instanceValue);
		case DavbitctrlPackage.VBA_EVENT -> convertVbaEventToString(eDataType, instanceValue);
		case DavbitctrlPackage.GMA -> convertGmaToString(eDataType, instanceValue);
		case DavbitctrlPackage.GEO_REFERENZ_OBJEKT -> convertGeoReferenzObjektToString(eDataType, instanceValue);
		case DavbitctrlPackage.PUNKT -> convertPunktToString(eDataType, instanceValue);
		case DavbitctrlPackage.PUNKT_XY -> convertPunktXYToString(eDataType, instanceValue);
		case DavbitctrlPackage.PUNKT_LIEGT_AUF_LINIEN_OBJEKT -> convertPunktLiegtAufLinienObjektToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.LINIE -> convertLinieToString(eDataType, instanceValue);
		case DavbitctrlPackage.LINIE_XY -> convertLinieXYToString(eDataType, instanceValue);
		case DavbitctrlPackage.BESTEHT_AUS_LINIEN_OBJEKTEN -> convertBestehtAusLinienObjektenToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.FLAECHE -> convertFlaecheToString(eDataType, instanceValue);
		case DavbitctrlPackage.FLAECHE_XY -> convertFlaecheXYToString(eDataType, instanceValue);
		case DavbitctrlPackage.KOMPLEX -> convertKomplexToString(eDataType, instanceValue);
		case DavbitctrlPackage.KOMPLEX_XY -> convertKomplexXYToString(eDataType, instanceValue);
		case DavbitctrlPackage.TMC_VERKEHRS_MELDUNG -> convertTmcVerkehrsMeldungToString(eDataType, instanceValue);
		case DavbitctrlPackage.UMFELD_DATEN_SENSOR -> convertUmfeldDatenSensorToString(eDataType, instanceValue);
		case DavbitctrlPackage.UFDS_NIEDERSCHLAGS_INTENSITAET -> convertUfdsNiederschlagsIntensitaetToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.UFDS_LUFT_TEMPERATUR -> convertUfdsLuftTemperaturToString(eDataType, instanceValue);
		case DavbitctrlPackage.UFDS_FAHR_BAHN_OBER_FLAECHEN_TEMPERATUR -> convertUfdsFahrBahnOberFlaechenTemperaturToString(eDataType,
							instanceValue);
		case DavbitctrlPackage.UFDS_SICHT_WEITE -> convertUfdsSichtWeiteToString(eDataType, instanceValue);
		case DavbitctrlPackage.UFDS_FAHR_BAHN_OBER_FLAECHEN_ZUSTAND -> convertUfdsFahrBahnOberFlaechenZustandToString(eDataType,
							instanceValue);
		default -> throw new IllegalArgumentException("The datatype '"
				+ eDataType.getName() + "' is not a valid classifier");
		};
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Bild createBildFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.BILD));
		return (Bild) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertBildToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.BILD));
		return convertSystemObjektToString((Bild) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Netz createNetzFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.NETZ));
		return (Netz) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertNetzToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.NETZ));
		return convertSystemObjektToString((Netz) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public SystemObjekt createSystemObjektFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.SYSTEM_OBJEKT));
		return createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertSystemObjektToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.SYSTEM_OBJEKT));
		return convertSystemObjektToString((SystemObjekt) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public MessQuerschnittAllgemein createMessQuerschnittAllgemeinFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.MESS_QUERSCHNITT_ALLGEMEIN));
		return (MessQuerschnittAllgemein) createSystemObjektFromString(
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertMessQuerschnittAllgemeinToString(
			final EDataType eDataType, final Object instanceValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.MESS_QUERSCHNITT_ALLGEMEIN));
		return convertSystemObjektToString((MessQuerschnitt) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public FahrStreifen createFahrStreifenFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.FAHR_STREIFEN));
		return (FahrStreifen) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertFahrStreifenToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.FAHR_STREIFEN));
		return convertSystemObjektToString((FahrStreifen) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public PortableBitMap createPortableBitmapFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.PORTABLE_BITMAP));
		return (PortableBitMap) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertPortableBitmapToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.PORTABLE_BITMAP));
		return convertSystemObjektToString((PortableBitMap) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public StrassenSegment createStrassenSegmentFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.STRASSEN_SEGMENT));
		return (StrassenSegment) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertStrassenSegmentToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.STRASSEN_SEGMENT));
		return convertSystemObjektToString((StrassenSegment) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Kreis createKreisFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.KREIS));
		return (Kreis) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertKreisToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.KREIS));
		return convertSystemObjektToString((Kreis) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Ortslage createOrtslageFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.ORTSLAGE));
		return (Ortslage) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertOrtslageToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.ORTSLAGE));
		return convertSystemObjektToString((Ortslage) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Ortsname createOrtsnameFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.ORTSNAME));
		return (Ortsname) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertOrtsnameToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.ORTSNAME));
		return convertSystemObjektToString((Ortsname) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public StrassenKnoten createStrassenKnotenFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.STRASSEN_KNOTEN));
		return (StrassenKnoten) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertStrassenKnotenToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.STRASSEN_KNOTEN));
		return convertSystemObjektToString((StrassenKnoten) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public StoerfallIndikator createStoerfallIndikatorFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.STOERFALL_INDIKATOR));
		return (StoerfallIndikator) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertStoerfallIndikatorToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.STOERFALL_INDIKATOR));
		return convertSystemObjektToString((StoerfallIndikator) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public UmfeldDatenMessStelle createUmfeldDatenMessStelleFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.UMFELD_DATEN_MESS_STELLE));
		return (UmfeldDatenMessStelle) createSystemObjektFromString(
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertUmfeldDatenMessStelleToString(
			final EDataType eDataType, final Object instanceValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.UMFELD_DATEN_MESS_STELLE));
		return convertSystemObjektToString(
				(UmfeldDatenMessStelle) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public AnzeigeQuerschnitt createAnzeigeQuerschnittFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.ANZEIGE_QUERSCHNITT));
		return (AnzeigeQuerschnitt) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertAnzeigeQuerschnittToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.ANZEIGE_QUERSCHNITT));
		return convertSystemObjektToString((AnzeigeQuerschnitt) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Gewaesser createGewaesserFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.GEWAESSER));
		return (Gewaesser) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertGewaesserToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.GEWAESSER));
		return convertSystemObjektToString((Gewaesser) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Situation createSituationFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.SITUATION));
		return (Situation) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertSituationToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.SITUATION));
		return convertSystemObjektToString((Situation) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Baustelle createBaustelleFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.BAUSTELLE));
		return (Baustelle) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertBaustelleToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.BAUSTELLE));
		return convertSystemObjektToString((Baustelle) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Stau createStauFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.STAU));
		return (Stau) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertStauToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.STAU));
		return convertSystemObjektToString((Stau) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public Unfall createUnfallFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.UNFALL));
		return (Unfall) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertUnfallToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.UNFALL));
		return convertSystemObjektToString((Unfall) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public RdsMeldung createRdsMeldungFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.RDS_MELDUNG));
		return (RdsMeldung) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertRdsMeldungToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(
				eDataType.equals(DavbitctrlPackage.Literals.RDS_MELDUNG));
		return convertSystemObjektToString((RdsMeldung) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public UfdsWindGeschwindigkeitMittelWert createUfdsWindGeschwindigkeitMittelWertFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType.equals(
				DavbitctrlPackage.Literals.UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT));
		return (UfdsWindGeschwindigkeitMittelWert) createSystemObjektFromString(
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertUfdsWindGeschwindigkeitMittelWertToString(
			final EDataType eDataType, final Object instanceValue) {
		Assert.isLegal(eDataType.equals(
				DavbitctrlPackage.Literals.UFDS_WIND_GESCHWINDIGKEIT_MITTEL_WERT));
		return convertSystemObjektToString(
				(UfdsWindGeschwindigkeitMittelWert) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public UfdsWindGeschwindigkeitSpitzenWert createUfdsWindGeschwindigkeitSpitzenWertFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType.equals(
				DavbitctrlPackage.Literals.UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT));
		return (UfdsWindGeschwindigkeitSpitzenWert) createSystemObjektFromString(
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertUfdsWindGeschwindigkeitSpitzenWertToString(
			final EDataType eDataType, final Object instanceValue) {
		Assert.isLegal(eDataType.equals(
				DavbitctrlPackage.Literals.UFDS_WIND_GESCHWINDIGKEIT_SPITZEN_WERT));
		return convertSystemObjektToString(
				(UfdsWindGeschwindigkeitSpitzenWert) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public UfdsWindRichtung createUfdsWindRichtungFromString(
			final EDataType eDataType, final String initialValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.UFDS_WIND_RICHTUNG));
		return (UfdsWindRichtung) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertUfdsWindRichtungToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType
				.equals(DavbitctrlPackage.Literals.UFDS_WIND_RICHTUNG));
		return convertSystemObjektToString((UfdsWindRichtung) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public VbaEvent createVbaEventFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.VBA_EVENT));
		return (VbaEvent) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	public String convertVbaEventToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.VBA_EVENT));
		return convertSystemObjektToString((VbaEvent) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public KomplexXY createKomplexXYFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.KOMPLEX_XY));
		return (KomplexXY) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertKomplexXYToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.KOMPLEX_XY));
		return convertSystemObjektToString((KomplexXY) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TmcVerkehrsMeldung createTmcVerkehrsMeldungFromString(
			EDataType eDataType, String initialValue) {
		return (TmcVerkehrsMeldung) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertTmcVerkehrsMeldungToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UmfeldDatenSensor createUmfeldDatenSensorFromString(
			EDataType eDataType, String initialValue) {
		return (UmfeldDatenSensor) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUmfeldDatenSensorToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UfdsNiederschlagsIntensitaet createUfdsNiederschlagsIntensitaetFromString(
			EDataType eDataType, String initialValue) {
		return (UfdsNiederschlagsIntensitaet) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUfdsNiederschlagsIntensitaetToString(
			EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UfdsLuftTemperatur createUfdsLuftTemperaturFromString(
			EDataType eDataType, String initialValue) {
		return (UfdsLuftTemperatur) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUfdsLuftTemperaturToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UfdsFahrBahnOberFlaechenTemperatur createUfdsFahrBahnOberFlaechenTemperaturFromString(
			EDataType eDataType, String initialValue) {
		return (UfdsFahrBahnOberFlaechenTemperatur) super.createFromString(
				eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUfdsFahrBahnOberFlaechenTemperaturToString(
			EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UfdsSichtWeite createUfdsSichtWeiteFromString(EDataType eDataType,
			String initialValue) {
		return (UfdsSichtWeite) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUfdsSichtWeiteToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UfdsFahrBahnOberFlaechenZustand createUfdsFahrBahnOberFlaechenZustandFromString(
			EDataType eDataType, String initialValue) {
		return (UfdsFahrBahnOberFlaechenZustand) super.createFromString(
				eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUfdsFahrBahnOberFlaechenZustandToString(
			EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Gma createGmaFromString(final EDataType eDataType,
			final String initialValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.GMA));
		return (Gma) createSystemObjektFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertGmaToString(final EDataType eDataType,
			final Object instanceValue) {
		Assert.isLegal(eDataType.equals(DavbitctrlPackage.Literals.GMA));
		return convertSystemObjektToString((Gma) instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public GeoReferenzObjekt createGeoReferenzObjektFromString(
			EDataType eDataType, String initialValue) {
		return (GeoReferenzObjekt) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertGeoReferenzObjektToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Punkt createPunktFromString(EDataType eDataType,
			String initialValue) {
		return (Punkt) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertPunktToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public PunktXY createPunktXYFromString(EDataType eDataType,
			String initialValue) {
		return (PunktXY) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertPunktXYToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public PunktLiegtAufLinienObjekt createPunktLiegtAufLinienObjektFromString(
			EDataType eDataType, String initialValue) {
		return (PunktLiegtAufLinienObjekt) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertPunktLiegtAufLinienObjektToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Linie createLinieFromString(EDataType eDataType,
			String initialValue) {
		return (Linie) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLinieToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public LinieXY createLinieXYFromString(EDataType eDataType,
			String initialValue) {
		return (LinieXY) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLinieXYToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public BestehtAusLinienObjekten createBestehtAusLinienObjektenFromString(
			EDataType eDataType, String initialValue) {
		return (BestehtAusLinienObjekten) super.createFromString(eDataType,
				initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertBestehtAusLinienObjektenToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Flaeche createFlaecheFromString(EDataType eDataType,
			String initialValue) {
		return (Flaeche) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFlaecheToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public FlaecheXY createFlaecheXYFromString(EDataType eDataType,
			String initialValue) {
		return (FlaecheXY) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFlaecheXYToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Komplex createKomplexFromString(EDataType eDataType,
			String initialValue) {
		return (Komplex) super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertKomplexToString(EDataType eDataType,
			Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public DavbitctrlPackage getDavbitctrlPackage() {
		return (DavbitctrlPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DavbitctrlPackage getPackage() {
		return DavbitctrlPackage.eINSTANCE;
	}

	/**
	 * @generated NOT
	 */
	private String convertSystemObjektToString(final SystemObjekt so) {
		return so.getPid();
	}

	/**
	 * @generated NOT
	 */
	private SystemObjekt createSystemObjektFromString(final String pid) {
		final SystemObjekt so = DavBitCtrl.getExemplar().getObjektFactory()
				.getModellobjekt(pid);
		if (so != null) {
			return so;
		}

		throw new IllegalStateException(
				"Systemobjekt konnte nicht deserialisiert werden, weil es nicht (mehr?) existiert: "
						+ pid);
	}

} // DavbitctrlFactoryImpl
