/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl;

/**
 * Allgemeine Konstanten, die nur von (mehreren!) Plugins von BitCtrl benutzt
 * werden.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 */
public final class BitCtrlRahmenwerkConstants {

	private BitCtrlRahmenwerkConstants() {
		// es gibt keine Instanzen der Klasse
	}

	/**
	 * Indiziert, dass es sich bei der Selektion um einen Streckenzug handelt.
	 */
	public static final String SELECTION_STRECKEN_ZUG = "SELECTION:STRECKEN_ZUG";

	/**
	 * Variable die als Flag fungiert, ob der aktuell angemeldete Nutzer
	 * Administrator ist. Die Variable kann in Expressions in der
	 * <code>plugin.xml</code> verwendet werden. Der Name der Variable ist
	 * <code>{@value}</code> , ihr Wert kann <code>true</code> oder
	 * <code>false</code> sein.
	 */
	public static final String VARIABLE_IS_AKTUELLER_BENUTZER_ADMIN = "de.bsvrz.buv.rw.bitctrl.eclipse.variable.isAktuellerBenutzerAdmin";

	/**
	 * Variable die als Flag fungiert, ob eine Verbindung mit dem Datenverteiler
	 * besteht. Die Variable kann in Expressions in der <code>plugin.xml</code>
	 * verwendet werden. Der Name der Variable ist <code>{@value}</code> , ihr
	 * Wert kann <code>true</code> oder <code>false</code> sein.
	 */
	public static final String VARIABLE_IS_DAV_VERBUNDEN = "de.bsvrz.buv.rw.bitctrl.eclipse.variable.isDavVerbunden";

}
