/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;

public enum BitCtrlSharedImage {
	ZEITBEREICH_UEBERNEHMEN_GIF("zeitbereich_uebernehmen",
			"icons/aktionen/zeitbereich_uebernehmen.gif");

	private final String key;
	private final String imagePath;

	BitCtrlSharedImage(final String key, final String imagePath) {
		this.key = key;
		this.imagePath = imagePath;
	}

	public Image getImage() {
		final ImageRegistry imageRegistry = BitCtrlRahmenwerkPlugin.getDefault()
				.getImageRegistry();

		final Image result = imageRegistry.get(key);
		if (result != null) {
			return result;
		}

		final ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin(
				BitCtrlRahmenwerkPlugin.PLUGIN_ID, imagePath);
		if (desc != null) {
			imageRegistry.put(key, desc);
			return imageRegistry.get(key);
		}
		return null;
	}
}
