/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl;

import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigeVerfahrenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MifCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.ModellObjektCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MqCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCacheExtended;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.RdsMeldungenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StrassenTeilSegmenteCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.StreckenAbschnittCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.TmcLocationCodeCache;

public interface CacheService {

	/**
	 * Gibt den {@link AnzeigenCache} zurück. * Existiert der Cache noch nicht,
	 * wird er angelegt und dessen Initialisierung im Hintergrund angestossen.
	 *
	 * @return der {@link AnzeigenCache}.
	 */
	AnzeigenCache getAnzeigenCache();

	/**
	 * Gibt den AnzeigeVerfahren-Cache fuer ein bestimmtes Netz zurueck.
	 * Existiert der Cache noch nicht, wird er angelegt und dessen
	 * Initialisierung im Hintergrund angestossen.
	 *
	 * @return der Cache.
	 */
	AnzeigeVerfahrenCache getAnzeigeVerfahrenCache();

	/**
	 * Gibt den Anzeigequerschnitt-Cache fuer ein bestimmtes Netz zurueck.
	 * Existiert der Cache noch nicht, wird er angelegt und dessen
	 * Initialisierung im Hintergrund angestossen.
	 *
	 * @return der Cache zu dem angegebenen Netz.
	 */
	AqCache getAqCache(final String netz);

	/**
	 * Gibt den MIF-Cache fuer ein bestimmtes Netz zurueck. Existiert der Cache
	 * noch nicht, wird er angelegt und dessen Initialisierung im Hintergrund
	 * angestossen.
	 *
	 * @return der Cache.
	 */
	MifCache getMifCache();

	/**
	 * Gibt einen Cache für ein bestimmtes ModellObjekt passend zu einer PID
	 * zurück. Existiert der Cache noch nicht, wird er angelegt und dessen
	 * Initialisierung im Hintergrund angestoßen.
	 *
	 * @param netz
	 *            ein Netz.
	 * @return der Cache zu dem angegebenen Netz.
	 */
	ModellObjektCache getModellObjektCache(final String netz);

	/**
	 * Gibt den Mq-Cache für ein bestimmtes Netz zurück. Existiert der Cache
	 * noch nicht, wird er angelegt und dessen Initialisierung im Hintergrund
	 * angestoßen.
	 *
	 * @param netz
	 *            ein Netz.
	 * @return der Cache zu dem angegebenen Netz.
	 */
	MqCache getMqCache(final String netz);

	/**
	 * Gibt den Netz-Cache für ein bestimmtes Netz zurück. Existiert der Cache
	 * noch nicht, wird er angelegt und dessen Initialisierung im Hintergrund
	 * angestoßen.
	 *
	 * @param netz
	 *            ein Netz.
	 * @return der Cache zu dem angegebenen Netz.
	 */
	NetzCache getNetzCache(final String netz);

	/**
	 * Gibt den erweiterten Netz-Cache für ein bestimmtes Netz zurück. Existiert
	 * der Cache noch nicht, wird er angelegt und dessen Initialisierung im
	 * Hintergrund angestoßen.
	 *
	 * @param netz
	 *            ein Netz.
	 * @return der Cache zu dem angegebenen Netz.
	 */
	NetzCacheExtended getNetzCacheExtended(final String netz);

	/**
	 * Gibt den Rds-Cache zurück. Existiert der Cache noch nicht, wird er
	 * angelegt und dessen Initialisierung im Hintergrund angestoßen.
	 *
	 * @return der Cache zu dem angegebenen Netz.
	 */
	RdsCache getRdsCache();

	/**
	 * Gibt den RdsMeldungen-Cache für eine bestimmte Landesmeldestelle zurück.
	 * Existiert der Cache noch nicht, wird er angelegt und dessen
	 * Initialisierung im Hintergrund angestoßen.
	 *
	 * @param lms
	 *            die PID einer Landesmeldestelle
	 *
	 * @return der Cache zu der angegebenen Landesmeldestelle
	 */
	RdsMeldungenCache getRdsMeldungenCache(final String lms);

	/**
	 * Gibt den StrassenTeilSegmente-Cache für ein bestimmtes Netz zurück.
	 * Existiert der Cache noch nicht, wird er angelegt und dessen
	 * Initialisierung im Hintergrund angestoßen.
	 *
	 * @param netz
	 *            ein Netz
	 * @return der Cache zu dem angegebenen Netz.
	 */
	StrassenTeilSegmenteCache getStrassenTeilSegmenteCache(final String netz);

	/**
	 * Gibt den Streckenabschnitt-Cache für ein bestimmtes Netz zurück.
	 * Existiert der Cache noch nicht, wird er angelegt und dessen
	 * Initialisierung im Hintergrund angestoßen.
	 *
	 * @param netz
	 *            ein Netz
	 * @return der Cache zu dem angegebenen Netz.
	 */
	StreckenAbschnittCache getStreckenAbschnittCache(final String netz);

	/**
	 * Gibt den TMC-Cache für ein bestimmtes Netz zurück. Existiert der Cache
	 * noch nicht, wird er angelegt und dessen Initialisierung im Hintergrund
	 * angestoßen.
	 *
	 * @param netz
	 *            ein Netz.
	 * @return der Cache zu dem angegebenen Netz.
	 */
	TmcCache getTmcCache(final String netz);

	/**
	 * Gibt den TmcLocationCode-Cache zurück. Existiert der Cache noch nicht,
	 * wird er angelegt und dessen Initialisierung im Hintergrund angestoßen.
	 *
	 * @return der Cache zu dem angegebenen Netz.
	 */
	TmcLocationCodeCache getTmcLocationCodeCache();

	String getDefaultNetzPid();

}
