/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse;

import org.eclipse.ui.dialogs.PatternFilter;

/**
 * Without a Substring algorithm the original PatternFiltern doesn't find a
 * String like "ABC" in "AABC" where "BC" would be found.
 *
 * @author schnepel
 *
 */
public final class PatternOrSubstringFilter extends PatternFilter {
	private String patternString;

	@Override
	public void setPattern(final String patternString) {
		this.patternString = patternString;
		super.setPattern(patternString);
	}

	@Override
	protected boolean wordMatches(final String text) {
		return super.wordMatches(text)
				|| (text != null && text.contains(patternString));
	}
}