/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse;

import java.util.Comparator;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Damit lassen sich Listen von Systemobjekten alphabetisch (nach Pid oder Name)
 * sortieren
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class SystemObjectComparatorAlphabetical
		implements Comparator<SystemObject> {

	private final boolean compareByName;

	/**
	 * Konstruktor setzt nur das Finale Flag
	 *
	 * @param compareByName
	 *            true - Vergleich anhand des Objektnamens, sonst anhand der Pid
	 */
	public SystemObjectComparatorAlphabetical(final boolean compareByName) {
		this.compareByName = compareByName;
	}

	@Override
	public int compare(final SystemObject o1, final SystemObject o2) {
		int result = 0;
		if (o1 == null && o2 != null) {
			result = -1;
		} else if (o1 != null && o2 == null) {
			result = 1;
		} else if (o1 != null && o2 != null) {
			if (compareByName) {
				result = o1.getName().compareTo(o2.getName());
			} else {
				result = o1.getPid().compareTo(o2.getPid());
			}
		}
		return result;
	}

}
