/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

public class SystemObjectTreeContentProvider implements ITreeContentProvider {
	public static class InitialInput extends PlatformObject {
		private final SystemObject[] rootObjects;

		public InitialInput(final SystemObject[] rootObjects) {
			this.rootObjects = rootObjects;
		}

		public SystemObject[] getRootObjects() {
			return rootObjects;
		}
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		final List<SystemObject> list = new ArrayList<>();
		if (parentElement instanceof final SystemObjectType systemObjectType) {
			list.addAll(systemObjectType.getSubTypes());
			final List<SystemObject> elements = systemObjectType.getElements();
			for (final SystemObject systemObject : elements) {
				if (systemObject.getType().getPid()
						.equals(systemObjectType.getPid())
						&& !systemObjectType.equals(systemObject)) {
					list.add(systemObject);
				}
			}
		}
		return list.toArray();
	}

	@Override
	public Object getParent(final Object element) {
		if (element instanceof SystemObject
				&& !(element instanceof SystemObjectType)) {
			return ((SystemObject) element).getType();
		}
		return null;
	}

	@Override
	public boolean hasChildren(final Object element) {
		if (!(element instanceof SystemObjectType)) {
			return false;
		}
		return getChildren(element).length > 0;
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		Object element = inputElement;
		if (element instanceof InitialInput) {
			element = ((InitialInput) element).getRootObjects();
		}
		final Object[] elements = (Object[]) element;
		if (elements.length == 1) {
			return getChildren(elements[0]);
		}
		return elements;
	}

	@Override
	public void dispose() {
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput,
			final Object newInput) {
	}
}