/*
 * Rahmenwerk-Plug-in "BitCtrl-Bibliotheken"
 *
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.rw.bitctrl.eclipse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.rw.bitctrl.internal.BitCtrlRahmenwerkPlugin;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Please provide an icon named after the type of the SystemObject as PNG or GIF
 * in the folder icons of the plug-in de.bsvrz.buv.rw.bitctrl.
 *
 * @author schnepel
 */
public final class SystemObjectTypeLabelProvider extends LabelProvider {
	private final Map<SystemObject, Image> typeMap = new HashMap<>();
	private final boolean useNameForText;

	/**
	 * Constructor.
	 *
	 * uses super implementation for {@link #getText(Object)}.
	 */
	public SystemObjectTypeLabelProvider() {
		this(false);
	}

	/**
	 * Constructor.
	 *
	 * @param useNameForText
	 *            use name property of {@link SystemObject} instead of super
	 *            implementation.
	 */
	public SystemObjectTypeLabelProvider(final boolean useNameForText) {
		this.useNameForText = useNameForText;
	}

	@Override
	public Image getImage(final Object element) {
		final SystemObject so = getSystemObject(element);
		SystemObjectType type;
		if (so instanceof SystemObjectType) {
			type = (SystemObjectType) so;
		} else {
			type = so.getType();
		}
		Image image = typeMap.get(type);
		if (null == image) {
			ImageDescriptor imageDescriptor = null;
			while (imageDescriptor == null && type != null) {
				final String iconBase = "icons/" + type.getPid();
				imageDescriptor = BitCtrlRahmenwerkPlugin.getDefault()
						.getImageDescriptor(iconBase + ".png");
				if (null == imageDescriptor) {
					imageDescriptor = BitCtrlRahmenwerkPlugin.getDefault()
							.getImageDescriptor(iconBase + ".gif");
				}
				if (null == imageDescriptor) {
					final List<SystemObjectType> superTypes = type
							.getSuperTypes();
					if (1 == superTypes.size()) {
						type = superTypes.get(0);
					} else {
						type = null;
					}
				}
			}
			if (null != imageDescriptor) {
				image = imageDescriptor.createImage();
			}
			typeMap.put(so.getType(), image);
		}
		return image;
	}

	@Override
	public String getText(final Object element) {
		if (useNameForText) {
			return getSystemObject(element).getName();
		}
		return super.getText(element);
	}

	private SystemObject getSystemObject(final Object element) {
		if (element instanceof SystemObjekt) {
			return ((SystemObjekt) element).getSystemObject();
		}
		return (SystemObject) element;
	}

	@Override
	public void dispose() {
		final Iterator<Entry<SystemObject, Image>> it = typeMap.entrySet()
				.iterator();
		while (it.hasNext()) {
			final Image image = it.next().getValue();
			if (null != image) {
				image.dispose();
			}
			it.remove();
		}
		super.dispose();
	}

}
